import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::MemoryDB::ACL`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-acl.html
 */
export interface CfnACLProps {
    /**
     * `AWS::MemoryDB::ACL.ACLName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-acl.html#cfn-memorydb-acl-aclname
     */
    readonly aclName: string;
    /**
     * `AWS::MemoryDB::ACL.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-acl.html#cfn-memorydb-acl-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::MemoryDB::ACL.UserNames`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-acl.html#cfn-memorydb-acl-usernames
     */
    readonly userNames?: string[];
}
/**
 * A CloudFormation `AWS::MemoryDB::ACL`.
 *
 * @external
 * @cloudformationResource AWS::MemoryDB::ACL
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-acl.html
 */
export declare class CfnACL extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MemoryDB::ACL";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnACL;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * `AWS::MemoryDB::ACL.ACLName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-acl.html#cfn-memorydb-acl-aclname
     */
    aclName: string;
    /**
     * `AWS::MemoryDB::ACL.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-acl.html#cfn-memorydb-acl-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::MemoryDB::ACL.UserNames`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-acl.html#cfn-memorydb-acl-usernames
     */
    userNames: string[] | undefined;
    /**
     * Create a new `AWS::MemoryDB::ACL`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnACLProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::MemoryDB::Cluster`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html
 */
export interface CfnClusterProps {
    /**
     * `AWS::MemoryDB::Cluster.ClusterName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-clustername
     */
    readonly clusterName: string;
    /**
     * `AWS::MemoryDB::Cluster.ACLName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-aclname
     */
    readonly aclName?: string;
    /**
     * `AWS::MemoryDB::Cluster.AutoMinorVersionUpgrade`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-autominorversionupgrade
     */
    readonly autoMinorVersionUpgrade?: boolean | cdk.IResolvable;
    /**
     * `AWS::MemoryDB::Cluster.ClusterEndpoint`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-clusterendpoint
     */
    readonly clusterEndpoint?: CfnCluster.EndpointProperty | cdk.IResolvable;
    /**
     * `AWS::MemoryDB::Cluster.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-description
     */
    readonly description?: string;
    /**
     * `AWS::MemoryDB::Cluster.EngineVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-engineversion
     */
    readonly engineVersion?: string;
    /**
     * `AWS::MemoryDB::Cluster.FinalSnapshotName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-finalsnapshotname
     */
    readonly finalSnapshotName?: string;
    /**
     * `AWS::MemoryDB::Cluster.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::MemoryDB::Cluster.MaintenanceWindow`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-maintenancewindow
     */
    readonly maintenanceWindow?: string;
    /**
     * `AWS::MemoryDB::Cluster.NodeType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-nodetype
     */
    readonly nodeType?: string;
    /**
     * `AWS::MemoryDB::Cluster.NumReplicasPerShard`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-numreplicaspershard
     */
    readonly numReplicasPerShard?: number;
    /**
     * `AWS::MemoryDB::Cluster.NumShards`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-numshards
     */
    readonly numShards?: number;
    /**
     * `AWS::MemoryDB::Cluster.ParameterGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-parametergroupname
     */
    readonly parameterGroupName?: string;
    /**
     * `AWS::MemoryDB::Cluster.Port`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-port
     */
    readonly port?: number;
    /**
     * `AWS::MemoryDB::Cluster.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-securitygroupids
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::MemoryDB::Cluster.SnapshotArns`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-snapshotarns
     */
    readonly snapshotArns?: string[];
    /**
     * `AWS::MemoryDB::Cluster.SnapshotName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-snapshotname
     */
    readonly snapshotName?: string;
    /**
     * `AWS::MemoryDB::Cluster.SnapshotRetentionLimit`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-snapshotretentionlimit
     */
    readonly snapshotRetentionLimit?: number;
    /**
     * `AWS::MemoryDB::Cluster.SnapshotWindow`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-snapshotwindow
     */
    readonly snapshotWindow?: string;
    /**
     * `AWS::MemoryDB::Cluster.SnsTopicArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-snstopicarn
     */
    readonly snsTopicArn?: string;
    /**
     * `AWS::MemoryDB::Cluster.SnsTopicStatus`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-snstopicstatus
     */
    readonly snsTopicStatus?: string;
    /**
     * `AWS::MemoryDB::Cluster.SubnetGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-subnetgroupname
     */
    readonly subnetGroupName?: string;
    /**
     * `AWS::MemoryDB::Cluster.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::MemoryDB::Cluster.TLSEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-tlsenabled
     */
    readonly tlsEnabled?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::MemoryDB::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MemoryDB::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html
 */
export declare class CfnCluster extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MemoryDB::Cluster";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCluster;
    /**
     * @external
     * @cloudformationAttribute ARN
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute ClusterEndpoint.Address
     */
    readonly attrClusterEndpointAddress: string;
    /**
     * @external
     * @cloudformationAttribute ClusterEndpoint.Port
     */
    readonly attrClusterEndpointPort: number;
    /**
     * @external
     * @cloudformationAttribute ParameterGroupStatus
     */
    readonly attrParameterGroupStatus: string;
    /**
     * @external
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * `AWS::MemoryDB::Cluster.ClusterName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-clustername
     */
    clusterName: string;
    /**
     * `AWS::MemoryDB::Cluster.ACLName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-aclname
     */
    aclName: string | undefined;
    /**
     * `AWS::MemoryDB::Cluster.AutoMinorVersionUpgrade`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-autominorversionupgrade
     */
    autoMinorVersionUpgrade: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::MemoryDB::Cluster.ClusterEndpoint`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-clusterendpoint
     */
    clusterEndpoint: CfnCluster.EndpointProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MemoryDB::Cluster.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-description
     */
    description: string | undefined;
    /**
     * `AWS::MemoryDB::Cluster.EngineVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-engineversion
     */
    engineVersion: string | undefined;
    /**
     * `AWS::MemoryDB::Cluster.FinalSnapshotName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-finalsnapshotname
     */
    finalSnapshotName: string | undefined;
    /**
     * `AWS::MemoryDB::Cluster.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::MemoryDB::Cluster.MaintenanceWindow`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-maintenancewindow
     */
    maintenanceWindow: string | undefined;
    /**
     * `AWS::MemoryDB::Cluster.NodeType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-nodetype
     */
    nodeType: string | undefined;
    /**
     * `AWS::MemoryDB::Cluster.NumReplicasPerShard`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-numreplicaspershard
     */
    numReplicasPerShard: number | undefined;
    /**
     * `AWS::MemoryDB::Cluster.NumShards`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-numshards
     */
    numShards: number | undefined;
    /**
     * `AWS::MemoryDB::Cluster.ParameterGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-parametergroupname
     */
    parameterGroupName: string | undefined;
    /**
     * `AWS::MemoryDB::Cluster.Port`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-port
     */
    port: number | undefined;
    /**
     * `AWS::MemoryDB::Cluster.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-securitygroupids
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::MemoryDB::Cluster.SnapshotArns`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-snapshotarns
     */
    snapshotArns: string[] | undefined;
    /**
     * `AWS::MemoryDB::Cluster.SnapshotName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-snapshotname
     */
    snapshotName: string | undefined;
    /**
     * `AWS::MemoryDB::Cluster.SnapshotRetentionLimit`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-snapshotretentionlimit
     */
    snapshotRetentionLimit: number | undefined;
    /**
     * `AWS::MemoryDB::Cluster.SnapshotWindow`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-snapshotwindow
     */
    snapshotWindow: string | undefined;
    /**
     * `AWS::MemoryDB::Cluster.SnsTopicArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-snstopicarn
     */
    snsTopicArn: string | undefined;
    /**
     * `AWS::MemoryDB::Cluster.SnsTopicStatus`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-snstopicstatus
     */
    snsTopicStatus: string | undefined;
    /**
     * `AWS::MemoryDB::Cluster.SubnetGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-subnetgroupname
     */
    subnetGroupName: string | undefined;
    /**
     * `AWS::MemoryDB::Cluster.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::MemoryDB::Cluster.TLSEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html#cfn-memorydb-cluster-tlsenabled
     */
    tlsEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::MemoryDB::Cluster`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClusterProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MemoryDB::Cluster`.
 *
 * @external
 * @cloudformationResource AWS::MemoryDB::Cluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-cluster.html
 */
export declare namespace CfnCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-memorydb-cluster-endpoint.html
     */
    interface EndpointProperty {
        /**
         * `CfnCluster.EndpointProperty.Address`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-memorydb-cluster-endpoint.html#cfn-memorydb-cluster-endpoint-address
         */
        readonly address?: string;
        /**
         * `CfnCluster.EndpointProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-memorydb-cluster-endpoint.html#cfn-memorydb-cluster-endpoint-port
         */
        readonly port?: number;
    }
}
/**
 * Properties for defining a `AWS::MemoryDB::ParameterGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-parametergroup.html
 */
export interface CfnParameterGroupProps {
    /**
     * `AWS::MemoryDB::ParameterGroup.ParameterGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-parametergroup.html#cfn-memorydb-parametergroup-parametergroupname
     */
    readonly parameterGroupName: string;
    /**
     * `AWS::MemoryDB::ParameterGroup.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-parametergroup.html#cfn-memorydb-parametergroup-description
     */
    readonly description?: string;
    /**
     * `AWS::MemoryDB::ParameterGroup.Family`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-parametergroup.html#cfn-memorydb-parametergroup-family
     */
    readonly family?: string;
    /**
     * `AWS::MemoryDB::ParameterGroup.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-parametergroup.html#cfn-memorydb-parametergroup-parameters
     */
    readonly parameters?: any | cdk.IResolvable;
    /**
     * `AWS::MemoryDB::ParameterGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-parametergroup.html#cfn-memorydb-parametergroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::MemoryDB::ParameterGroup`.
 *
 * @external
 * @cloudformationResource AWS::MemoryDB::ParameterGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-parametergroup.html
 */
export declare class CfnParameterGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MemoryDB::ParameterGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnParameterGroup;
    /**
     * @external
     * @cloudformationAttribute ARN
     */
    readonly attrArn: string;
    /**
     * `AWS::MemoryDB::ParameterGroup.ParameterGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-parametergroup.html#cfn-memorydb-parametergroup-parametergroupname
     */
    parameterGroupName: string;
    /**
     * `AWS::MemoryDB::ParameterGroup.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-parametergroup.html#cfn-memorydb-parametergroup-description
     */
    description: string | undefined;
    /**
     * `AWS::MemoryDB::ParameterGroup.Family`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-parametergroup.html#cfn-memorydb-parametergroup-family
     */
    family: string | undefined;
    /**
     * `AWS::MemoryDB::ParameterGroup.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-parametergroup.html#cfn-memorydb-parametergroup-parameters
     */
    parameters: any | cdk.IResolvable | undefined;
    /**
     * `AWS::MemoryDB::ParameterGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-parametergroup.html#cfn-memorydb-parametergroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MemoryDB::ParameterGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnParameterGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::MemoryDB::SubnetGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-subnetgroup.html
 */
export interface CfnSubnetGroupProps {
    /**
     * `AWS::MemoryDB::SubnetGroup.SubnetGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-subnetgroup.html#cfn-memorydb-subnetgroup-subnetgroupname
     */
    readonly subnetGroupName: string;
    /**
     * `AWS::MemoryDB::SubnetGroup.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-subnetgroup.html#cfn-memorydb-subnetgroup-description
     */
    readonly description?: string;
    /**
     * `AWS::MemoryDB::SubnetGroup.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-subnetgroup.html#cfn-memorydb-subnetgroup-subnetids
     */
    readonly subnetIds?: string[];
    /**
     * `AWS::MemoryDB::SubnetGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-subnetgroup.html#cfn-memorydb-subnetgroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::MemoryDB::SubnetGroup`.
 *
 * @external
 * @cloudformationResource AWS::MemoryDB::SubnetGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-subnetgroup.html
 */
export declare class CfnSubnetGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MemoryDB::SubnetGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSubnetGroup;
    /**
     * @external
     * @cloudformationAttribute ARN
     */
    readonly attrArn: string;
    /**
     * `AWS::MemoryDB::SubnetGroup.SubnetGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-subnetgroup.html#cfn-memorydb-subnetgroup-subnetgroupname
     */
    subnetGroupName: string;
    /**
     * `AWS::MemoryDB::SubnetGroup.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-subnetgroup.html#cfn-memorydb-subnetgroup-description
     */
    description: string | undefined;
    /**
     * `AWS::MemoryDB::SubnetGroup.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-subnetgroup.html#cfn-memorydb-subnetgroup-subnetids
     */
    subnetIds: string[] | undefined;
    /**
     * `AWS::MemoryDB::SubnetGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-subnetgroup.html#cfn-memorydb-subnetgroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MemoryDB::SubnetGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubnetGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::MemoryDB::User`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-user.html
 */
export interface CfnUserProps {
    /**
     * `AWS::MemoryDB::User.AccessString`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-user.html#cfn-memorydb-user-accessstring
     */
    readonly accessString: string;
    /**
     * `AWS::MemoryDB::User.AuthenticationMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-user.html#cfn-memorydb-user-authenticationmode
     */
    readonly authenticationMode: any | cdk.IResolvable;
    /**
     * `AWS::MemoryDB::User.UserName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-user.html#cfn-memorydb-user-username
     */
    readonly userName: string;
    /**
     * `AWS::MemoryDB::User.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-user.html#cfn-memorydb-user-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::MemoryDB::User`.
 *
 * @external
 * @cloudformationResource AWS::MemoryDB::User
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-user.html
 */
export declare class CfnUser extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MemoryDB::User";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnUser;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * `AWS::MemoryDB::User.AccessString`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-user.html#cfn-memorydb-user-accessstring
     */
    accessString: string;
    /**
     * `AWS::MemoryDB::User.AuthenticationMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-user.html#cfn-memorydb-user-authenticationmode
     */
    authenticationMode: any | cdk.IResolvable;
    /**
     * `AWS::MemoryDB::User.UserName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-user.html#cfn-memorydb-user-username
     */
    userName: string;
    /**
     * `AWS::MemoryDB::User.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-memorydb-user.html#cfn-memorydb-user-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MemoryDB::User`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
