# ruff: noqa: E501, N815, D101, D102, N802
"""Python schema for hpk.capnp.

This file is generated and contains a Cap'n Proto schema in packed binary format;
specifically a serialized reflection_capnp.CapSchema message with the typeId field
not set.

The schema has been compiled from the file hpk.capnp.

This file contains the following schema nodes:
#   - capnp/c++.capnp:allowCancellation @0xac7096ff8cfc9dce
#   - capnp/c++.capnp:namespace @0xb9c6f99ebf805f2c
#   - zhinst/io/protocol/capnp/reflection/reflection.capnp:Reflection @0xf9a52e68104bc776
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session @0xb9d445582da4a55c
#   - hpk.capnp:Hpk @0xa621130a90860008
#   - zhinst/io/protocol/capnp/reflection/reflection.capnp:Reflection.getTheSchema$Params @0x86a77be57bfa08f7
#   - zhinst/io/protocol/capnp/reflection/reflection.capnp:CapSchema @0xcb31ef7a76eb85cf
#   - zhinst/io/protocol/capnp/reflection/reflection.capnp:Reflection.getTheSchema$Results @0xc9db2193e1883dd1
#   - zhinst/io/protocol/capnp/reflection/reflection.capnp:Reflection.getReflectionVersion$Params @0xe3e32fd4d93c1199
#   - zhinst/io/protocol/capnp/reflection/reflection.capnp:Reflection.getReflectionVersion$Results @0xfb31a67fd905411a
#   - capnp/schema.capnp:Node @0xe682ab4cf923a417
#   - capnp/schema.capnp:ElementSize @0xd1958f7dba521926
#   - capnp/schema.capnp:Field @0x9aad50a41f4af45f
#   - capnp/schema.capnp:Node.struct @0x9ea0b19b37fb4435
#   - capnp/schema.capnp:Enumerant @0x978a7cebdc549a4d
#   - capnp/schema.capnp:Node.enum @0xb54ab3364333f598
#   - capnp/schema.capnp:Method @0x9500cce23b334d80
#   - capnp/schema.capnp:Superclass @0xa9962a9ed0a4d7f8
#   - capnp/schema.capnp:Node.interface @0xe82753cff0c2218f
#   - capnp/schema.capnp:Type @0xd07378ede1f9cc60
#   - capnp/schema.capnp:Value @0xce23dcd2d7b00c9b
#   - capnp/schema.capnp:Node.const @0xb18aa5ac7a0d9420
#   - capnp/schema.capnp:Node.annotation @0xec1619d4400a0290
#   - capnp/schema.capnp:Node.NestedNode @0xdebf55bbfa0fc242
#   - capnp/schema.capnp:Annotation @0xf1c8950dab257542
#   - capnp/schema.capnp:Node.Parameter @0xb9521bccf10fa3b1
#   - capnp/schema.capnp:Brand @0x903455f06065422b
#   - capnp/schema.capnp:Brand.Scope @0xabd73485a9636bc9
#   - capnp/schema.capnp:Brand.Binding @0xc863cd16969ee7fc
#   - capnp/schema.capnp:Type.list @0x87e739250a60ea97
#   - capnp/schema.capnp:Type.enum @0x9e0e78711a7f87a9
#   - capnp/schema.capnp:Type.struct @0xac3a6f60ef4cc6d3
#   - capnp/schema.capnp:Type.interface @0xed8bca69f7fb0cbf
#   - capnp/schema.capnp:Type.anyPointer.unconstrained @0x8e3b5f79fe593656
#   - capnp/schema.capnp:Type.anyPointer.parameter @0x9dd1f724f4614a85
#   - capnp/schema.capnp:Type.anyPointer.implicitMethodParameter @0xbaefc9120c56e274
#   - capnp/schema.capnp:Type.anyPointer @0xc2573fe8a23e49f1
#   - capnp/schema.capnp:Field.slot @0xc42305476bb4746f
#   - capnp/schema.capnp:Field.group @0xcafccddb68db1d11
#   - capnp/schema.capnp:Field.ordinal @0xbb90d5c287870be6
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.listNodes$Params @0x92035429255ef5a8
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.listNodes$Results @0xebd34bdb74c961b0
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.deprecatedGetValues$Params @0xcd242e1bb990dfe7
#   - zhinst/io/protocol/capnp/common/result.capnp:Result @0xbab0f33e1934323d
#   - zhinst/io/protocol/capnp/common/value.capnp:AnnotatedValue @0xf408ee376e837cdc
#   - zhinst/io/protocol/capnp/common/error.capnp:Error @0xc4e34e4c517d11d9
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.deprecatedGetValues$Results @0xe948518c129575bb
#   - zhinst/io/protocol/capnp/common/value.capnp:Value @0xb1838b4771be75ac
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:ReturnFromSetWhen @0xdd2da53aac55edf9
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.deprecatedSetValue$Params @0xa8f6fded40f38065
#   - zhinst/io/protocol/capnp/common/value.capnp:VoidStruct @0xdf7fe8e981437816
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.deprecatedSetValue$Results @0x8aef0146a9595df9
#   - zhinst/io/protocol/capnp/streaming/streaming.capnp:Subscription @0xedac21a53de1b1d4
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.subscribe$Params @0xb9b18be9afb1b3e4
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.subscribe$Results @0xa0ca6692df48c93f
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.disconnectDevice$Params @0xe682e60b2cd90782
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.listNodesJson$Params @0xcd837fe86531f6c1
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.listNodesJson$Results @0xa8151642645bfa32
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.unsubscribe$Params @0xb16a1640db91e61c
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.getSessionVersion$Params @0xd77d14cf14b3405a
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.getSessionVersion$Results @0xcc68434da57cf6b3
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.deprecatedSetValue2$Params @0xdae05cd32680aba1
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.deprecatedSetValue2$Results @0xfd47648e56c0e689
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:LookupMode @0xda5049b5e072f425
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.setValue$Params @0x9fe29a10493e27c7
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.setValue$Results @0x9474d85f26f63900
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.getValue$Params @0xc5e872236cc4917b
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.getValue$Results @0xce98719dbad0a401
#   - zhinst/io/protocol/capnp/session/session_protocol.capnp:Session.cancel$Params @0xb77c3d30c74311fc
#   - zhinst/io/protocol/capnp/common/value.capnp:AnnotatedValue.Metadata @0xad53d8ca57af3018
#   - zhinst/io/protocol/capnp/common/complex.capnp:Complex @0xaaf1afaf97b4b157
#   - zhinst/io/protocol/capnp/common/value.capnp:VectorData @0x994c65b80df38978
#   - zhinst/io/protocol/capnp/common/value.capnp:CntSample @0xe9370bd8287d6065
#   - zhinst/io/protocol/capnp/common/value.capnp:TriggerSample @0xdeb72097c27d0d95
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfDemodulatorVectorData @0x9b03e3e3e6006582
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfResultLoggerVectorData @0xbba061f579761ddd
#   - zhinst/io/protocol/capnp/common/value.capnp:LargeVectorData @0xd948f7b09959b00a
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfScopeVectorData @0xa9b07f1f82a93bc9
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfGeneratorWaveformVectorData @0xedcfe06e81c4f3d0
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfPidVectorData @0xff6ee171549a2870
#   - zhinst/io/protocol/capnp/common/error.capnp:ErrorKind @0xb7e671e24a9802bd
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfDemodulatorVectorData.properties @0xd475786ca25c300d
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfResultLoggerVectorData.properties @0xddb7b421ea0eec5e
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfResultLoggerVectorData.vector @0x980b68b5449bdf12
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfScopeVectorData.properties @0xd707b876f9608924
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfScopeVectorData.vector @0xd10aab878c8e14bc
#   - zhinst/io/protocol/capnp/common/shf_vectors.capnp:ShfPidVectorData.properties @0x9be09d0677995544
#   - zhinst/io/protocol/capnp/streaming/streaming.capnp:StreamingHandle @0xf51e28a7f5b41574
#   - zhinst/io/protocol/capnp/common/kwargs.capnp:Kwargs @0x8f25ce07a664cee0
#   - zhinst/io/protocol/capnp/streaming/streaming.capnp:StreamingHandle.sendValues$Params @0xa30bad0f967c47b6
#   - capnp/stream.capnp:StreamResult @0x995f9a3377c0b16e
#   - zhinst/io/protocol/capnp/common/kwargs.capnp:Kwargs.Entry @0xa2644e6fd3dc2553

"""

from __future__ import annotations

import typing as t
import warnings

import zhinst.comms
from packaging.version import Version

_GENERATED_WITH = Version("3.0.1")


def _check_version_compatibility() -> None:
    runtime_version = Version(zhinst.comms.__version__)
    if runtime_version.major != _GENERATED_WITH.major:
        warnings.warn(
            f"You are using zhinst.comms version {runtime_version}, but the schema in '{__name__}' was "
            f"generated using version {_GENERATED_WITH}. It is recommended to regenerate "
            "this file using the 'compile' command.",
            stacklevel=3,
        )


_check_version_compatibility()

_CAPNP_BINARY_SCHEMA = b"IQMEM/8D+QcDGQxQAQEAADEBpx9TcAEFBv/OnfyM/5ZwrADREAUBA/+BTjC4e334vQAAATO5DxIBE8kPBwAAEQIB\
AAH/LF+Av575xrkAURAFAf+BTjC4e334vQAAAREqAROhDwcAABFSAQAB/3bHSxBoLqX5ABE1A/8OrTlskcJhhAAA\
ARF6ARHCAQAAEfoBE20PBwAA/1ylpC1YRdS5ABE4A/9Hc0PViRLCtgAAARPCAQETCgIBAAATQgIBE5IGAQAA/QiG\
kAoTIaYRCgP/Ps6GC7EbtOUAAAETogYBE7oGAQAAE8oGARPaBgEAAP/3CPp75XunhgARQAEAAAQHAAATCgcBAAT/\
z4XrdnrvMcsAUTUBAf8OrTlskcJhhAAFAQcAABNqBwETsgcBAAATwgcBAAH/0T2I4ZMh28kAEUABAAAFAQcAABPq\
CAEAARNKCQEAAf+ZETzZ1C/j4wARQAEAAAQHAAAT2gkBAAT/GkEF2X+mMfsAEUABAAAFAQcAABNCCgEAAROqCgEA\
Af8XpCP5TKuC5gBREwEF/9lyTGIJxT+pAEUGBwYBBhMyCwETUgsBAAATwgsBAAH/JhlSun2PldEAERMC/9lyTGIJ\
xT+pAAABE/IRARMaEgEAABMqEgEAAf9f9EofpFCtmgBREwED/9lyTGIJxT+pAEUEBwIBBBNaEwETghMBAAATshMB\
AAH/NUT7N5uxoJ4AURgBBf8XpCP5TKuC5gAVBgcBAAATohYBAAETyhYBAAH/TZpU3Ot8ipcAURMBAf/ZckxiCcU/\
qQAFAgcAABOCGgETqhoBAAATuhoBAAH/mPUzQzazSrUAURgBBf8XpCP5TKuC5gAVBgcBAAATYhwBAAETihwBAAG/\
gE0zO+LMlVETAQP/2XJMYgnFP6kABQUHAAATOh0BE2IdAQAAE3IdAQAB//jXpNCeKpapAFETAQH/2XJMYgnFP6kA\
BQEHAAATUgICE3oCAgAAE4oCAgAB/48hwvDPUyfoAFEYAQX/F6Qj+UyrguYAFQYHAQAAE4oDAgABE7oDAgAB/2DM\
+eHteHPQAFETAQP/2XJMYgnFP6kARQEHEwAAEwIFAhMiBQIAABMyBQIAAf+bDLDX0twjzgBREwEC/9lyTGIJxT+p\
AEUBBxMAABMiDQITSg0CAAATWg0CAAH/IJQNeqylirEAURgBBf8XpCP5TKuC5gAVBgcBAAATYhYCAAETihYCAAH/\
kAIKQNQZFuwAURgBBf8XpCP5TKuC5gAVBgcBAAATihcCAAETuhcCAAH/QsIP+rtVv94AURgBAf8XpCP5TKuC5gAF\
AQcAABNaHgITih4CAAATmh4CAAH/QnUlqw2VyPEAURMBAf/ZckxiCcU/qQAFAgcAABOaHwITwh8CAAAT0h8CAAH/\
saMP8cwbUrkAERgB/xekI/lMq4LmAAUBBwAAE0ohAhN6IQIAABOKIQIAAf8rQmVg8FU0kAAREwH/2XJMYgnFP6kA\
BQEHAAATEiICEzoiAgAAE3oiAgAB/8lrY6mFNNerAFEZAQL/K0JlYPBVNJAARQEHAgEEEyIjAhNKIwIAABNaIwIA\
Af/8556WFs1jyABRGQEB/ytCZWDwVTSQAEUBBwIAABPyJAITIiUCAAATMiUCAAH/l+pgCiU554cAURgBA/9gzPnh\
7Xhz0AAVAQcBAAATMiYCAAETWiYCAAH/qYd/GnF4Dp4AURgBA/9gzPnh7Xhz0AAVAQcBAAAT6iYCAAETEicCAAH/\
08ZM72BvOqwAURgBA/9gzPnh7Xhz0AAVAQcBAAATEigCAAETOigCAAH/vwz792nKi+0AURgBA/9gzPnh7Xhz0AAV\
AQcBAAATOikCAAETaikCAAH/VjZZ/nlfO44AUSMBA//xST6i6D9XwgBVAQcBBAEFE2oqAgABE6oqAgAB/4VKYfQk\
99GdAFEjAQP/8Uk+oug/V8IAFQEHAQAAE6IsAgABE9osAgAB/3TiVgwSye+6AFEjAQP/8Uk+oug/V8IAFQEHAQAA\
E+ItAgABEyouAgAB//FJPqLoP1fCAFEYAQP/YMz54e14c9AAVQEHAQMBBBO6LgIAARPqLgIAAf9vdLRrRwUjxABR\
GQED/1/0Sh+kUK2aABUEBwEAABPaLwIAARMCMAIAAf8RHdto2838ygBRGQED/1/0Sh+kUK2aABUEBwEAABMKMgIA\
ARMyMgIAAf/mC4eHwtWQuwBRGQED/1/0Sh+kUK2aAFUEBwECAQUTujICAAET6jICAAH/qPVeJSlUA5IAUUABAQAA\
BQIHAAAT+jMCAAETWjQCAAH/sGHJdNtL0+sAEUABAAAFAQcAABPaNQIAARM6NgIAAf/n35C5Gy4kzQARQAEAAAUC\
BwAAE+I2AgABE0o3AgAB/z0yNBk+87C6AFEtAQH/1auk3B/j6PcARQEHAhABE2o4AhOqOAIAABO6OAIAABO6OQL/\
3HyDbjfuCPQAESwB/8e8JTSyy6X8AAUCBwAAE+o5AhMyOgIAABNiOgIAAf/ZEX1RTE7jxABRLAEB/+ubuSzWYnC5\
AAUDBwAAE2o7AhOqOwIAABO6OwIAAf+7dZUSjFFI6QARQAEAAAUBBwAAEyo+AgABE5I+AgAB/6x1vnFHi4OxAFEs\
AQL/x7wlNLLLpfwARQEHEgEEEQIDEUIDAAARUgMAAf/57VWsOqUt3QAROAL/R3ND1YkSwrYAAAETmgkDE/IJAwAA\
EwIKAwAB/2WA80Dt/faoAFFAAQEAAAUCBwAAE7IKAwABExoLAwAB/xZ4Q4Hp6H/fABEsAf/HvCU0ssul/AAEBwAA\
E5oMAxPaDAMAA//5XVmpRgHvigARQAEAAAUBBwAAE+oMAwABE1INAwAB/9Sx4T2lIaztABEzAf/IdJxrBfSTzAAF\
BAcAABNqDgMTsg4DAAATwg4DAAH/5LOxr+mLsbkAEUABAAAFAQcAABPCEAMAARMiEQMAAf8/yUjfkmbKoAARQAEA\
AAUBBwAAE7IRAwABExISAwAB/4IH2SwL5oLmABFAAQAABAcAABMqEwMABP/B9jFl6H+DzQBRQAEBAAAFAgcAABOK\
EwMAARPqEwMAAf8y+ltkQhYVqAARQAEAAAUBBwAAE2oVAwABE8oVAwAB/xzmkdtAFmqxABFAAQAABQIHAAATWhYD\
AAETuhYDAAH/WkCzFM8UfdcAEUABAAAEBwAAE+IXAwAE/7P2fKVNQ2jMABFAAQAABQEHAAATShgDAAETshgDAAH/\
oauAJtNc4NoAUUABAQAABQMHAAATOhkDAAETohkDAAH/iebAVo5kR/0AEUABAAAFAQcAABOaGwMAARMCHAMAAf8l\
9HLgtUlQ2gAROAL/R3ND1YkSwrYAAAETGh0DE2odAwAAE3odAwAB/8cnPkkQmuKfAFFAAQEAAAUDBwAAE9odAwAB\
EzIeAwAB/jn2Jl/YdJQRQAEAAAUBBwAAE7IgAwABExIhAwAB/3uRxGwjcujFAFFAAQEAAAUCBwAAE0oiAwABE6Ii\
AwAB/wGk0LqdcZjOABFAAQAABQEHAAAToiQDAAETAiUDAAH//BFDxzA9fLcAEUABAAAFAQcAABM6JgMAAROSJgMA\
Af8YMK9XythTrQBROwEB/9x8g2437gj0AAUBBwAAExonAxNqJwMAABN6JwMAAf9XsbSXr6/xqgBRLgEC/+lQjv4W\
FGPRAAQHAAATgigDE8IoAwAAE9IoAwAB/3iJ8w24ZUyZAFEsAQH/x7wlNLLLpfwABQEHAAAT0ikDExIqAwAAEyIq\
AwAB/2VgfSjYCzfpAFEsAQL/x7wlNLLLpfwABAcAABMyLAMTciwDAAATgiwDAAH/lQ19wpcgt94AUSwBBf/HvCU0\
ssul/AAEBwAAEwIuAxNKLgMAABNaLgMAAfuCZebj4wObUTIBCP+UTWR/GIOdtAAFAgcAABPaMQMTMjIDAAATQjID\
AAH/3R12efVhoLsAUTIBCf+UTWR/GIOdtAAFAQcAABPKMwMTIjQDAAATMjQDAAH/CrBZmbD3SNkAUSwBAf/HvCU0\
ssul/AAFAQcAABPKNAMTEjUDAAATIjUDAAH/yTupgh9/sKkAUTIBCf+UTWR/GIOdtAAFAQcAABNaNwMTqjcDAAAT\
ujcDAAH/0PPEgW7gz+0AETIB/5RNZH8Yg520AAUBBwAAE1I4AxOyOAMAABPCOAMAAf9wKJpUceFu/wBRMgEI/5RN\
ZH8Yg520AAUCBwAAE2o5AxO6OQMAABPKOQMAAf+9AphK4nHmtwARLAL/65u5LNZicLkAAAETUjsDE5I7AwAAE6I7\
AwAB/w0wXKJseHXUAFFLAQj7gmXm4+MDmxUCBwEAABMqPQMAAROKPQMAAf9e7A7qIbS33QBRTAEJ/90ddnn1YaC7\
ABUBBwEAABMaRAMAARN6RAMAAf8S35tEtWgLmABRTAEJ/90ddnn1YaC7AFUBBwECAR0ToksDAAETAkwDAAH/JIlg\
+Xa4B9cAUUUBCf/JO6mCH3+wqQAVAQcBAAATQk0DAAETmk0DAAH/vBSOjIerCtEAUUUBCf/JO6mCH3+wqQBVAQcB\
AgEgE7pTAwABExJUAwAB/0RVmXcGneCbAFFDAQj/cCiaVHHhbv8AFQIHAQAAE1JVAwABE6pVAwAB/3QVtPWnKB71\
ABEzA//IdJxrBfSTzAAAARMyXAMTglwDAAATklwDE/pcAwAA/+DOZKYHziWPABEtAf/EzBMjqgRAzAAFAQcAABMK\
XQMTSl0DAAATcl0DAAH/tkd8lg+tC6MAEUMBAAAFAQcAABMaXgMAARN6XgMAAf9uscB3M5pfmQAREwH/+POTE6lm\
w4YABAcAABMiXwMTSl8DAAP/UyXc029OZKIAETQB/+DOZKYHziWPAAUCBwAAE1pfAxOiXwMAABOyXwMAAf9jYXBu\
cC9jKwMrLmNhcG5wOmFsbG93Q2FuY2VsbGF0aW8BblABAVABAVABAVADAQADEQHS/2NhcG5wL2MrAisuY2FwbnA6\
bmFtZXNwYWMBZVADAQEMAAIxAQIC/3poaW5zdC9pB28vcHJvdG9jb2wvY2FwbnAvcmVmbGVjdGlvbi9yZWZsZWN0\
aW9uLmNhcG5wOlJlZmxlY3Rpb24AEQEXUQQBAf9a/Q8GdeXLjAARAZL/Y2FwYWJpbGkBdHlWZXJzaW8BbhEBh1EI\
AwUBAf/3CPp75XunhgHRPYjhkyHbyRExagACESkHAAD/mRE82dQv4+MBGkEF2X+mMfsRHaoAAhEZB/9nZXRUaGVT\
YwAPaGVtYUAB/2dldFJlZmxlAWN0aW9uVmVyD3Npb25AATEBAgL/emhpbnN0L2kHby9wcm90b2NvbC9jYXBucC9z\
ZXNzaW9uL3Nlc3Npb25fcHJvdG9jb2wuY2FwbnA6U2Vzc2lvbgARARdRBAEB/9ACL5YcrlC3ABEBkv9jYXBhYmls\
aQF0eVZlcnNpbwFuMQEHA1EwAwUBAf+o9V4lKVQDkgGwYcl020vT6xNxAVIAAhNpAQcBC//n35C5Gy4kzQG7dZUS\
jFFI6RNdAaIAAhNZAQcBCf9lgPNA7f32qAH5XVmpRgHvihNNAZoAAhNJAQcBBf/ks7Gv6YuxuQE/yUjfkmbKoBM9\
AVIAAhM1AQcBB/+CB9ksC+aC5gEWeEOB6eh/3xMpAYoAAhMlAQcBCP/B9jFl6H+DzQEy+ltkQhYVqBMZAXIAAhMR\
AQcBBv8c5pHbQBZqsQEWeEOB6eh/3xMFAWIAAhH9BwAA/1pAsxTPFH3XAbP2fKVNQ2jMEfGSAAIR7QcBCv+hq4Am\
01zg2gGJ5sBWjmRH/RHhogACEd0HAQP/xyc+SRCa4p8BADn2Jl/YdJQR0UoAAhHJBwEC/3uRxGwjcujFAQGk0Lqd\
cZjOEb1KAAIRtQcBBP/8EUPHMD18twEWeEOB6eh/3xGpOgACEZ0H/2xpc3ROb2RlAAFzQAH/ZGVwcmVjYXQBZWRH\
ZXRWYWwHdWVzQAH/ZGVwcmVjYXQBZWRTZXRWYWwDdWVAAf9zdWJzY3JpYgABZUAB/2Rpc2Nvbm5lAWN0RGV2aWNl\
AABAAf9saXN0Tm9kZQAfc0pzb25AAf91bnN1YnNjcgAHaWJlQAH/Z2V0U2Vzc2kBb25WZXJzaW8BbkAB/2RlcHJl\
Y2F0AWVkU2V0VmFsB3VlMkAB/3NldFZhbHVlAAAAQAH/Z2V0VmFsdWUAAABAAT9jYW5jZWxAAREBB1ABAREBcv9o\
cGsuY2FwbgAfcDpIcGsRAQdQAQERAQdQAwURASdRCAEB/3bHSxBoLqX5AAAA/1ylpC1YRdS5AAAAMQGiAv96aGlu\
c3QvaQlvL3Byb3RvY29sL2NhcG5wL3JlZmxlY3Rpb24vcmVmbGVjdGlvbi5jYXBucDpSZWZsZWN0aW9uLmdldFRo\
ZVNjaGVtYSRQYXIHYW1zMQH6Af96aGluc3QvaQZvL3Byb3RvY29sL2NhcG5wL3JlZmxlY3Rpb24vcmVmbGVjdGlv\
bi5jYXBucDpDYXA/U2NoZW1hEQEHUAEBEQF3UQgDBAAABAEAABEpOgAAUSQDAVEwAgEBARQBAQAAES1SAABRLAMB\
UUgCAT90eXBlSWQBCQACAQkAAf90aGVTY2hlbQABYQEOAAFQAwEBEP8XpCP5TKuC5gAAAQEOAAExAaoC/3poaW5z\
dC9pCW8vcHJvdG9jb2wvY2FwbnAvcmVmbGVjdGlvbi9yZWZsZWN0aW9uLmNhcG5wOlJlZmxlY3Rpb24uZ2V0VGhl\
U2NoZW1hJFJlcw91bHRzEQE/UQQDBAAABAEAABENUgAAUQwDAVEYAgH/dGhlU2NoZW0AAWEBEP/Phet2eu8xywAA\
AQEQAAExAeIC/3poaW5zdC9pCm8vcHJvdG9jb2wvY2FwbnAvcmVmbGVjdGlvbi9yZWZsZWN0aW9uLmNhcG5wOlJl\
ZmxlY3Rpb24uZ2V0UmVmbGVjdGlvblZlcnNpb24kUGFyB2FtczEB6gL/emhpbnN0L2kKby9wcm90b2NvbC9jYXBu\
cC9yZWZsZWN0aW9uL3JlZmxlY3Rpb24uY2FwbnA6UmVmbGVjdGlvbi5nZXRSZWZsZWN0aW9uVmVyc2lvbiRSZXMP\
dWx0cxEBP1EEAwQAAAQBAAARDUIAAFEIAwFRFAIBf3ZlcnNpb24BDAACAQwAAREBwv9jYXBucC9zYwJoZW1hLmNh\
cG5wOk5vZGUAEQE3UQwBAf+xow/xzBtSuQAREVL/QsIP+rtVv94AERFa/65XEwTjHY7zABERWv9QYXJhbWV0ZQAB\
cv9OZXN0ZWRObwADZGX/U291cmNlSW4AA2ZvMQEXA1E4AwQAAAQBAAATeQEaAABTdAEDAVOAAQIBAQEUAQEAABN9\
AWIAAFN8AQMBU4gBAgERAgIUAQIAABOFAcIAAFOIAQMBU5QBAgERAwIUAQMAABORAUIAAFOMAQMBU5gBAgERBgEU\
AQQAABOVAWIAAFOUAQMBU7ABAgERBwIUAQUAABOtAWIAAFOsAQMBU8gBAgENCP//FAEGAAATxQEqAABTwAEDAVPM\
AQIBDQn+/wEB/zVE+zebsaCeABPJAToAAg0K/f8BAf+Y9TNDNrNKtQATsQEqAAINC/z/AQH/jyHC8M9TJ+gAE5kB\
UgACDQz7/wEB/yCUDXqspYqxABOFATIAAg0N+v8BAf+QAgpA1BkW7AATbQFaAAIRBAUUASAAABNZAVoAAFNYAQMB\
U3QBAgExBSABFAEhAAATcQFSAABTcAEDAVN8AQIBA2lkAQkAAgEJAAH/ZGlzcGxheU4AB2FtZQEMAAIBDAAB/2Rp\
c3BsYXlOAmFtZVByZWZpeExlbmd0aAABCAACAQgAAX9zY29wZUlkAQkAAgEJAAH/bmVzdGVkTm8AB2RlcwEOAAFQ\
AwEBEP9Cwg/6u1W/3gAAAQEOAAH/YW5ub3RhdGkAB29ucwEOAAFQAwEBEP9CdSWrDZXI8QAAAQEOAAEPZmlsZQAG\
P3N0cnVjdA9lbnVt/2ludGVyZmFjAAFlH2NvbnN0/2Fubm90YXRpAANvbv9wYXJhbWV0ZQADcnMBDgABUAMBARD/\
saMP8cwbUrkAAAEBDgAB/2lzR2VuZXJpAAFjAQEAAgEBAAERAfr/Y2FwbnAvc2MCaGVtYS5jYXBucDpFbGVtZT9u\
dFNpemURAQdQAQERAcdRIAECAAARWTIAAAEBEVEiAAABAhFJKgAAAQMRQUoAAAEEET1SAAABBRE5WgAAAQYRNUIA\
AAEHES2CAAAfZW1wdHkHYml0D2J5dGX/dHdvQnl0ZXMAAAD/Zm91ckJ5dGUAAXP/ZWlnaHRCeXQAA2Vzf3BvaW50\
ZXL/aW5saW5lQ28BbXBvc2l0ZQARAcr/Y2FwbnAvc2MCaGVtYS5jYXBucDpGaWVsZAAAEQEXUQQBAf8Sx/58vkyx\
lwARAXr/bm9EaXNjcmkAP21pbmFudDEBjwFRHAMEAAAEAQAAEbUqAABRsAMBUbwCAQEBFAEBAAARuVIAAFG4AwFR\
xAIBEQIBFAECAAARwWIAAFHAAwFR3AIBEQMBFAEDAQER2ZIAAFHcAwFR6AIBDQT//wEB/290tGtHBSPEABHlKgAC\
DQX+/wEB/xEd22jbzfzKABHNMgACAQYBAf/mC4eHwtWQuwARtUIAAg9uYW1lAQwAAgEMAAH/Y29kZU9yZGUAAXIB\
BwACAQcAAf9hbm5vdGF0aQAHb25zAQ4AAVADAQEQ/0J1JasNlcjxAAABAQ4AAf9kaXNjcmltaQFuYW50VmFsdQFl\
AQcAAg0H//8AAQ9zbG90H2dyb3Vwf29yZGluYWwRAfr/Y2FwbnAvc2MCaGVtYS5jYXBucDpOb2RlLj9zdHJ1Y3Qx\
AY8BURwDBBAHFAEHAAARtXIAAFG0AwFRwAIBEQEMFAEIAAARvWoAAFG8AwFRyAIBEQINFAEJAAARxbIAAFHIAwFR\
1AIBEQPgFAEKAAAR0UIAAFHMAwFR2AIBEQQPFAELAAAR1ZIAAFHYAwFR5AIBEQUIFAEMAAAR4ZoAAFHkAwFR8AIB\
EQYDFAENAAAR7ToAAFHoAwFTBAECAf9kYXRhV29yZAAfQ291bnQBBwACAQcAAf9wb2ludGVyQwAPb3VudAEHAAIB\
BwAB/3ByZWZlcnJlAWRMaXN0RW5jH29kaW5nAQ//JhlSun2PldEAAAEBDwABf2lzR3JvdXABAQACAQEAAf9kaXNj\
cmltaQFuYW50Q291bgF0AQcAAgEHAAH/ZGlzY3JpbWkBbmFudE9mZnMDZXQBCAACAQgAAT9maWVsZHMBDgABUAMB\
ARD/X/RKH6RQrZoAAAEBDgABEQHq/2NhcG5wL3NjAmhlbWEuY2FwbnA6RW51bWUPcmFudBEBB1ABAREBr1EMAwQA\
AAQBAAARRSoAAFFAAwFRTAIBAQEUAQEAABFJUgAAUUgDAVFUAgERAgEUAQIAABFRYgAAUVADAVFsAgEPbmFtZQEM\
AAIBDAAB/2NvZGVPcmRlAAFyAQcAAgEHAAH/YW5ub3RhdGkAB29ucwEOAAFQAwEBEP9CdSWrDZXI8QAAAQEOAAER\
Aer/Y2FwbnAvc2MCaGVtYS5jYXBucDpOb2RlLg9lbnVtEQE/UQQDBBADFAEOAAARDVoAAFEMAwFRKAIB/2VudW1l\
cmFuAAN0cwEOAAFQAwEBEP9NmlTc63yKlwAAAQEOAAERAdL/Y2FwbnAvc2MCaGVtYS5jYXBucDpNZXRobwFkEQEH\
UAEBMQHHAVEgAwQAAAQBAAAR0SoAAFHMAwFR2AIBAQEUAQEAABHVUgAAUdQDAVHgAgERAwEUAQIAABHdggAAUdwD\
ARECAhEFAhQBAwAAESICAAARQgIRagIRBwEUAQQAABGKAgAAEaICEeoCEQQCFAEFAAATCgECAAATIgECE0oBAhEG\
AxQBBgAAE2oBAgAAE4IBAhOqAQIRAgQUAQcAABPKAQIAABPqAQITMgICD25hbWUBDAACAQwAAf9jb2RlT3JkZQAB\
cgEHAAIBBwAB/3BhcmFtU3RyAXVjdFR5cGUAAQkAAlACAQEJAAERAYr/cmVzdWx0U3QBcnVjdFR5cGUAAFADAQEJ\
AAJQAgEBCQABEQFi/2Fubm90YXRpAAdvbnNQAwEBDgABUAMBARD/QnUlqw2VyPEAAAFQAgEBDgABEQFa/3BhcmFt\
QnJhAANuZFADAQEQ/ytCZWDwVTSQAAABUAIBARAAAREBYv9yZXN1bHRCcgAHYW5kUAMBARD/K0JlYPBVNJAAAAFQ\
AgEBEAABEQGa/2ltcGxpY2l0AVBhcmFtZXRlA3JzUAMBAQ4AAVADAQEQ/7GjD/HMG1K5AAABUAIBAQ4AAREB8v9j\
YXBucC9zYwJoZW1hLmNhcG5wOlN1cGVyH2NsYXNzEQEHUAEBEQF3UQgDBAAABAEAABEpGgAAUSQDAVEwAgEBARQB\
AQAAES0yAABRKAMBUTQCAQNpZAEJAAIBCQABH2JyYW5kARD/K0JlYPBVNJAAAAEBEAABMQESAf9jYXBucC9zYwNo\
ZW1hLmNhcG5wOk5vZGUuaW50ZXJmYWMBZREBd1EIAwQQAxQBDwAAESlCAABRJAMBUUACAREBBBQBHwAAET1qAABR\
PAMBUVgCAX9tZXRob2RzAQ4AAVADAQEQv4BNMzvizJUAAQEOAAH/c3VwZXJjbGEAD3NzZXMBDgABUAMBARD/+Nek\
0J4qlqkAAAEBDgABEQHC/2NhcG5wL3NjAmhlbWEuY2FwbnA6VHlwZQARAQdQAQExAS8EUUwDBAz//wQBAAATBQIq\
AABSAgMBUwwCAgENAf7/FAEBAAATCQIqAABTBAIDAVMQAgIBDQL9/xQBAgAAEw0CKgAAUwgCAwFTFAICAQ0D/P8U\
AQMAABMRAjIAAFMMAgMBUxgCAgENBPv/FAEEAAATFQIyAABTEAIDAVMcAgIBDQX6/xQBBQAAExkCMgAAUxQCAwFT\
IAICAQ0G+f8UAQYAABMdAjIAAFMYAgMBUyQCAgENB/j/FAEHAAATIQI6AABTHAIDAVMoAgIBDQj3/xQBCAAAEyUC\
OgAAUyACAwFTLAICAQ0J9v8UAQkAABMpAjoAAFMkAgMBUzACAgENCvX/FAEKAAATLQJCAABTKAIDAVM0AgIBDQv0\
/xQBCwAAEzECQgAAUywCAwFTOAICAQ0M8/8UAQwAABM1AioAAFMwAgMBUzwCAgENDfL/FAENAAATOQIqAABTNAID\
AVNAAgIBDQ7x/wEB/5fqYAolOeeHABM9AioAAg0P8P8BAf+ph38acXgOngATJQIqAAINEO//AQH/08ZM72BvOqwA\
Ew0COgACDRHu/wEB/78M+/dpyovtABP1AVIAAg0S7f8BAf/xST6i6D9XwgAT4QFaAAIPdm9pZAAGD2Jvb2wABg9p\
bnQ4AAYfaW50MTYABh9pbnQzMgAGH2ludDY0AAYfdWludDgABj91aW50MTYABj91aW50MzIABj91aW50NjQABn9m\
bG9hdDMyAAZ/ZmxvYXQ2NAAGD3RleHQABg9kYXRhAAYPbGlzdA9lbnVtP3N0cnVjdP9pbnRlcmZhYwABZf9hbnlQ\
b2ludAADZXIRAcr/Y2FwbnAvc2MCaGVtYS5jYXBucDpWYWx1ZQAAEQEHUAEBMQEvBFFMAwQM//8EAQAAEwUCKgAA\
UgIDAVMMAgIBHQH+/xAUAQEAABMJAioAAFMEAgMBUxACAgEdAv3/AhQBAgAAEw0CKgAAUwgCAwFTFAICAR0D/P8B\
FAEDAAATEQIyAABTDAIDAVMYAgIBHQT7/wEUAQQAABMVAjIAAFMQAgMBUxwCAgEdBfr/ARQBBQAAExkCMgAAUxQC\
AwFTIAICAR0G+f8CFAEGAAATHQIyAABTGAIDAVMkAgIBHQf4/wEUAQcAABMhAjoAAFMcAgMBUygCAgEdCPf/ARQB\
CAAAEyUCOgAAUyACAwFTLAICAR0J9v8BFAEJAAATKQI6AABTJAIDAVMwAgIBHQr1/wEUAQoAABMtAkIAAFMoAgMB\
UzQCAgEdC/T/ARQBCwAAEzECQgAAUywCAwFTOAICAQ0M8/8UAQwAABM1AioAAFMwAgMBUzwCAgENDfL/FAENAAAT\
OQIqAABTNAIDAVNAAgIBDQ7x/xQBDgAAEz0CKgAAUzgCAwFTRAICAR0P8P8BFAEPAAATQQIqAABTPAIDAVNIAgIB\
DRDv/xQBEAAAE0UCOgAAU0ACAwFTTAICAQ0R7v8UAREAABNJAlIAAFNIAgMBU1QCAgENEu3/FAESAAATUQJaAABT\
UAIDAVNcAgIBD3ZvaWQABg9ib29sAQEAAgEBAAEPaW50OAECAAIBAgABH2ludDE2AQMAAgEDAAEfaW50MzIBBAAC\
AQQAAR9pbnQ2NAEFAAIBBQABH3VpbnQ4AQYAAgEGAAE/dWludDE2AQcAAgEHAAE/dWludDMyAQgAAgEIAAE/dWlu\
dDY0AQkAAgEJAAF/ZmxvYXQzMgEKAAIBCgABf2Zsb2F0NjQBCwACAQsAAQ90ZXh0AQwAAgEMAAEPZGF0YQENAAIB\
DQABD2xpc3QBEgACARIAAQ9lbnVtAQcAAgEHAAE/c3RydWN0ARIAAgESAAH/aW50ZXJmYWMAAWUABv9hbnlQb2lu\
dAADZXIBEgACARIAAREB8v9jYXBucC9zYwJoZW1hLmNhcG5wOk5vZGUuH2NvbnN0EQF3UQgDBBADFAEQAAARKSoA\
AFEkAwFRMAIBEQEEFAERAAARLTIAAFEoAwFRNAIBD3R5cGUBEP9gzPnh7Xhz0AAAAQEQAAEfdmFsdWUBEP+bDLDX\
0twjzgAAAQEQAAExARoB/2NhcG5wL3NjA2hlbWEuY2FwbnA6Tm9kZS5hbm5vdGF0aQNvbjEB3wJRNAMEEAMUARIA\
ABNdASoAAFNYAQMBU2QBAgERAXAUARMAABNhAWIAAFNgAQMBU2wBAgERAnEUARQAABNpAWoAAFNoAQMBU3QBAgER\
A3IUARUAABNxAWIAAFNwAQMBU3wBAgERBHMUARYAABN5AYoAAFN8AQMBU4gBAgERBXQUARcAABOFAXIAAFOEAQMB\
U5ABAgERBnUUARgAABONAWoAAFOMAQMBU5gBAgERB3YUARkAABOVAWoAAFOUAQMBU6ABAgERCHcUARoAABOdAWoA\
AFOcAQMBU6gBAgERCXgUARsAABOlAYoAAFOoAQMBU7QBAgERCnkUARwAABOxAXIAAFOwAQMBU7wBAgERC3oUAR0A\
ABO5AWoAAFO4AQMBU8QBAgERDHsUAR4AABPBAZIAAFPEAQMBU9ABAgEPdHlwZQEQ/2DM+eHteHPQAAABARAAAf90\
YXJnZXRzRgAHaWxlAQEAAgEBAAH/dGFyZ2V0c0MAD29uc3QBAQACAQEAAf90YXJnZXRzRQAHbnVtAQEAAgEBAAH/\
dGFyZ2V0c0UBbnVtZXJhbnQAAAEBAAIBAQAB/3RhcmdldHNTAB90cnVjdAEBAAIBAQAB/3RhcmdldHNGAA9pZWxk\
AQEAAgEBAAH/dGFyZ2V0c1UAD25pb24BAQACAQEAAf90YXJnZXRzRwAPcm91cAEBAAIBAQAB/3RhcmdldHNJAW50\
ZXJmYWNlAAABAQACAQEAAf90YXJnZXRzTQAfZXRob2QBAQACAQEAAf90YXJnZXRzUAAPYXJhbQEBAAIBAQAB/3Rh\
cmdldHNBAW5ub3RhdGlvAW4BAQACAQEAATEBGgH/Y2FwbnAvc2MDaGVtYS5jYXBucDpOb2RlLk5lc3RlZE5vA2Rl\
EQEHUAEBEQF3UQgDBAAABAEAABEpKgAAUSQDAVEwAgEBARQBAQAAES0aAABRKAMBUTQCAQ9uYW1lAQwAAgEMAAED\
aWQBCQACAQkAAREB8v9jYXBucC9zYwJoZW1hLmNhcG5wOkFubm90H2F0aW9uEQEHUAEBEQGvUQwDBAAABAEAABFF\
GgAAUUADAVFMAgEBAhQBAQAAEUkyAABRRAMBUVACAREBARQBAgAAEU0yAABRSAMBUVQCAQNpZAEJAAIBCQABH3Zh\
bHVlARD/mwyw19LcI84AAAEBEAABH2JyYW5kARD/K0JlYPBVNJAAAAEBEAABMQESAf9jYXBucC9zYwNoZW1hLmNh\
cG5wOk5vZGUuUGFyYW1ldGUBchEBB1ABAREBP1EEAwQAAAQBAAARDSoAAFEIAwFRFAIBD25hbWUBDAACAQwAAREB\
yv9jYXBucC9zYwJoZW1hLmNhcG5wOkJyYW5kAAARASdRCAEB/8lrY6mFNNerABEJMv/8556WFs1jyAARBUIfU2Nv\
cGV/QmluZGluZxEBP1EEAwQAAAQBAAARDToAAFEIAwFRJAIBP3Njb3BlcwEOAAFQAwEBEP/Ja2OphTTXqwAAAQEO\
AAERAfr/Y2FwbnAvc2MCaGVtYS5jYXBucDpCcmFuZD8uU2NvcGURAQdQAQERAa9RDAMEAAAEAQAAEUVCAABRQAMB\
UUwCAQ0B//8UAQEAABFJKgAAUUQDAVFgAgENAv7/FAECAAARXUIAAFFYAwFRZAIBf3Njb3BlSWQBCQACAQkAAQ9i\
aW5kAQ4AAVADAQEQ//znnpYWzWPIAAABAQ4AAX9pbmhlcml0AAYxAQoB/2NhcG5wL3NjA2hlbWEuY2FwbnA6QnJh\
bmQuQmluZGluZwAAEQEHUAEBEQF3UQgDBAz//wQBAAARKUIAAFEkAwFRMAIBDQH+/xQBAQAAES0qAABRKAMBUTQC\
AX91bmJvdW5kAAYPdHlwZQEQ/2DM+eHteHPQAAABARAAAREB6v9jYXBucC9zYwJoZW1hLmNhcG5wOlR5cGUuD2xp\
c3QRAT9RBAMEAAAUAQ4AABENYgAAUQwDAVEYAgH/ZWxlbWVudFQAB3lwZQEQ/2DM+eHteHPQAAABARAAAREB6v9j\
YXBucC9zYwJoZW1hLmNhcG5wOlR5cGUuD2VudW0RAXdRCAMEEAEUAQ8AABEpOgAAUSQDAVEwAgEBARQBFQAAES0y\
AABRKAMBUTQCAT90eXBlSWQBCQACAQkAAR9icmFuZAEQ/ytCZWDwVTSQAAABARAAAREB+v9jYXBucC9zYwJoZW1h\
LmNhcG5wOlR5cGUuP3N0cnVjdBEBd1EIAwQQARQBEAAAESk6AABRJAMBUTACAQEBFAEWAAARLTIAAFEoAwFRNAIB\
P3R5cGVJZAEJAAIBCQABH2JyYW5kARD/K0JlYPBVNJAAAAEBEAABMQESAf9jYXBucC9zYwNoZW1hLmNhcG5wOlR5\
cGUuaW50ZXJmYWMBZREBd1EIAwQQARQBEQAAESk6AABRJAMBUTACAQEBFAEXAAARLTIAAFEoAwFRNAIBP3R5cGVJ\
ZAEJAAIBCQABH2JyYW5kARD/K0JlYPBVNJAAAAEBEAABMQGKAf9jYXBucC9zYwVoZW1hLmNhcG5wOlR5cGUuYW55\
UG9pbnRlci51bmNvbnN0cmFpbmVkAAARAedREAMEDP//FAESAAARYUIAAFFcAwFRaAIBDQH+/xQBGQAAEWU6AABR\
YAMBUWwCAQ0C/f8UARoAABFpKgAAUWQDAVFwAgENA/z/FAEbAAARbVoAAFFsAwFReAIBf2FueUtpbmQABj9zdHJ1\
Y3QABg9saXN0AAb/Y2FwYWJpbGkAA3R5AAYxAWoB/2NhcG5wL3NjBGhlbWEuY2FwbnA6VHlwZS5hbnlQb2ludGVy\
LnBhcmFtD2V0ZXIRAXdRCAMEEAIUARMAABEpQgAAUSQDAVEwAgERAQUUARQAABEtegAAUSwDAVE4AgF/c2NvcGVJ\
ZAEJAAIBCQAB/3BhcmFtZXRlAD9ySW5kZXgBBwACAQcAATEB2gH/Y2FwbnAvc2MGaGVtYS5jYXBucDpUeXBlLmFu\
eVBvaW50ZXIuaW1wbGljaXRNZXRob2RQYXJhbWV0A2VyEQE/UQQDBBAFFAEYAAARDXoAAFEMAwFRGAIB/3BhcmFt\
ZXRlAD9ySW5kZXgBBwACAQcAATEBGgH/Y2FwbnAvc2MDaGVtYS5jYXBucDpUeXBlLmFueVBvaW50A2VyEQGvUQwD\
BAz//wEB/1Y2Wf55XzuOABFFcgACDQH+/wEB/4VKYfQk99GdABExUgACDQL9/wEB/3TiVgwSye+6ABEdwgAC/3Vu\
Y29uc3RyAB9haW5lZP9wYXJhbWV0ZQABcv9pbXBsaWNpdAJNZXRob2RQYXJhbWV0ZXIAEQHy/2NhcG5wL3NjAmhl\
bWEuY2FwbnA6RmllbGQfLnNsb3QRAedREAMEEAEUAQQAABFhOgAAUVwDAVFoAgERAQIUAQUAABFlKgAAUWADAVFs\
AgERAgMUAQYAABFpagAAUWgDAVF0AgERA4AUAQoAABFxmgAAUXQDAVGAAgE/b2Zmc2V0AQgAAgEIAAEPdHlwZQEQ\
/2DM+eHteHPQAAABARAAAf9kZWZhdWx0VgAPYWx1ZQEQ/5sMsNfS3CPOAAABARAAAf9oYWRFeHBsaQFjaXREZWZh\
dQNsdAEBAAIBAQABEQH6/2NhcG5wL3NjAmhlbWEuY2FwbnA6RmllbGQ/Lmdyb3VwEQE/UQQDBBACFAEHAAARDToA\
AFEIAwFRFAIBP3R5cGVJZAEJAAIBCQABMQEKAf9jYXBucC9zYwNoZW1hLmNhcG5wOkZpZWxkLm9yZGluYWwAABEB\
d1EIAwQM//8UAQgAABEpSgAAUSgDAVE0AgEdAf7/BhQBCQAAETFKAABRMAMBUTwCAf9pbXBsaWNpdAAAB/9leHBs\
aWNpdAAAAAEHAAIBBwABMQGKAv96aGluc3QvaQlvL3Byb3RvY29sL2NhcG5wL3Nlc3Npb24vc2Vzc2lvbl9wcm90\
b2NvbC5jYXBucDpTZXNzaW9uLmxpc3ROb2RlcyRQYXJhbXMAABEBr1EMAwQAAAQBAAARRXoAAFFEAwFRUAIBAQEU\
AQEAABFNMgAAUUgDAVFUAgERAgEUAQIAABFROgAAUUwDAVFYAgH/cGF0aEV4cHIAP2Vzc2lvbgEMAAIBDAABH2Zs\
YWdzAQgAAgEIAAE/Y2xpZW50AQ0AAgENAAExAZIC/3poaW5zdC9pCW8vcHJvdG9jb2wvY2FwbnAvc2Vzc2lvbi9z\
ZXNzaW9uX3Byb3RvY29sLmNhcG5wOlNlc3Npb24ubGlzdE5vZGVzJFJlc3VsdAFzEQE/UQQDBAAABAEAABENMgAA\
UQgDAVEkAgEfcGF0aHMBDgABUAMBAQwAAgEOAAExAdoC/3poaW5zdC9pCm8vcHJvdG9jb2wvY2FwbnAvc2Vzc2lv\
bi9zZXNzaW9uX3Byb3RvY29sLmNhcG5wOlNlc3Npb24uZGVwcmVjYXRlZEdldFZhbHVlcyRQYXJhA21zEQF3UQgD\
BAAABAEAABEpMgAAUSQDAVFAAgERAQEUAQEBARE9OgAAUTgDAVFEAgEfcGF0aHMBDgABUAMBAQwAAgEOAAE/Y2xp\
ZW50AQ0AAgENAAARAQIxAaIB/3poaW5zdC9pBW8vcHJvdG9jb2wvY2FwbnAvY29tbW9uL3Jlc3VsdC5jYXBucDpS\
ZXMHdWx0EQEHUAEBEQF3UQgDBAz//wQBAAARKRoAAFEkAwFRMAIBDQH+/xQBAQAAES0iAABRKAMBUTQCAQNvawES\
AQH/PTI0GT7zsLoAAAABEgABB2VycgESBQEB/z0yNBk+87C6AAAAARIAAREBF0EIAREFKhEFMg9UeXBlH0Vycm9y\
MQHaAf96aGluc3QvaQZvL3Byb3RvY29sL2NhcG5wL2NvbW1vbi92YWx1ZS5jYXBucDpBbm5vdGF0ZWRWYWwDdWUR\
ARdRBAEB/xgwr1fK2FOtABEBSv9NZXRhZGF0YQAAABEBd1EIAwQAAAQBAAARKUoAAFEoAwFRNAIBEQEBFAEBAAAR\
MTIAAFEsAwFROAIB/21ldGFkYXRhAAAAARD/GDCvV8rYU60AAAEBEAABH3ZhbHVlARD/rHW+cUeLg7EAAAEBEAAB\
MQGSAf96aGluc3QvaQVvL3Byb3RvY29sL2NhcG5wL2NvbW1vbi9lcnJvci5jYXBucDpFcnJvAXIRAQdQAQExAR8B\
URQDBAAABAEAABF9KgAAUXgDAVGEAgEBARQBAQAAEYFCAABRfAMBUYgCARECARQBAgAAEYVKAABRhAMBUZACARED\
AhQBAwEBEY0qAABRiAMBUZQCAREEAhQBBAAAEZE6AABRjAMBUZgCAQ9jb2RlAQgAAgEIAAF/bWVzc2FnZQEMAAIB\
DAAB/2NhdGVnb3J5AAAAAQwAAgEMAAEPa2luZAEP/70CmEricea3AAABBQ8CAAE/c291cmNlAQwAAgEMAAExAeIC\
/3poaW5zdC9pCm8vcHJvdG9jb2wvY2FwbnAvc2Vzc2lvbi9zZXNzaW9uX3Byb3RvY29sLmNhcG5wOlNlc3Npb24u\
ZGVwcmVjYXRlZEdldFZhbHVlcyRSZXN1B2x0cxEBP1EEAwQAAAQBAAARDToAAFEIAwFRbAIBP3Jlc3VsdAEOAAFQ\
AwEBEP89MjQZPvOwugAAAEABEQEfUQQCAf89MjQZPvOwugAAABEBJ1EIAQEBAVEIAwEBAVEQAwEBEP/cfINuN+4I\
9AAAAQEQ/9kRfVFMTuPEAAABAQ4AATEBkgH/emhpbnN0L2kFby9wcm90b2NvbC9jYXBucC9jb21tb24vdmFsdWUu\
Y2FwbnA6VmFsdQFlEQEHUAEBMQH3A1FIAwQM//8EAQAAE+kBMgAAU+QBAwFT8AECAQ0B/v8UAQEAABPtAToAAFPo\
AQMBU/QBAgENAv3/FAECAAAT8QFCAABT7AEDAVP4AQIBDQP8/xQBAwAAE/UBOgAAU/ABAwFT/AECAQ0E+/8UAQQA\
ABP5AVoAAFP4AQMBUwQCAgENBfr/FAEFAAATAQJSAABSAgMBUwwCAgENBvn/FAEGAAATCQJyAABTCAIDAVMUAgIB\
DQf4/xQBBwAAExECKgAAUwwCAwFTGAICAQ0I9/8UAQgAABMVAnoAAFMUAgMBUyACAgENCfb/FAEJAAATHQJqAABT\
HAIDAVMoAgIBDQr1/xQBCgAAEyUCogAAUygCAwFTNAICAQ0L9P8UAQsAABMxAooAAFM0AgMBU1ACAgENDPP/FAEM\
AAATTQKqAABTUAIDAVNsAgIBDQ3y/xQBDQAAE2kCggAAU2gCAwFTdAICAQ0O8f8UAQ4AABNxAioAAFNsAgMBU3gC\
AgEND/D/FAEPAAATdQJqAABTdAIDAVOAAgIBDRDv/xQBEAAAE30CygAAU4QCAwFTkAICAQ0R7v8UAREAABONAloA\
AFOMAgMBU5gCAgEfaW50NjQBBQACAQUAAT9kb3VibGUBCwACAQsAAX9jb21wbGV4ARD/V7G0l6+v8aoAAAEBEAAB\
P3N0cmluZwEMAAIBDAAB/3ZlY3RvckRhAAN0YQEQ/3iJ8w24ZUyZAAABARAAAf9jbnRTYW1wbAABZQEQ/2VgfSjY\
CzfpAAABARAAAf90cmlnZ2VyUwAfYW1wbGUBEP+VDX3ClyC33gAAAQEQAAEPbm9uZQEQ/xZ4Q4Hp6H/fAAABARAA\
Af9zdHJlYW1pbgA/Z0Vycm9yARD/2RF9UUxO48QAAAEBEAAB/3NoZkRlbW9kAA9EYXRhARD7gmXm4+MDmwABARAA\
Af9zaGZSZXN1bAF0TG9nZ2VyRAdhdGEBEP/dHXZ59WGguwAAAQEQAAH/dmVjdG9yQ24BdFNhbXBsZXMAAAEOAAFQ\
AwEBEP9lYH0o2As36QAAAQEOAAH/dmVjdG9yVHIBaWdnZXJTYW0PcGxlcwEOAAFQAwEBEP+VDX3ClyC33gAAAQEO\
AAH/bGFyZ2VWZWMBdG9yRGF0YQABEP8KsFmZsPdI2QAAAQEQAAEPYm9vbAEBAAIBAQAB/3NoZlNjb3BlAA9EYXRh\
ARD/yTupgh9/sKkAAAEBEAAB/3NoZkdlbmVyAmF0b3JXYXZlZm9ybURhdGEAAAEQ/9DzxIFu4M/tAAABARAAAf9z\
aGZQaWREYQADdGEBEP9wKJpUceFu/wAAAQEQAAExAVIC/3poaW5zdC9pCG8vcHJvdG9jb2wvY2FwbnAvc2Vzc2lv\
bi9zZXNzaW9uX3Byb3RvY29sLmNhcG5wOlJldHVybkZyb21TZXRXaGUBbhEBB1ABAREBZ1EQAQIAABEpKgAAAQER\
IVIAAAECER1iAAABAxEZogAAD2FzYXD/ZGV2aWNlQWMAAWv/dW51c2VkQXMAB3luY/91bnVzZWRUcgFhbnNhY3Rp\
bwduYWwxAdIC/3poaW5zdC9pCm8vcHJvdG9jb2wvY2FwbnAvc2Vzc2lvbi9zZXNzaW9uX3Byb3RvY29sLmNhcG5w\
OlNlc3Npb24uZGVwcmVjYXRlZFNldFZhbHVlJFBhcmFtAXMRAa9RDAMEAAAEAQAAEUUqAABRQAMBUUwCAREBARQB\
AQAAEUkyAABRRAMBUVACAQECFAECAQERTWoAAFFMAwFRWAIBD3BhdGgBDAACAQwAAR92YWx1ZQEQ/6x1vnFHi4Ox\
AAABARAAAf9jb21wbGV0ZQAPV2hlbgEP//ntVaw6pS3dAAABBQ8BAAExAboB/3poaW5zdC9pBW8vcHJvdG9jb2wv\
Y2FwbnAvY29tbW9uL3ZhbHVlLmNhcG5wOlZvaWQ/U3RydWN0EQEHUAEBMQHaAv96aGluc3QvaQpvL3Byb3RvY29s\
L2NhcG5wL3Nlc3Npb24vc2Vzc2lvbl9wcm90b2NvbC5jYXBucDpTZXNzaW9uLmRlcHJlY2F0ZWRTZXRWYWx1ZSRS\
ZXN1bAN0cxEBP1EEAwQAAAQBAAARDToAAFEIAwFRXAIBP3Jlc3VsdAEQ/z0yNBk+87C6AAAAQAERAR9RBAIB/z0y\
NBk+87C6AAAAEQEnUQgBAQEBUQgDAQEBURADAQEQ/xZ4Q4Hp6H/fAAABARD/2RF9UUxO48QAAAEBEAABMQECAv96\
aGluc3QvaQdvL3Byb3RvY29sL2NhcG5wL3N0cmVhbWluZy9zdHJlYW1pbmcuY2FwbnA6U3Vic2NyaXB0aW9uABEB\
B1ABAREB51EQAwQAAAQBAAARYSoAAFFcAwFRaAIBEQEBFAEBAAARZYIAAFFkAwFRcAIBEQICFAECAAARbWoAAFFs\
AwFReAIBEQMDFAEDAAARdToAAFFwAwFRfAIBD3BhdGgBDAACAQwAAf9zdHJlYW1pbgFnSGFuZGxlAAER/3QVtPWn\
KB71AAABAREAAf9zdWJzY3JpYgAPZXJJZAENAAIBDQABP2t3YXJncwEQ/+DOZKYHziWPAAABARAAATEBigL/emhp\
bnN0L2kJby9wcm90b2NvbC9jYXBucC9zZXNzaW9uL3Nlc3Npb25fcHJvdG9jb2wuY2FwbnA6U2Vzc2lvbi5zdWJz\
Y3JpYmUkUGFyYW1zAAARAT9RBAMEAAAEAQAAEQ1qAABRDAMBURgCAf9zdWJzY3JpcAAPdGlvbgEQ/9Sx4T2lIazt\
AAABARAAATEBkgL/emhpbnN0L2kJby9wcm90b2NvbC9jYXBucC9zZXNzaW9uL3Nlc3Npb25fcHJvdG9jb2wuY2Fw\
bnA6U2Vzc2lvbi5zdWJzY3JpYmUkUmVzdWx0AXMRAT9RBAMEAAAEAQAAEQ06AABRCAMBUVwCAT9yZXN1bHQBEP89\
MjQZPvOwugAAAEABEQEfUQQCAf89MjQZPvOwugAAABEBJ1EIAQEBAVEIAwEBAVEQAwEBEP8WeEOB6eh/3wAAAQEQ\
/9kRfVFMTuPEAAABARAAATEBwgL/emhpbnN0L2kKby9wcm90b2NvbC9jYXBucC9zZXNzaW9uL3Nlc3Npb25fcHJv\
dG9jb2wuY2FwbnA6U2Vzc2lvbi5kaXNjb25uZWN0RGV2aWNlJFBhcmFtcwAxAaoC/3poaW5zdC9pCW8vcHJvdG9j\
b2wvY2FwbnAvc2Vzc2lvbi9zZXNzaW9uX3Byb3RvY29sLmNhcG5wOlNlc3Npb24ubGlzdE5vZGVzSnNvbiRQYQ9y\
YW1zEQGvUQwDBAAABAEAABFFegAAUUQDAVFQAgEBARQBAQAAEU0yAABRSAMBUVQCARECARQBAgAAEVE6AABRTAMB\
UVgCAf9wYXRoRXhwcgA/ZXNzaW9uAQwAAgEMAAEfZmxhZ3MBCAACAQgAAT9jbGllbnQBDQACAQ0AATEBsgL/emhp\
bnN0L2kJby9wcm90b2NvbC9jYXBucC9zZXNzaW9uL3Nlc3Npb25fcHJvdG9jb2wuY2FwbnA6U2Vzc2lvbi5saXN0\
Tm9kZXNKc29uJFJlH3N1bHRzEQE/UQQDBAAABAEAABENUgAAUQwDAVEYAgH/bm9kZVByb3AAAXMBDAACAQwAATEB\
mgL/emhpbnN0L2kJby9wcm90b2NvbC9jYXBucC9zZXNzaW9uL3Nlc3Npb25fcHJvdG9jb2wuY2FwbnA6U2Vzc2lv\
bi51bnN1YnNjcmliZSRQYXJhA21zEQF3UQgDBAAABAEAABEpagAAUSgDAVE0AgERAQEUAQEAABExMgAAUSwDAVFI\
AgH/c3Vic2NyaWIAD2VySWQBDQACAQ0AAR9wYXRocwEOAAFQAwEBDAACAQ4AATEBygL/emhpbnN0L2kKby9wcm90\
b2NvbC9jYXBucC9zZXNzaW9uL3Nlc3Npb25fcHJvdG9jb2wuY2FwbnA6U2Vzc2lvbi5nZXRTZXNzaW9uVmVyc2lv\
biRQYXJhbXMAADEB0gL/emhpbnN0L2kKby9wcm90b2NvbC9jYXBucC9zZXNzaW9uL3Nlc3Npb25fcHJvdG9jb2wu\
Y2FwbnA6U2Vzc2lvbi5nZXRTZXNzaW9uVmVyc2lvbiRSZXN1bHQBcxEBP1EEAwQAAAQBAAARDUIAAFEIAwFRFAIB\
f3ZlcnNpb24BDAACAQwAATEB2gL/emhpbnN0L2kKby9wcm90b2NvbC9jYXBucC9zZXNzaW9uL3Nlc3Npb25fcHJv\
dG9jb2wuY2FwbnA6U2Vzc2lvbi5kZXByZWNhdGVkU2V0VmFsdWUyJFBhcmEDbXMRAedREAMEAAAEAQAAEWEqAABR\
XAMBUWgCAREBARQBAQAAEWUyAABRYAMBUWwCAQECFAECAQERaWoAAFFoAwFRdAIBEQMCFAEDAQERcToAAFFsAwFR\
eAIBD3BhdGgBDAACAQwAAR92YWx1ZQEQ/6x1vnFHi4OxAAABARAAAf9jb21wbGV0ZQAPV2hlbgEP//ntVaw6pS3d\
AAABBQ8BAAE/Y2xpZW50AQ0AAgENAAARAQIxAeIC/3poaW5zdC9pCm8vcHJvdG9jb2wvY2FwbnAvc2Vzc2lvbi9z\
ZXNzaW9uX3Byb3RvY29sLmNhcG5wOlNlc3Npb24uZGVwcmVjYXRlZFNldFZhbHVlMiRSZXN1B2x0cxEBP1EEAwQA\
AAQBAAARDToAAFEIAwFRXAIBP3Jlc3VsdAEQ/z0yNBk+87C6AAAAQAERAR9RBAIB/z0yNBk+87C6AAAAEQEnUQgB\
AQEBUQgDAQEBURADAQEQ/9x8g2437gj0AAABARD/2RF9UUxO48QAAAEBEAABMQEaAv96aGluc3QvaQdvL3Byb3Rv\
Y29sL2NhcG5wL3Nlc3Npb24vc2Vzc2lvbl9wcm90b2NvbC5jYXBucDpMb29rdXBNbwNkZREBB1ABAREBN1EIAQIA\
ABERagAAAQERDXIAAP9kaXJlY3RMbwAPb2t1cP93aXRoRXhwYQAfbnNpb24xAYIC/3poaW5zdC9pCW8vcHJvdG9j\
b2wvY2FwbnAvc2Vzc2lvbi9zZXNzaW9uX3Byb3RvY29sLmNhcG5wOlNlc3Npb24uc2V0VmFsdWUkUGFyYW1zADEB\
HwFRFAMEAAAEAQAAEX16AABRfAMBUYgCAREBARQBAQAAEYUyAABRgAMBUYwCAQECFAECAQERiVoAAFGIAwFRlAIB\
EQMBFAEDAQERkWoAAFGQAwFRnAIBEQQCFAEEAQERmToAAFGUAwFRoAIB/3BhdGhFeHByAD9lc3Npb24BDAACAQwA\
AR92YWx1ZQEQ/6x1vnFHi4OxAAABARAAAf9sb29rdXBNbwADZGUBD/8l9HLgtUlQ2gAAAQEPAAH/Y29tcGxldGUA\
D1doZW4BD//57VWsOqUt3QAAAQUPAQABP2NsaWVudAENAAIBDQAAEQECMQGKAv96aGluc3QvaQlvL3Byb3RvY29s\
L2NhcG5wL3Nlc3Npb24vc2Vzc2lvbl9wcm90b2NvbC5jYXBucDpTZXNzaW9uLnNldFZhbHVlJFJlc3VsdHMAABEB\
P1EEAwQAAAQBAAARDToAAFEIAwFRbAIBP3Jlc3VsdAEOAAFQAwEBEP89MjQZPvOwugAAAEABEQEfUQQCAf89MjQZ\
PvOwugAAABEBJ1EIAQEBAVEIAwEBAVEQAwEBEP/cfINuN+4I9AAAAQEQ/9kRfVFMTuPEAAABAQ4AATEBggL/emhp\
bnN0L2kJby9wcm90b2NvbC9jYXBucC9zZXNzaW9uL3Nlc3Npb25fcHJvdG9jb2wuY2FwbnA6U2Vzc2lvbi5nZXRW\
YWx1ZSRQYXJhbXMAEQHnURADBAAABAEAABFhegAAUWADAVFsAgEBARQBAQEBEWlaAABRaAMBUXQCARECARQBAgEB\
EXEyAABRbAMBUXgCAREDARQBAwEBEXU6AABRcAMBUXwCAf9wYXRoRXhwcgA/ZXNzaW9uAQwAAgEMAAH/bG9va3Vw\
TW8AA2RlAQ//JfRy4LVJUNoAAAEBDwABH2ZsYWdzAQgAAgEIAAE/Y2xpZW50AQ0AAgENAAARAQIxAYoC/3poaW5z\
dC9pCW8vcHJvdG9jb2wvY2FwbnAvc2Vzc2lvbi9zZXNzaW9uX3Byb3RvY29sLmNhcG5wOlNlc3Npb24uZ2V0VmFs\
dWUkUmVzdWx0cwAAEQE/UQQDBAAABAEAABENOgAAUQgDAVFsAgE/cmVzdWx0AQ4AAVADAQEQ/z0yNBk+87C6AAAA\
QAERAR9RBAIB/z0yNBk+87C6AAAAEQEnUQgBAQEBUQgDAQEBURADAQEQ/9x8g2437gj0AAABARD/2RF9UUxO48QA\
AAEBDgABMQFyAv96aGluc3QvaQhvL3Byb3RvY29sL2NhcG5wL3Nlc3Npb24vc2Vzc2lvbl9wcm90b2NvbC5jYXBu\
cDpTZXNzaW9uLmNhbmNlbCRQH2FyYW1zEQE/UQQDBAAABAEAABENOgAAUQgDAVEUAgE/Y2xpZW50AQ0AAgENAAEx\
ASIC/3poaW5zdC9pB28vcHJvdG9jb2wvY2FwbnAvY29tbW9uL3ZhbHVlLmNhcG5wOkFubm90YXRlZFZhbHVlLk1l\
dGFkB2F0YREBB1ABAREBd1EIAwQAAAQBAAARKVIAAFEoAwFRNAIBAQEUAQEAABExKgAAUSwDAVE4AgH/dGltZXN0\
YW0AAXABCQACAQkAAQ9wYXRoAQwAAgEMAAExAbIB/3poaW5zdC9pBW8vcHJvdG9jb2wvY2FwbnAvY29tbW9uL2Nv\
bXBsZXguY2FwbnA6Q28fbXBsZXgRAQdQAQERAXdRCAMEAAAEAQAAESkqAABRJAMBUTACAREBARQBAQAAES0qAABR\
KAMBUTQCAQ9yZWFsAQsAAgELAAEPaW1hZwELAAIBCwABMQG6Af96aGluc3QvaQVvL3Byb3RvY29sL2NhcG5wL2Nv\
bW1vbi92YWx1ZS5jYXBucDpWZWN0P29yRGF0YREBB1ABAREB51EQAwQAAAQBAAARYVIAAFFgAwFRbAIBEQECFAEB\
AAARaZIAAFFsAwFReAIBEQIBFAECAAARdYIAAFF0AwFRgAIBAQMUAQMAABF9KgAAUXgDAVGEAgH/dmFsdWVUeXAA\
AWUBBwACAQcAAf92ZWN0b3JFbAFlbWVudFR5cAFlAQYAAgEGAAH/ZXh0cmFIZWEBZGVySW5mbwABCAACAQgAAQ9k\
YXRhAQ0AAgENAAExAbIB/3poaW5zdC9pBW8vcHJvdG9jb2wvY2FwbnAvY29tbW9uL3ZhbHVlLmNhcG5wOkNudFMf\
YW1wbGURAQdQAQERAa9RDAMEAAAEAQAAEUVSAABRRAMBUVACAREBAhQBAQAAEU1CAABRSAMBUVQCARECAxQBAgAA\
EVFCAABRTAMBUVgCAf90aW1lc3RhbQABcAEJAAIBCQABf2NvdW50ZXIBBAACAQQAAX90cmlnZ2VyAQgAAgEIAAEx\
AdIB/3poaW5zdC9pBm8vcHJvdG9jb2wvY2FwbnAvY29tbW9uL3ZhbHVlLmNhcG5wOlRyaWdnZXJTYW1wbAFlEQEH\
UAEBMQGPAVEcAwQAAAQBAAARtVIAAFG0AwFRwAIBEQEBFAEBAAARvVoAAFG8AwFRyAIBEQIEFAECAAARxUIAAFHA\
AwFRzAIBEQMFFAEDAAARyXoAAFHIAwFR1AIBEQQGFAEEAAAR0VoAAFHQAwFR3AIBEQUHFAEFAAAR2SIAAFHUAwFR\
4AIBEQYIFAEGAAAR3XIAAFHcAwFR6AIB/3RpbWVzdGFtAAFwAQkAAgEJAAH/c2FtcGxlVGkAA2NrAQkAAgEJAAF/\
dHJpZ2dlcgEIAAIBCAAB/21pc3NlZFRyAD9pZ2dlcnMBCAACAQgAAf9hd2dUcmlnZwADZXIBCAACAQgAAQdkaW8B\
CAACAQgAAf9zZXF1ZW5jZQAfSW5kZXgBCAACAQgAATEBWgL/emhpbnN0L2kIby9wcm90b2NvbC9jYXBucC9jb21t\
b24vc2hmX3ZlY3RvcnMuY2FwbnA6U2hmRGVtb2R1bGF0b3JWZWN0b3JEYQN0YREBB1ABAREBr1EMAwQAAAEB/w0w\
XKJseHXUABFFWgACAQEUAQ0AABExEgAAUSwDAVFIAgERAgEUAQ4AABFFEgAAUUADAVFcAgH/cHJvcGVydGkAA2Vz\
AXgBDgABUAMBAQsAAgEOAAEBeQEOAAFQAwEBCwACAQ4AATEBYgL/emhpbnN0L2kIby9wcm90b2NvbC9jYXBucC9j\
b21tb24vc2hmX3ZlY3RvcnMuY2FwbnA6U2hmUmVzdWx0TG9nZ2VyVmVjdG9yRAdhdGERAQdQAQERAXdRCAMEAAAB\
Af9e7A7qIbS33QARKVoAAgEBAQH/Et+bRLVoC5gAERU6AAL/cHJvcGVydGkAA2VzP3ZlY3RvcjEB4gH/emhpbnN0\
L2kGby9wcm90b2NvbC9jYXBucC9jb21tb24vdmFsdWUuY2FwbnA6TGFyZ2VWZWN0b3JEB2F0YREBB1ABAREB51EQ\
AwQAAAQBAAARYVIAAFFgAwFRbAIBEQECFAEBAAARaZIAAFFsAwFReAIBEQIBFAECAAARdYIAAFF0AwFRgAIBAQMU\
AQMAABF9agAAUXwDAVGYAgH/dmFsdWVUeXAAAWUBBwACAQcAAf92ZWN0b3JFbAFlbWVudFR5cAFlAQYAAgEGAAH/\
ZXh0cmFIZWEBZGVySW5mbwABCAACAQgAAf9kYXRhU2VnbQAPZW50cwEOAAFQAwEBDQACAQ4AATEBKgL/emhpbnN0\
L2kHby9wcm90b2NvbC9jYXBucC9jb21tb24vc2hmX3ZlY3RvcnMuY2FwbnA6U2hmU2NvcGVWZWN0b3IPRGF0YREB\
B1ABAREBd1EIAwQAAAEB/ySJYPl2uAfXABEpWgACAQEBAf+8FI6Mh6sK0QARFToAAv9wcm9wZXJ0aQADZXM/dmVj\
dG9yMQGKAv96aGluc3QvaQlvL3Byb3RvY29sL2NhcG5wL2NvbW1vbi9zaGZfdmVjdG9ycy5jYXBucDpTaGZHZW5l\
cmF0b3JXYXZlZm9ybVZlY3RvckRhdGEAABEBB1ABAREBP1EEAwQAAAQBAAARDUIAAFEIAwFRJAIBf2NvbXBsZXgB\
DgABUAMBARD/V7G0l6+v8aoAAAEBDgABMQEaAv96aGluc3QvaQdvL3Byb3RvY29sL2NhcG5wL2NvbW1vbi9zaGZf\
dmVjdG9ycy5jYXBucDpTaGZQaWRWZWN0b3JEYQN0YREBB1ABAREBr1EMAwQAAAEB/0RVmXcGneCbABFFWgACAQEU\
AQ0AABExMgAAUSwDAVFIAgERAgEUAQ4AABFFMgAAUUADAVFcAgH/cHJvcGVydGkAA2VzH3ZhbHVlAQ4AAVADAQEL\
AAIBDgABH2Vycm9yAQ4AAVADAQELAAIBDgABMQGyAf96aGluc3QvaQVvL3Byb3RvY29sL2NhcG5wL2NvbW1vbi9l\
cnJvci5jYXBucDpFcnJvH3JLaW5kEQEHUAEBEQH3USgBAgAAEXEaAAABARFpUgAAAQIRZUIAAAEDEV1KAAABBBFZ\
YgAAAQURVVoAAAEGEVFyAAABBxFNSgAAAQgRSWIAAAEJEUVCAAADb2v/Y2FuY2VsbGUAAWR/dW5rbm93bv9ub3RG\
b3VuZAAAAP9vdmVyd2hlbAAHbWVk/2JhZFJlcXVlAANzdP91bmltcGxlbQAfZW50ZWT/aW50ZXJuYWwAAAD/dW5h\
dmFpbGEAB2JsZX90aW1lb3V0MQGyAv96aGluc3QvaQlvL3Byb3RvY29sL2NhcG5wL2NvbW1vbi9zaGZfdmVjdG9y\
cy5jYXBucDpTaGZEZW1vZHVsYXRvclZlY3RvckRhdGEucHJvcGUfcnRpZXMxAd8CUTQDBAAABAEAABNdAVIAAFNc\
AQMBU2gBAgERAQEUAQEAABNlARoAAFNgAQMBU2wBAgERAgQUAQIAABNpAWIAAFNoAQMBU3QBAgERAwUUAQMAABNx\
AWIAAFNwAQMBU3wBAgERBAYUAQQAABN5AWoAAFN4AQMBU4QBAgERBQQUAQUAABOBAYoAAFOEAQMBU5ABAgERBgUU\
AQYAABONAVoAAFOMAQMBU5gBAgERB+AUAQcAABOVAToAAFOQAQMBU5wBAgERCA8UAQgAABOZAYoAAFOcAQMBU6gB\
AgERCRgUAQkAABOlAUoAAFOkAQMBU7ABAgERCh0UAQoAABOtAXIAAFOsAQMBU7gBAgERCxkUAQsAABO1AWoAAFO0\
AQMBU8ABAgERDAcUAQwAABO9AXoAAFO8AQMBU8gBAgH/dGltZXN0YW0AAXABCQACAQkAAQNkdAEJAAIBCQAB/2J1\
cnN0TGVuAAdndGgBCAACAQgAAf9idXJzdE9mZgAHc2V0AQgAAgEIAAH/dHJpZ2dlckkAD25kZXgBCAACAQgAAf90\
cmlnZ2VyVAFpbWVzdGFtcAAAAQkAAgEJAAH/Y2VudGVyRnIAA2VxAQsAAgELAAE/cmZQYXRoAQEAAgEBAAH/b3Nj\
aWxsYXQBb3JTb3VyY2UAAAEHAAIBBwAB/2hhcm1vbmljAAAAAQcAAgEHAAH/dHJpZ2dlclMAH291cmNlAQYAAgEG\
AAH/c2lnbmFsU28AD3VyY2UBBwACAQcAAf9vc2NpbGxhdAA/b3JGcmVxAQsAAgELAAExAboC/3poaW5zdC9pCW8v\
cHJvdG9jb2wvY2FwbnAvY29tbW9uL3NoZl92ZWN0b3JzLmNhcG5wOlNoZlJlc3VsdExvZ2dlclZlY3RvckRhdGEu\
cHJvcD9lcnRpZXMxARcDUTgDBAAABAEAABN5AVIAAFN4AQMBU4QBAgERAQIUAQEAABOBATIAAFN8AQMBU4gBAgER\
AgMUAQIAABOFAWoAAFOEAQMBU5ABAgERAwIUAQMAABONAUIAAFOIAQMBU5QBAgERBAMUAQQAABORAYIAAFOQAQMB\
U5wBAgERBQgUAQUAABOZAVoAAFOYAQMBU6QBAgERBgkUAQYAABOhAVoAAFOgAQMBU6wBAgERBwoUAQcAABOpAYoA\
AFOsAQMBU7gBAgERCAsUAQgAABO1AWIAAFO0AQMBU8ABAgERCQwUAQkAABO9AWIAAFO8AQMBU8gBAgERChoUAQoA\
ABPFAaIAAFPIAQMBU9QBAgERCxsUAQsAABPRAaoAAFPUAQMBU+ABAgERDBwUAQwAABPdAaIAAFPgAQMBU+wBAgER\
DQgUAQ0AABPpAaoAAFPsAQMBU/gBAgH/dGltZXN0YW0AAXABCQACAQkAAR9qb2JJZAEIAAIBCAAB/3JlcGV0aXRp\
AA9vbklkAQgAAgEIAAF/c2NhbGluZwELAAIBCwAB/2NlbnRlckZyAWVxdWVuY3kAAQsAAgELAAH/ZGF0YVNvdXIA\
A2NlAQgAAgEIAAH/bnVtU2FtcGwAA2VzAQgAAgEIAAH/bnVtU3BlY3QBclNhbXBsZXMAAAEIAAIBCAAB/251bUF2\
ZXJhAAdnZXMBCAACAQgAAf9udW1BY3F1aQAHcmVkAQgAAgEIAAH/aG9sZG9mZkUBcnJvcnNSZXMHbG9nAQcAAgEH\
AAH/aG9sZG9mZkUBcnJvcnNSZWEPZG91dAEHAAIBBwAB/2hvbGRvZmZFAXJyb3JzU3BlB2N0cgEHAAIBBwAB/2Zp\
cnN0U2FtAXBsZVRpbWVzD3RhbXABCQACAQkAATEBmgL/emhpbnN0L2kJby9wcm90b2NvbC9jYXBucC9jb21tb24v\
c2hmX3ZlY3RvcnMuY2FwbnA6U2hmUmVzdWx0TG9nZ2VyVmVjdG9yRGF0YS52ZWN0A29yEQF3UQgDBAz//xQBDgAA\
ESkqAABRJAMBUUACAQ0B/v8UAQ8AABE9QgAAUTgDAVFUAgEPcmVhbAEOAAFQAwEBCwACAQ4AAX9jb21wbGV4AQ4A\
AVADAQEQ/1extJevr/GqAAABAQ4AATEBggL/emhpbnN0L2kJby9wcm90b2NvbC9jYXBucC9jb21tb24vc2hmX3Zl\
Y3RvcnMuY2FwbnA6U2hmU2NvcGVWZWN0b3JEYXRhLnByb3BlcnRpZXMAMQGnAlEwAwQAAAQBAAATQQFSAABTQAED\
AVNMAQIBEQECFAEBAAATSQFyAABTSAEDAVNUAQIBEQIDFAECAAATUQEyAABTTAEDAVNYAQIBEQMCFAEDAAATVQFC\
AABTUAEDAVNcAQIBEQQDFAEEAAATWQGCAABTWAEDAVNkAQIBEQUEFAEFAAATYQGKAABTZAEDAVNwAQIBEQYKFAEG\
AAATbQFiAABTbAEDAVN4AQIBEQcLFAEHAAATdQFqAABTdAEDAVOAAQIBEQgMFAEIAAATfQFiAABTfAEDAVOIAQIB\
EQkNFAEJAAAThQGKAABTiAEDAVOUAQIBEQoOFAEKAAATkQGSAABTlAEDAVOgAQIBEQsPFAELAAATnQGSAABToAED\
AVOsAQIB/3RpbWVzdGFtAAFwAQkAAgEJAAH/dGltZXN0YW0AH3BEaWZmAQgAAgEIAAEfZmxhZ3MBCAACAQgAAX9z\
Y2FsaW5nAQsAAgELAAH/Y2VudGVyRnIBZXF1ZW5jeQABCwACAQsAAf90cmlnZ2VyVAFpbWVzdGFtcAAAAQkAAgEJ\
AAH/aW5wdXRTZWwAB2VjdAEIAAIBCAAB/2F2ZXJhZ2VDAA9vdW50AQgAAgEIAAH/bnVtU2VnbWUAB250cwEIAAIB\
CAAB/251bVRvdGFsAVNlZ21lbnRzAAABCAACAQgAAf9maXJzdFNlZwFtZW50SW5kZQF4AQgAAgEIAAH/bnVtTWlz\
c2UBZFRyaWdnZXIBcwEIAAIBCAABMQFiAv96aGluc3QvaQhvL3Byb3RvY29sL2NhcG5wL2NvbW1vbi9zaGZfdmVj\
dG9ycy5jYXBucDpTaGZTY29wZVZlY3RvckRhdGEudmVjB3RvchEBd1EIAwQM//8UAQwAABEpKgAAUSQDAVFAAgEN\
Af7/FAENAAARPUIAAFE4AwFRVAIBD3JlYWwBDgABUAMBAQsAAgEOAAF/Y29tcGxleAEOAAFQAwEBEP9XsbSXr6/x\
qgAAAQEOAAExAXIC/3poaW5zdC9pCG8vcHJvdG9jb2wvY2FwbnAvY29tbW9uL3NoZl92ZWN0b3JzLmNhcG5wOlNo\
ZlBpZFZlY3RvckRhdGEucHJvcGUfcnRpZXMxAd8CUTQDBAAABAEAABNdAVIAAFNcAQMBU2gBAgERAQEUAQEAABNl\
AXIAAFNkAQMBU3ABAgERAgQUAQIAABNtAWIAAFNsAQMBU3gBAgERAwUUAQMAABN1AWIAAFN0AQMBU4ABAgERBAYU\
AQQAABN9AWoAAFN8AQMBU4gBAgERBQQUAQUAABOFAYoAAFOIAQMBU5QBAgERBgUUAQYAABORAWIAAFOQAQMBU5wB\
AgERBxwUAQcAABOZAWoAAFOYAQMBU6QBAgERCB0UAQgAABOhATIAAFOcAQMBU6gBAgERCR4UAQkAABOlAXIAAFOk\
AQMBU7ABAgERCh8UAQoAABOtAToAAFOoAQMBU7QBAgERCzAUAQsAABOxAVoAAFOwAQMBU7wBAgERDAcUAQwAABO5\
AUoAAFO4AQMBU8QBAgH/dGltZXN0YW0AAXABCQACAQkAAf90aW1lc3RhbQAfcERpZmYBCQACAQkAAf9idXJzdExl\
bgAHZ3RoAQgAAgEIAAH/YnVyc3RPZmYAB3NldAEIAAIBCAAB/3RyaWdnZXJJAA9uZGV4AQgAAgEIAAH/dHJpZ2dl\
clQBaW1lc3RhbXAAAAEJAAIBCQAB/2NlbnRlclBvAAdpbnQBCwACAQsAAf9pbnB1dENoYQAPbm5lbAEGAAIBBgAB\
H2lucHV0AQYAAgEGAAH/b3V0cHV0Q2gAH2FubmVsAQYAAgEGAAE/b3V0cHV0AQYAAgEGAAH/dHJpZ2dlclMAA3Jj\
AQYAAgEGAAH/c2V0UG9pbnQAAAABCwACAQsAATEBGgL/emhpbnN0L2kHby9wcm90b2NvbC9jYXBucC9zdHJlYW1p\
bmcvc3RyZWFtaW5nLmNhcG5wOlN0cmVhbWluZ0hhbmQDbGURAQdQAQERAUdRBAMFAAD/tkd8lg+tC6MBbrHAdzOa\
X5kREVoAAhEJB/9zZW5kVmFsdQADZXNAAREBB1ABATEBogH/emhpbnN0L2kFby9wcm90b2NvbC9jYXBucC9jb21t\
b24va3dhcmdzLmNhcG5wOkt3YQdyZ3MRARdRBAEB/1Ml3NNvTmSiABEBMh9FbnRyeREBP1EEAwQAAAQBAAARDUIA\
AFEIAwFRJAIBf2VudHJpZXMBDgABUAMBARD/UyXc029OZKIAAAEBDgABMQGqAv96aGluc3QvaQlvL3Byb3RvY29s\
L2NhcG5wL3N0cmVhbWluZy9zdHJlYW1pbmcuY2FwbnA6U3RyZWFtaW5nSGFuZGxlLnNlbmRWYWx1ZXMkUGEPcmFt\
cxEBP1EEAwQAAAQBAAARDToAAFEIAwFRJAIBP3ZhbHVlcwEOAAFQAwEBEP/cfINuN+4I9AAAAQEOAAExAQIB/2Nh\
cG5wL3N0A3JlYW0uY2FwbnA6U3RyZWFtUmVzdWx0ABEBB1ABATEB0gH/emhpbnN0L2kGby9wcm90b2NvbC9jYXBu\
cC9jb21tb24va3dhcmdzLmNhcG5wOkt3YXJncy5FbnRyAXkRAQdQAQERAXdRCAMEAAAEAQAAESkiAABRJAMBUTAC\
AREBARQBAQEBES0yAABRKAMBUTQCAQdrZXkBDAACAQwAAR92YWx1ZQEQ/6x1vnFHi4OxAAABARAAAFACAQAAAQcP\
/P///w=="

_SCHEMA_LOADER = None


def get_schema_loader() -> zhinst.comms.SchemaLoader:
    """Get the schema loader for the HPK schema.

    The schema is cached since it is expensive to load and there is no need to
    load it multiple times.

    Returns:
        The schema loader for the HPK schema.
    """
    global _SCHEMA_LOADER  # noqa: PLW0603
    if _SCHEMA_LOADER is None:
        _SCHEMA_LOADER = zhinst.comms.SchemaLoader(
            _CAPNP_BINARY_SCHEMA,  # type: ignore[arg-type]
            version=str(_GENERATED_WITH),
        )
    return _SCHEMA_LOADER


# The following structs are generated for all structs and enums in the schema above.
# They all derive from zhinst.comms.DynamicStruct and have no additional logic on their
# own. They mainly serve two use cases:
#
# 1. Provide a typed interface to the schema and detect breaking changes more easily.
#    Since zhinst.comms is schema agnostic the return types are always DynamicStructs.
#    As a user one can cast the return values to the generated structs to get a typed
#    interface.
#    Example:
#       `result = t.cast(schema.GetValueResults, await client.getValues(...))`
#
#  2. Provide a typed interface for creating new messages.
#     A DynamicStruct can be created by providing a schema loader and the capnp id.
#     The generated structs provide a more convenient way to create new messages.
#     Example:
#       `msg = schema.GetValueParams()`
#     Note that the additional kwargs are passed to the constructor of the DynamicStruct
#     and can be used to set initial values.
#
#  IMPORTANT: There is no additional logic in the generated structs. They are just a
#  typed interface to the schema. All logic is implemented in the DynamicStruct class.
#
#  IMPORTANT: There are quite some differences between how python and capnp handle things.
#  One of them is that capnp struct can have unions. The generator does not support unions
#  and will generate a struct for each union branch. This is not ideal but should be fine.
#
#  For more information see the documentation of zhinst.comms.DynamicStruct.


class ReflectionGetTheSchemaParams(zhinst.comms.DynamicStruct):
    capnp_id = 0x86A77BE57BFA08F7

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class CapSchema(zhinst.comms.DynamicStruct):
    capnp_id = 0xCB31EF7A76EB85CF
    typeId: int  # uint64
    theSchema: list[CapnpNode]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_theSchema(self, size: int) -> list[CapnpNode]:  # type: ignore[valid-type]
        return super().init_list("theSchema", size)  # type: ignore[return-value]


class ReflectionGetTheSchemaResults(zhinst.comms.DynamicStruct):
    capnp_id = 0xC9DB2193E1883DD1
    theSchema: CapSchema

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_theSchema(self, **kwarg) -> CapSchema:  # type: ignore[valid-type]
        return super().init_struct("theSchema", **kwarg)  # type: ignore[return-value]


class ReflectionGetReflectionVersionParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xE3E32FD4D93C1199

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class ReflectionGetReflectionVersionResults(zhinst.comms.DynamicStruct):
    capnp_id = 0xFB31A67FD905411A
    version: str

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class CapnpNode(zhinst.comms.DynamicStruct):
    capnp_id = 0xE682AB4CF923A417
    id: int  # uint64
    displayName: str
    displayNamePrefixLength: int  # uint32
    scopeId: int  # uint64
    nestedNodes: list[CapnpNodeNestedNode]
    annotations: list[CapnpAnnotation]
    file: t.Any
    struct: CapnpNodeStruct
    enum: CapnpNodeEnum
    interface: CapnpNodeInterface
    const: CapnpNodeConst
    annotation: CapnpNodeAnnotation
    parameters: list[CapnpNodeParameter]
    isGeneric: bool

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_nestedNodes(self, size: int) -> list[CapnpNodeNestedNode]:  # type: ignore[valid-type]
        return super().init_list("nestedNodes", size)  # type: ignore[return-value]

    def init_annotations(self, size: int) -> list[CapnpAnnotation]:  # type: ignore[valid-type]
        return super().init_list("annotations", size)  # type: ignore[return-value]

    def init_enum(self, **kwarg) -> CapnpNodeEnum:  # type: ignore[valid-type]
        return super().init_struct("enum", **kwarg)  # type: ignore[return-value]

    def init_interface(self, **kwarg) -> CapnpNodeInterface:  # type: ignore[valid-type]
        return super().init_struct("interface", **kwarg)  # type: ignore[return-value]

    def init_const(self, **kwarg) -> CapnpNodeConst:  # type: ignore[valid-type]
        return super().init_struct("const", **kwarg)  # type: ignore[return-value]

    def init_annotation(self, **kwarg) -> CapnpNodeAnnotation:  # type: ignore[valid-type]
        return super().init_struct("annotation", **kwarg)  # type: ignore[return-value]

    def init_parameters(self, size: int) -> list[CapnpNodeParameter]:  # type: ignore[valid-type]
        return super().init_list("parameters", size)  # type: ignore[return-value]


class CapnpElementSize(zhinst.comms.DynamicEnum):
    capnp_id = 0xD1958F7DBA521926
    empty = 0
    bit = 1
    byte = 2
    twoBytes = 3
    fourBytes = 4
    eightBytes = 5
    pointer = 6
    inlineComposite = 7


class CapnpField(zhinst.comms.DynamicStruct):
    capnp_id = 0x9AAD50A41F4AF45F
    name: str
    codeOrder: int  # uint16
    annotations: list[CapnpAnnotation]
    discriminantValue: int  # uint16
    slot: CapnpFieldSlot
    group: CapnpFieldGroup
    ordinal: CapnpFieldOrdinal

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_annotations(self, size: int) -> list[CapnpAnnotation]:  # type: ignore[valid-type]
        return super().init_list("annotations", size)  # type: ignore[return-value]

    def init_slot(self, **kwarg) -> CapnpFieldSlot:  # type: ignore[valid-type]
        return super().init_struct("slot", **kwarg)  # type: ignore[return-value]

    def init_group(self, **kwarg) -> CapnpFieldGroup:  # type: ignore[valid-type]
        return super().init_struct("group", **kwarg)  # type: ignore[return-value]

    def init_ordinal(self, **kwarg) -> CapnpFieldOrdinal:  # type: ignore[valid-type]
        return super().init_struct("ordinal", **kwarg)  # type: ignore[return-value]


class CapnpNodeStruct(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0x9EA0B19B37FB4435
    dataWordCount: int  # uint16
    pointerCount: int  # uint16
    preferredListEncoding: CapnpElementSize
    isGroup: bool
    discriminantCount: int  # uint16
    discriminantOffset: int  # uint32
    fields: list[CapnpField]

    def init_fields(self, size: int) -> list[CapnpField]:  # type: ignore[valid-type]
        return super().init_list("fields", size)  # type: ignore[return-value]


class CapnpEnumerant(zhinst.comms.DynamicStruct):
    capnp_id = 0x978A7CEBDC549A4D
    name: str
    codeOrder: int  # uint16
    annotations: list[CapnpAnnotation]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_annotations(self, size: int) -> list[CapnpAnnotation]:  # type: ignore[valid-type]
        return super().init_list("annotations", size)  # type: ignore[return-value]


class CapnpNodeEnum(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xB54AB3364333F598
    enumerants: list[CapnpEnumerant]

    def init_enumerants(self, size: int) -> list[CapnpEnumerant]:  # type: ignore[valid-type]
        return super().init_list("enumerants", size)  # type: ignore[return-value]


class CapnpMethod(zhinst.comms.DynamicStruct):
    capnp_id = 0x9500CCE23B334D80
    name: str
    codeOrder: int  # uint16
    paramStructType: int  # uint64
    resultStructType: int  # uint64
    annotations: list[CapnpAnnotation]
    paramBrand: CapnpBrand
    resultBrand: CapnpBrand
    implicitParameters: list[CapnpNodeParameter]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_annotations(self, size: int) -> list[CapnpAnnotation]:  # type: ignore[valid-type]
        return super().init_list("annotations", size)  # type: ignore[return-value]

    def init_paramBrand(self, **kwarg) -> CapnpBrand:  # type: ignore[valid-type]
        return super().init_struct("paramBrand", **kwarg)  # type: ignore[return-value]

    def init_resultBrand(self, **kwarg) -> CapnpBrand:  # type: ignore[valid-type]
        return super().init_struct("resultBrand", **kwarg)  # type: ignore[return-value]

    def init_implicitParameters(self, size: int) -> list[CapnpNodeParameter]:  # type: ignore[valid-type]
        return super().init_list("implicitParameters", size)  # type: ignore[return-value]


class CapnpSuperclass(zhinst.comms.DynamicStruct):
    capnp_id = 0xA9962A9ED0A4D7F8
    id: int  # uint64
    brand: CapnpBrand

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_brand(self, **kwarg) -> CapnpBrand:  # type: ignore[valid-type]
        return super().init_struct("brand", **kwarg)  # type: ignore[return-value]


class CapnpNodeInterface(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xE82753CFF0C2218F
    methods: list[CapnpMethod]
    superclasses: list[CapnpSuperclass]

    def init_methods(self, size: int) -> list[CapnpMethod]:  # type: ignore[valid-type]
        return super().init_list("methods", size)  # type: ignore[return-value]

    def init_superclasses(self, size: int) -> list[CapnpSuperclass]:  # type: ignore[valid-type]
        return super().init_list("superclasses", size)  # type: ignore[return-value]


class CapnpType(zhinst.comms.DynamicStruct):
    capnp_id = 0xD07378EDE1F9CC60
    void: t.Any
    bool: t.Any
    int8: t.Any
    int16: t.Any
    int32: t.Any
    int64: t.Any
    uint8: t.Any
    uint16: t.Any
    uint32: t.Any
    uint64: t.Any
    float32: t.Any
    float64: t.Any
    text: t.Any
    data: t.Any
    list: CapnpTypeList
    enum: CapnpTypeEnum
    struct: CapnpTypeStruct
    interface: CapnpTypeInterface
    anyPointer: CapnpTypeAnyPointer

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_interface(self, **kwarg) -> CapnpTypeInterface:  # type: ignore[valid-type]
        return super().init_struct("interface", **kwarg)  # type: ignore[return-value]

    def init_anyPointer(self, **kwarg) -> CapnpTypeAnyPointer:  # type: ignore[valid-type]
        return super().init_struct("anyPointer", **kwarg)  # type: ignore[return-value]


class CapnpValue(zhinst.comms.DynamicStruct):
    capnp_id = 0xCE23DCD2D7B00C9B
    void: t.Any
    bool: bool
    int8: int  # uint8
    int16: int  # uint16
    int32: int  # uint32
    int64: int  # uint64
    uint8: int  # uint8
    uint16: int  # uint16
    uint32: int  # uint32
    uint64: int  # uint64
    float32: float  # float32
    float64: float  # float64
    text: str
    data: bytes
    list: t.Any
    enum: int  # uint16
    struct: t.Any
    interface: t.Any
    anyPointer: t.Any

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class CapnpNodeConst(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xB18AA5AC7A0D9420
    type: CapnpType
    value: CapnpValue

    def init_type(self, **kwarg) -> CapnpType:  # type: ignore[valid-type]
        return super().init_struct("type", **kwarg)  # type: ignore[return-value]

    def init_value(self, **kwarg) -> CapnpValue:  # type: ignore[valid-type]
        return super().init_struct("value", **kwarg)  # type: ignore[return-value]


class CapnpNodeAnnotation(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xEC1619D4400A0290
    type: CapnpType
    targetsFile: bool
    targetsConst: bool
    targetsEnum: bool
    targetsEnumerant: bool
    targetsStruct: bool
    targetsField: bool
    targetsUnion: bool
    targetsGroup: bool
    targetsInterface: bool
    targetsMethod: bool
    targetsParam: bool
    targetsAnnotation: bool

    def init_type(self, **kwarg) -> CapnpType:  # type: ignore[valid-type]
        return super().init_struct("type", **kwarg)  # type: ignore[return-value]


class CapnpNodeNestedNode(zhinst.comms.DynamicStruct):
    capnp_id = 0xDEBF55BBFA0FC242
    name: str
    id: int  # uint64

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class CapnpAnnotation(zhinst.comms.DynamicStruct):
    capnp_id = 0xF1C8950DAB257542
    id: int  # uint64
    value: CapnpValue
    brand: CapnpBrand

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_value(self, **kwarg) -> CapnpValue:  # type: ignore[valid-type]
        return super().init_struct("value", **kwarg)  # type: ignore[return-value]

    def init_brand(self, **kwarg) -> CapnpBrand:  # type: ignore[valid-type]
        return super().init_struct("brand", **kwarg)  # type: ignore[return-value]


class CapnpNodeParameter(zhinst.comms.DynamicStruct):
    capnp_id = 0xB9521BCCF10FA3B1
    name: str

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class CapnpBrand(zhinst.comms.DynamicStruct):
    capnp_id = 0x903455F06065422B
    scopes: list[CapnpBrandScope]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_scopes(self, size: int) -> list[CapnpBrandScope]:  # type: ignore[valid-type]
        return super().init_list("scopes", size)  # type: ignore[return-value]


class CapnpBrandScope(zhinst.comms.DynamicStruct):
    capnp_id = 0xABD73485A9636BC9
    scopeId: int  # uint64
    bind: list[CapnpBrandBinding]
    inherit: t.Any

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_bind(self, size: int) -> list[CapnpBrandBinding]:  # type: ignore[valid-type]
        return super().init_list("bind", size)  # type: ignore[return-value]


class CapnpBrandBinding(zhinst.comms.DynamicStruct):
    capnp_id = 0xC863CD16969EE7FC
    unbound: t.Any
    type: CapnpType

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_type(self, **kwarg) -> CapnpType:  # type: ignore[valid-type]
        return super().init_struct("type", **kwarg)  # type: ignore[return-value]


class CapnpTypeList(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0x87E739250A60EA97
    elementType: CapnpType

    def init_elementType(self, **kwarg) -> CapnpType:  # type: ignore[valid-type]
        return super().init_struct("elementType", **kwarg)  # type: ignore[return-value]


class CapnpTypeEnum(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0x9E0E78711A7F87A9
    typeId: int  # uint64
    brand: CapnpBrand

    def init_brand(self, **kwarg) -> CapnpBrand:  # type: ignore[valid-type]
        return super().init_struct("brand", **kwarg)  # type: ignore[return-value]


class CapnpTypeStruct(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xAC3A6F60EF4CC6D3
    typeId: int  # uint64
    brand: CapnpBrand

    def init_brand(self, **kwarg) -> CapnpBrand:  # type: ignore[valid-type]
        return super().init_struct("brand", **kwarg)  # type: ignore[return-value]


class CapnpTypeInterface(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xED8BCA69F7FB0CBF
    typeId: int  # uint64
    brand: CapnpBrand

    def init_brand(self, **kwarg) -> CapnpBrand:  # type: ignore[valid-type]
        return super().init_struct("brand", **kwarg)  # type: ignore[return-value]


class CapnpTypeAnyPointerUnconstrained(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0x8E3B5F79FE593656
    anyKind: t.Any
    struct: t.Any
    list: t.Any
    capability: t.Any


class CapnpTypeAnyPointerParameter(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0x9DD1F724F4614A85
    scopeId: int  # uint64
    parameterIndex: int  # uint16


class CapnpTypeAnyPointerImplicitMethodParameter(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xBAEFC9120C56E274
    parameterIndex: int  # uint16


class CapnpTypeAnyPointer(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xC2573FE8A23E49F1
    unconstrained: CapnpTypeAnyPointerUnconstrained
    parameter: CapnpTypeAnyPointerParameter
    implicitMethodParameter: CapnpTypeAnyPointerImplicitMethodParameter

    def init_unconstrained(self, **kwarg) -> CapnpTypeAnyPointerUnconstrained:  # type: ignore[valid-type]
        return super().init_struct("unconstrained", **kwarg)  # type: ignore[return-value]

    def init_parameter(self, **kwarg) -> CapnpTypeAnyPointerParameter:  # type: ignore[valid-type]
        return super().init_struct("parameter", **kwarg)  # type: ignore[return-value]

    def init_implicitMethodParameter(
        self,
        **kwarg,
    ) -> CapnpTypeAnyPointerImplicitMethodParameter:  # type: ignore[valid-type]
        return super().init_struct("implicitMethodParameter", **kwarg)  # type: ignore[return-value]


class CapnpFieldSlot(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xC42305476BB4746F
    offset: int  # uint32
    type: CapnpType
    defaultValue: CapnpValue
    hadExplicitDefault: bool

    def init_type(self, **kwarg) -> CapnpType:  # type: ignore[valid-type]
        return super().init_struct("type", **kwarg)  # type: ignore[return-value]

    def init_defaultValue(self, **kwarg) -> CapnpValue:  # type: ignore[valid-type]
        return super().init_struct("defaultValue", **kwarg)  # type: ignore[return-value]


class CapnpFieldGroup(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xCAFCCDDB68DB1D11
    typeId: int  # uint64


class CapnpFieldOrdinal(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xBB90D5C287870BE6
    implicit: t.Any
    explicit: int  # uint16


class SessionListNodesParams(zhinst.comms.DynamicStruct):
    capnp_id = 0x92035429255EF5A8
    pathExpression: str
    flags: int  # uint32
    client: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionListNodesResults(zhinst.comms.DynamicStruct):
    capnp_id = 0xEBD34BDB74C961B0
    paths: list[str]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_paths(self, size: int) -> list[str]:  # type: ignore[valid-type]
        return super().init_list("paths", size)  # type: ignore[return-value]


class SessionDeprecatedGetValuesParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xCD242E1BB990DFE7
    paths: list[str]
    client: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_paths(self, size: int) -> list[str]:  # type: ignore[valid-type]
        return super().init_list("paths", size)  # type: ignore[return-value]


class Result(zhinst.comms.DynamicStruct):
    capnp_id = 0xBAB0F33E1934323D
    ok: t.Any
    err: t.Any

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class AnnotatedValue(zhinst.comms.DynamicStruct):
    capnp_id = 0xF408EE376E837CDC
    metadata: AnnotatedValueMetadata
    value: Value

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_metadata(self, **kwarg) -> AnnotatedValueMetadata:  # type: ignore[valid-type]
        return super().init_struct("metadata", **kwarg)  # type: ignore[return-value]

    def init_value(self, **kwarg) -> Value:  # type: ignore[valid-type]
        return super().init_struct("value", **kwarg)  # type: ignore[return-value]


class Error(zhinst.comms.DynamicStruct):
    capnp_id = 0xC4E34E4C517D11D9
    code: int  # uint32
    message: str
    category: str
    kind: ErrorKind
    source: str

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionDeprecatedGetValuesResults(zhinst.comms.DynamicStruct):
    capnp_id = 0xE948518C129575BB
    result: list[Result]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_result(self, size: int) -> list[Result]:  # type: ignore[valid-type]
        return super().init_list("result", size)  # type: ignore[return-value]


class Value(zhinst.comms.DynamicStruct):
    capnp_id = 0xB1838B4771BE75AC
    int64: int  # uint64
    double: float  # float64
    complex: complex
    string: str
    vectorData: VectorData
    cntSample: CntSample
    triggerSample: TriggerSample
    none: VoidStruct
    streamingError: Error
    shfDemodData: ShfDemodulatorVectorData
    shfResultLoggerData: ShfResultLoggerVectorData
    vectorCntSamples: list[CntSample]
    vectorTriggerSamples: list[TriggerSample]
    largeVectorData: LargeVectorData
    bool: bool
    shfScopeData: ShfScopeVectorData
    shfGeneratorWaveformData: ShfGeneratorWaveformVectorData
    shfPidData: ShfPidVectorData

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_complex(self, **kwarg) -> complex:  # type: ignore[valid-type]
        return super().init_struct("complex", **kwarg)  # type: ignore[return-value]

    def init_vectorData(self, **kwarg) -> VectorData:  # type: ignore[valid-type]
        return super().init_struct("vectorData", **kwarg)  # type: ignore[return-value]

    def init_cntSample(self, **kwarg) -> CntSample:  # type: ignore[valid-type]
        return super().init_struct("cntSample", **kwarg)  # type: ignore[return-value]

    def init_triggerSample(self, **kwarg) -> TriggerSample:  # type: ignore[valid-type]
        return super().init_struct("triggerSample", **kwarg)  # type: ignore[return-value]

    def init_none(self, **kwarg) -> VoidStruct:  # type: ignore[valid-type]
        return super().init_struct("none", **kwarg)  # type: ignore[return-value]

    def init_streamingError(self, **kwarg) -> Error:  # type: ignore[valid-type]
        return super().init_struct("streamingError", **kwarg)  # type: ignore[return-value]

    def init_shfDemodData(self, **kwarg) -> ShfDemodulatorVectorData:  # type: ignore[valid-type]
        return super().init_struct("shfDemodData", **kwarg)  # type: ignore[return-value]

    def init_shfResultLoggerData(self, **kwarg) -> ShfResultLoggerVectorData:  # type: ignore[valid-type]
        return super().init_struct("shfResultLoggerData", **kwarg)  # type: ignore[return-value]

    def init_vectorCntSamples(self, size: int) -> list[CntSample]:  # type: ignore[valid-type]
        return super().init_list("vectorCntSamples", size)  # type: ignore[return-value]

    def init_vectorTriggerSamples(self, size: int) -> list[TriggerSample]:  # type: ignore[valid-type]
        return super().init_list("vectorTriggerSamples", size)  # type: ignore[return-value]

    def init_largeVectorData(self, **kwarg) -> LargeVectorData:  # type: ignore[valid-type]
        return super().init_struct("largeVectorData", **kwarg)  # type: ignore[return-value]

    def init_shfScopeData(self, **kwarg) -> ShfScopeVectorData:  # type: ignore[valid-type]
        return super().init_struct("shfScopeData", **kwarg)  # type: ignore[return-value]

    def init_shfGeneratorWaveformData(self, **kwarg) -> ShfGeneratorWaveformVectorData:  # type: ignore[valid-type]
        return super().init_struct("shfGeneratorWaveformData", **kwarg)  # type: ignore[return-value]

    def init_shfPidData(self, **kwarg) -> ShfPidVectorData:  # type: ignore[valid-type]
        return super().init_struct("shfPidData", **kwarg)  # type: ignore[return-value]


class ReturnFromSetWhen(zhinst.comms.DynamicEnum):
    capnp_id = 0xDD2DA53AAC55EDF9
    asap = 0
    deviceAck = 1
    unusedAsync = 2
    unusedTransactional = 3


class SessionDeprecatedSetValueParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xA8F6FDED40F38065
    path: str
    value: Value
    completeWhen: ReturnFromSetWhen

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_value(self, **kwarg) -> Value:  # type: ignore[valid-type]
        return super().init_struct("value", **kwarg)  # type: ignore[return-value]


class VoidStruct(zhinst.comms.DynamicStruct):
    capnp_id = 0xDF7FE8E981437816

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionDeprecatedSetValueResults(zhinst.comms.DynamicStruct):
    capnp_id = 0x8AEF0146A9595DF9
    result: Result

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_result(self, **kwarg) -> Result:  # type: ignore[valid-type]
        return super().init_struct("result", **kwarg)  # type: ignore[return-value]


class Subscription(zhinst.comms.DynamicStruct):
    capnp_id = 0xEDAC21A53DE1B1D4
    path: str
    streamingHandle: t.Any
    subscriberId: bytes
    kwargs: Kwargs

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_kwargs(self, **kwarg) -> Kwargs:  # type: ignore[valid-type]
        return super().init_struct("kwargs", **kwarg)  # type: ignore[return-value]


class SessionSubscribeParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xB9B18BE9AFB1B3E4
    subscription: Subscription

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_subscription(self, **kwarg) -> Subscription:  # type: ignore[valid-type]
        return super().init_struct("subscription", **kwarg)  # type: ignore[return-value]


class SessionSubscribeResults(zhinst.comms.DynamicStruct):
    capnp_id = 0xA0CA6692DF48C93F
    result: Result

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_result(self, **kwarg) -> Result:  # type: ignore[valid-type]
        return super().init_struct("result", **kwarg)  # type: ignore[return-value]


class SessionDisconnectDeviceParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xE682E60B2CD90782

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionListNodesJsonParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xCD837FE86531F6C1
    pathExpression: str
    flags: int  # uint32
    client: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionListNodesJsonResults(zhinst.comms.DynamicStruct):
    capnp_id = 0xA8151642645BFA32
    nodeProps: str

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionUnsubscribeParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xB16A1640DB91E61C
    subscriberId: bytes
    paths: list[str]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_paths(self, size: int) -> list[str]:  # type: ignore[valid-type]
        return super().init_list("paths", size)  # type: ignore[return-value]


class SessionGetSessionVersionParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xD77D14CF14B3405A

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionGetSessionVersionResults(zhinst.comms.DynamicStruct):
    capnp_id = 0xCC68434DA57CF6B3
    version: str

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionDeprecatedSetValue2Params(zhinst.comms.DynamicStruct):
    capnp_id = 0xDAE05CD32680ABA1
    path: str
    value: Value
    completeWhen: ReturnFromSetWhen
    client: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_value(self, **kwarg) -> Value:  # type: ignore[valid-type]
        return super().init_struct("value", **kwarg)  # type: ignore[return-value]


class SessionDeprecatedSetValue2Results(zhinst.comms.DynamicStruct):
    capnp_id = 0xFD47648E56C0E689
    result: Result

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_result(self, **kwarg) -> Result:  # type: ignore[valid-type]
        return super().init_struct("result", **kwarg)  # type: ignore[return-value]


class LookupMode(zhinst.comms.DynamicEnum):
    capnp_id = 0xDA5049B5E072F425
    directLookup = 0
    withExpansion = 1


class SessionSetValueParams(zhinst.comms.DynamicStruct):
    capnp_id = 0x9FE29A10493E27C7
    pathExpression: str
    value: Value
    lookupMode: LookupMode
    completeWhen: ReturnFromSetWhen
    client: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_value(self, **kwarg) -> Value:  # type: ignore[valid-type]
        return super().init_struct("value", **kwarg)  # type: ignore[return-value]


class SessionSetValueResults(zhinst.comms.DynamicStruct):
    capnp_id = 0x9474D85F26F63900
    result: list[Result]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_result(self, size: int) -> list[Result]:  # type: ignore[valid-type]
        return super().init_list("result", size)  # type: ignore[return-value]


class SessionGetValueParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xC5E872236CC4917B
    pathExpression: str
    lookupMode: LookupMode
    flags: int  # uint32
    client: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class SessionGetValueResults(zhinst.comms.DynamicStruct):
    capnp_id = 0xCE98719DBAD0A401
    result: list[Result]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_result(self, size: int) -> list[Result]:  # type: ignore[valid-type]
        return super().init_list("result", size)  # type: ignore[return-value]


class SessionCancelParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xB77C3D30C74311FC
    client: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class AnnotatedValueMetadata(zhinst.comms.DynamicStruct):
    capnp_id = 0xAD53D8CA57AF3018
    timestamp: int  # uint64
    path: str

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class Complex(zhinst.comms.DynamicStruct):
    capnp_id = 0xAAF1AFAF97B4B157
    real: float  # float64
    imag: float  # float64

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class VectorData(zhinst.comms.DynamicStruct):
    capnp_id = 0x994C65B80DF38978
    valueType: int  # uint16
    vectorElementType: int  # uint8
    extraHeaderInfo: int  # uint32
    data: bytes

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class CntSample(zhinst.comms.DynamicStruct):
    capnp_id = 0xE9370BD8287D6065
    timestamp: int  # uint64
    counter: int  # uint32
    trigger: int  # uint32

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class TriggerSample(zhinst.comms.DynamicStruct):
    capnp_id = 0xDEB72097C27D0D95
    timestamp: int  # uint64
    sampleTick: int  # uint64
    trigger: int  # uint32
    missedTriggers: int  # uint32
    awgTrigger: int  # uint32
    dio: int  # uint32
    sequenceIndex: int  # uint32

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class ShfDemodulatorVectorData(zhinst.comms.DynamicStruct):
    capnp_id = 0x9B03E3E3E6006582
    properties: ShfDemodulatorVectorDataProperties
    x: list[float]  # list[float64]
    y: list[float]  # list[float64]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_properties(self, **kwarg) -> ShfDemodulatorVectorDataProperties:  # type: ignore[valid-type]
        return super().init_struct("properties", **kwarg)  # type: ignore[return-value]

    def init_x(self, size: int) -> list[float]:  # type: ignore[valid-type]
        return super().init_list("x", size)  # type: ignore[return-value]

    def init_y(self, size: int) -> list[float]:  # type: ignore[valid-type]
        return super().init_list("y", size)  # type: ignore[return-value]


class ShfResultLoggerVectorData(zhinst.comms.DynamicStruct):
    capnp_id = 0xBBA061F579761DDD
    properties: ShfResultLoggerVectorDataProperties
    vector: ShfResultLoggerVectorDataVector

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_properties(self, **kwarg) -> ShfResultLoggerVectorDataProperties:  # type: ignore[valid-type]
        return super().init_struct("properties", **kwarg)  # type: ignore[return-value]

    def init_vector(self, **kwarg) -> ShfResultLoggerVectorDataVector:  # type: ignore[valid-type]
        return super().init_struct("vector", **kwarg)  # type: ignore[return-value]


class LargeVectorData(zhinst.comms.DynamicStruct):
    capnp_id = 0xD948F7B09959B00A
    valueType: int  # uint16
    vectorElementType: int  # uint8
    extraHeaderInfo: int  # uint32
    dataSegments: list[bytes]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_dataSegments(self, size: int) -> list[bytes]:  # type: ignore[valid-type]
        return super().init_list("dataSegments", size)  # type: ignore[return-value]


class ShfScopeVectorData(zhinst.comms.DynamicStruct):
    capnp_id = 0xA9B07F1F82A93BC9
    properties: ShfScopeVectorDataProperties
    vector: ShfScopeVectorDataVector

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_properties(self, **kwarg) -> ShfScopeVectorDataProperties:  # type: ignore[valid-type]
        return super().init_struct("properties", **kwarg)  # type: ignore[return-value]

    def init_vector(self, **kwarg) -> ShfScopeVectorDataVector:  # type: ignore[valid-type]
        return super().init_struct("vector", **kwarg)  # type: ignore[return-value]


class ShfGeneratorWaveformVectorData(zhinst.comms.DynamicStruct):
    capnp_id = 0xEDCFE06E81C4F3D0
    complex: list[complex]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_complex(self, size: int) -> list[complex]:  # type: ignore[valid-type]
        return super().init_list("complex", size)  # type: ignore[return-value]


class ShfPidVectorData(zhinst.comms.DynamicStruct):
    capnp_id = 0xFF6EE171549A2870
    properties: ShfPidVectorDataProperties
    value: list[float]  # list[float64]
    error: list[float]  # list[float64]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_properties(self, **kwarg) -> ShfPidVectorDataProperties:  # type: ignore[valid-type]
        return super().init_struct("properties", **kwarg)  # type: ignore[return-value]

    def init_value(self, size: int) -> list[float]:  # type: ignore[valid-type]
        return super().init_list("value", size)  # type: ignore[return-value]

    def init_error(self, size: int) -> list[float]:  # type: ignore[valid-type]
        return super().init_list("error", size)  # type: ignore[return-value]


class ErrorKind(zhinst.comms.DynamicEnum):
    capnp_id = 0xB7E671E24A9802BD
    ok = 0
    cancelled = 1
    unknown = 2
    notFound = 3
    overwhelmed = 4
    badRequest = 5
    unimplemented = 6
    internal = 7
    unavailable = 8
    timeout = 9


class ShfDemodulatorVectorDataProperties(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xD475786CA25C300D
    timestamp: int  # uint64
    dt: int  # uint64
    burstLength: int  # uint32
    burstOffset: int  # uint32
    triggerIndex: int  # uint32
    triggerTimestamp: int  # uint64
    centerFreq: float  # float64
    rfPath: bool
    oscillatorSource: int  # uint16
    harmonic: int  # uint16
    triggerSource: int  # uint8
    signalSource: int  # uint16
    oscillatorFreq: float  # float64
    scaling: float  # float64


class ShfResultLoggerVectorDataProperties(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xDDB7B421EA0EEC5E
    timestamp: int  # uint64
    jobId: int  # uint32
    repetitionId: int  # uint32
    scaling: float  # float64
    centerFrequency: float  # float64
    dataSource: int  # uint32
    numSamples: int  # uint32
    numSpectrSamples: int  # uint32
    numAverages: int  # uint32
    numAcquired: int  # uint32
    holdoffErrorsReslog: int  # uint16
    holdoffErrorsReadout: int  # uint16
    holdoffErrorsSpectr: int  # uint16
    firstSampleTimestamp: int  # uint64


class ShfResultLoggerVectorDataVector(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0x980B68B5449BDF12
    real: list[float]  # list[float64]
    complex: list[complex]

    def init_real(self, size: int) -> list[float]:  # type: ignore[valid-type]
        return super().init_list("real", size)  # type: ignore[return-value]

    def init_complex(self, size: int) -> list[complex]:  # type: ignore[valid-type]
        return super().init_list("complex", size)  # type: ignore[return-value]


class ShfScopeVectorDataProperties(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xD707B876F9608924
    timestamp: int  # uint64
    timestampDiff: int  # uint32
    flags: int  # uint32
    scaling: float  # float64
    centerFrequency: float  # float64
    triggerTimestamp: int  # uint64
    inputSelect: int  # uint32
    averageCount: int  # uint32
    numSegments: int  # uint32
    numTotalSegments: int  # uint32
    firstSegmentIndex: int  # uint32
    numMissedTriggers: int  # uint32


class ShfScopeVectorDataVector(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0xD10AAB878C8E14BC
    real: list[float]  # list[float64]
    complex: list[complex]

    def init_real(self, size: int) -> list[float]:  # type: ignore[valid-type]
        return super().init_list("real", size)  # type: ignore[return-value]

    def init_complex(self, size: int) -> list[complex]:  # type: ignore[valid-type]
        return super().init_list("complex", size)  # type: ignore[return-value]


class ShfPidVectorDataProperties(zhinst.comms.DynamicStruct):
    # Group struct. This struct is not instantiable directly.
    capnp_id = 0x9BE09D0677995544
    timestamp: int  # uint64
    timestampDiff: int  # uint64
    burstLength: int  # uint32
    burstOffset: int  # uint32
    triggerIndex: int  # uint32
    triggerTimestamp: int  # uint64
    centerPoint: float  # float64
    inputChannel: int  # uint8
    input: int  # uint8
    outputChannel: int  # uint8
    output: int  # uint8
    triggerSrc: int  # uint8
    setPoint: float  # float64


class Kwargs(zhinst.comms.DynamicStruct):
    capnp_id = 0x8F25CE07A664CEE0
    entries: list[KwargsEntry]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_entries(self, size: int) -> list[KwargsEntry]:  # type: ignore[valid-type]
        return super().init_list("entries", size)  # type: ignore[return-value]


class StreamingHandleSendValuesParams(zhinst.comms.DynamicStruct):
    capnp_id = 0xA30BAD0F967C47B6
    values: list[AnnotatedValue]

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_values(self, size: int) -> list[AnnotatedValue]:  # type: ignore[valid-type]
        return super().init_list("values", size)  # type: ignore[return-value]


class CapnpStreamResult(zhinst.comms.DynamicStruct):
    capnp_id = 0x995F9A3377C0B16E

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)


class KwargsEntry(zhinst.comms.DynamicStruct):
    capnp_id = 0xA2644E6FD3DC2553
    key: str
    value: Value

    def __init__(self, **kwargs):
        super().__init__(get_schema_loader(), self.capnp_id, **kwargs)

    def init_value(self, **kwarg) -> Value:  # type: ignore[valid-type]
        return super().init_struct("value", **kwarg)  # type: ignore[return-value]
