# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Instance(pulumi.CustomResource):
    configuration_id: pulumi.Output[str]
    """
    Configuration ID to be attached to the instance. Database instance
    will be rebooted when configuration is detached.
    """
    databases: pulumi.Output[list]
    """
    An array of database name, charset and collate. The database
    object structure is documented below.

      * `charset` (`str`) - Database character set. Changing this creates a
        new instance.
      * `collate` (`str`) - Database collation. Changing this creates a new instance.
      * `name` (`str`) - Database to be created on new instance. Changing this creates a
        new instance.
    """
    datastore: pulumi.Output[dict]
    """
    An array of database engine type and version. The datastore
    object structure is documented below. Changing this creates a new instance.

      * `type` (`str`) - Database engine type to be used in new instance. Changing this
        creates a new instance.
      * `version` (`str`) - Version of database engine type to be used in new instance.
        Changing this creates a new instance.
    """
    flavor_id: pulumi.Output[str]
    """
    The flavor ID of the desired flavor for the instance.
    Changing this creates new instance.
    """
    name: pulumi.Output[str]
    """
    Database to be created on new instance. Changing this creates a
    new instance.
    """
    networks: pulumi.Output[list]
    """
    An array of one or more networks to attach to the
    instance. The network object structure is documented below. Changing this
    creates a new instance.

      * `fixedIpV4` (`str`) - Specifies a fixed IPv4 address to be used on this
        network. Changing this creates a new instance.
      * `fixedIpV6` (`str`) - Specifies a fixed IPv6 address to be used on this
        network. Changing this creates a new instance.
      * `port` (`str`) - The port UUID of a
        network to attach to the instance. Changing this creates a new instance.
      * `uuid` (`str`) - The network UUID to
        attach to the instance. Changing this creates a new instance.
    """
    region: pulumi.Output[str]
    """
    The region in which to create the db instance. Changing this
    creates a new instance.
    """
    size: pulumi.Output[float]
    """
    Specifies the volume size in GB. Changing this creates new instance.
    """
    users: pulumi.Output[list]
    """
    An array of username, password, host and databases. The user
    object structure is documented below.

      * `databases` (`list`) - A list of databases that user will have access to. If not specified, 
        user has access to all databases on th einstance. Changing this creates a new instance.
      * `host` (`str`) - An ip address or % sign indicating what ip addresses can connect with
        this user credentials. Changing this creates a new instance.
      * `name` (`str`) - Database to be created on new instance. Changing this creates a
        new instance.
      * `password` (`str`) - User's password. Changing this creates a
        new instance.
    """
    def __init__(__self__, resource_name, opts=None, configuration_id=None, databases=None, datastore=None, flavor_id=None, name=None, networks=None, region=None, size=None, users=None, __props__=None, __name__=None, __opts__=None):
        """
        Manages a V1 DB instance resource within OpenStack.



        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] configuration_id: Configuration ID to be attached to the instance. Database instance
               will be rebooted when configuration is detached.
        :param pulumi.Input[list] databases: An array of database name, charset and collate. The database
               object structure is documented below.
        :param pulumi.Input[dict] datastore: An array of database engine type and version. The datastore
               object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[str] flavor_id: The flavor ID of the desired flavor for the instance.
               Changing this creates new instance.
        :param pulumi.Input[str] name: Database to be created on new instance. Changing this creates a
               new instance.
        :param pulumi.Input[list] networks: An array of one or more networks to attach to the
               instance. The network object structure is documented below. Changing this
               creates a new instance.
        :param pulumi.Input[str] region: The region in which to create the db instance. Changing this
               creates a new instance.
        :param pulumi.Input[float] size: Specifies the volume size in GB. Changing this creates new instance.
        :param pulumi.Input[list] users: An array of username, password, host and databases. The user
               object structure is documented below.

        The **databases** object supports the following:

          * `charset` (`pulumi.Input[str]`) - Database character set. Changing this creates a
            new instance.
          * `collate` (`pulumi.Input[str]`) - Database collation. Changing this creates a new instance.
          * `name` (`pulumi.Input[str]`) - Database to be created on new instance. Changing this creates a
            new instance.

        The **datastore** object supports the following:

          * `type` (`pulumi.Input[str]`) - Database engine type to be used in new instance. Changing this
            creates a new instance.
          * `version` (`pulumi.Input[str]`) - Version of database engine type to be used in new instance.
            Changing this creates a new instance.

        The **networks** object supports the following:

          * `fixedIpV4` (`pulumi.Input[str]`) - Specifies a fixed IPv4 address to be used on this
            network. Changing this creates a new instance.
          * `fixedIpV6` (`pulumi.Input[str]`) - Specifies a fixed IPv6 address to be used on this
            network. Changing this creates a new instance.
          * `port` (`pulumi.Input[str]`) - The port UUID of a
            network to attach to the instance. Changing this creates a new instance.
          * `uuid` (`pulumi.Input[str]`) - The network UUID to
            attach to the instance. Changing this creates a new instance.

        The **users** object supports the following:

          * `databases` (`pulumi.Input[list]`) - A list of databases that user will have access to. If not specified, 
            user has access to all databases on th einstance. Changing this creates a new instance.
          * `host` (`pulumi.Input[str]`) - An ip address or % sign indicating what ip addresses can connect with
            this user credentials. Changing this creates a new instance.
          * `name` (`pulumi.Input[str]`) - Database to be created on new instance. Changing this creates a
            new instance.
          * `password` (`pulumi.Input[str]`) - User's password. Changing this creates a
            new instance.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['configuration_id'] = configuration_id
            __props__['databases'] = databases
            if datastore is None:
                raise TypeError("Missing required property 'datastore'")
            __props__['datastore'] = datastore
            __props__['flavor_id'] = flavor_id
            __props__['name'] = name
            __props__['networks'] = networks
            __props__['region'] = region
            if size is None:
                raise TypeError("Missing required property 'size'")
            __props__['size'] = size
            __props__['users'] = users
        super(Instance, __self__).__init__(
            'openstack:database/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, configuration_id=None, databases=None, datastore=None, flavor_id=None, name=None, networks=None, region=None, size=None, users=None):
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] configuration_id: Configuration ID to be attached to the instance. Database instance
               will be rebooted when configuration is detached.
        :param pulumi.Input[list] databases: An array of database name, charset and collate. The database
               object structure is documented below.
        :param pulumi.Input[dict] datastore: An array of database engine type and version. The datastore
               object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[str] flavor_id: The flavor ID of the desired flavor for the instance.
               Changing this creates new instance.
        :param pulumi.Input[str] name: Database to be created on new instance. Changing this creates a
               new instance.
        :param pulumi.Input[list] networks: An array of one or more networks to attach to the
               instance. The network object structure is documented below. Changing this
               creates a new instance.
        :param pulumi.Input[str] region: The region in which to create the db instance. Changing this
               creates a new instance.
        :param pulumi.Input[float] size: Specifies the volume size in GB. Changing this creates new instance.
        :param pulumi.Input[list] users: An array of username, password, host and databases. The user
               object structure is documented below.

        The **databases** object supports the following:

          * `charset` (`pulumi.Input[str]`) - Database character set. Changing this creates a
            new instance.
          * `collate` (`pulumi.Input[str]`) - Database collation. Changing this creates a new instance.
          * `name` (`pulumi.Input[str]`) - Database to be created on new instance. Changing this creates a
            new instance.

        The **datastore** object supports the following:

          * `type` (`pulumi.Input[str]`) - Database engine type to be used in new instance. Changing this
            creates a new instance.
          * `version` (`pulumi.Input[str]`) - Version of database engine type to be used in new instance.
            Changing this creates a new instance.

        The **networks** object supports the following:

          * `fixedIpV4` (`pulumi.Input[str]`) - Specifies a fixed IPv4 address to be used on this
            network. Changing this creates a new instance.
          * `fixedIpV6` (`pulumi.Input[str]`) - Specifies a fixed IPv6 address to be used on this
            network. Changing this creates a new instance.
          * `port` (`pulumi.Input[str]`) - The port UUID of a
            network to attach to the instance. Changing this creates a new instance.
          * `uuid` (`pulumi.Input[str]`) - The network UUID to
            attach to the instance. Changing this creates a new instance.

        The **users** object supports the following:

          * `databases` (`pulumi.Input[list]`) - A list of databases that user will have access to. If not specified, 
            user has access to all databases on th einstance. Changing this creates a new instance.
          * `host` (`pulumi.Input[str]`) - An ip address or % sign indicating what ip addresses can connect with
            this user credentials. Changing this creates a new instance.
          * `name` (`pulumi.Input[str]`) - Database to be created on new instance. Changing this creates a
            new instance.
          * `password` (`pulumi.Input[str]`) - User's password. Changing this creates a
            new instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["configuration_id"] = configuration_id
        __props__["databases"] = databases
        __props__["datastore"] = datastore
        __props__["flavor_id"] = flavor_id
        __props__["name"] = name
        __props__["networks"] = networks
        __props__["region"] = region
        __props__["size"] = size
        __props__["users"] = users
        return Instance(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

