"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiCallBase = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
/**
 * Base class for an ApiCall
 */
class ApiCallBase extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.flattenResponse = 'false';
    }
    getAtt(attributeName) {
        this.flattenResponse = 'true';
        return this.apiCallResource.getAtt(`apiCallResponse.${attributeName}`);
    }
    getAttString(attributeName) {
        this.flattenResponse = 'true';
        return this.apiCallResource.getAttString(`apiCallResponse.${attributeName}`);
    }
    expect(expected) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_ExpectedResult(expected);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.expect);
            }
            throw error;
        }
        this.expectedResult = expected.result;
        return this;
    }
    next(next) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IApiCall(next);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.next);
            }
            throw error;
        }
        next.node.addDependency(this);
        return next;
    }
}
exports.ApiCallBase = ApiCallBase;
_a = JSII_RTTI_SYMBOL_1;
ApiCallBase[_a] = { fqn: "@aws-cdk/integ-tests-alpha.ApiCallBase", version: "2.49.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLWNhbGwtYmFzZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFwaS1jYWxsLWJhc2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQ0EsMkNBQW1EO0FBb0huRDs7R0FFRztBQUNILE1BQXNCLFdBQVksU0FBUSxzQkFBUztJQVFqRCxZQUFZLEtBQWdCLEVBQUUsRUFBVTtRQUN0QyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBTlQsb0JBQWUsR0FBVyxPQUFPLENBQUM7S0FRM0M7SUFFTSxNQUFNLENBQUMsYUFBcUI7UUFDakMsSUFBSSxDQUFDLGVBQWUsR0FBRyxNQUFNLENBQUM7UUFDOUIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDLE1BQU0sQ0FBQyxtQkFBbUIsYUFBYSxFQUFFLENBQUMsQ0FBQztLQUN4RTtJQUVNLFlBQVksQ0FBQyxhQUFxQjtRQUN2QyxJQUFJLENBQUMsZUFBZSxHQUFHLE1BQU0sQ0FBQztRQUM5QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUMsWUFBWSxDQUFDLG1CQUFtQixhQUFhLEVBQUUsQ0FBQyxDQUFDO0tBQzlFO0lBRU0sTUFBTSxDQUFDLFFBQXdCOzs7Ozs7Ozs7O1FBQ3BDLElBQUksQ0FBQyxjQUFjLEdBQUcsUUFBUSxDQUFDLE1BQU0sQ0FBQztRQUN0QyxPQUFPLElBQUksQ0FBQztLQUNiO0lBSU0sSUFBSSxDQUFDLElBQWM7Ozs7Ozs7Ozs7UUFDeEIsSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDOUIsT0FBTyxJQUFJLENBQUM7S0FDYjs7QUFqQ0gsa0NBb0NDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ3VzdG9tUmVzb3VyY2UsIFJlZmVyZW5jZSB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCwgSUNvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgRXhwZWN0ZWRSZXN1bHQgfSBmcm9tICcuL2NvbW1vbic7XG5pbXBvcnQgeyBBc3NlcnRpb25zUHJvdmlkZXIgfSBmcm9tICcuL3Byb3ZpZGVycyc7XG5pbXBvcnQgeyBXYWl0ZXJTdGF0ZU1hY2hpbmVPcHRpb25zIH0gZnJvbSAnLi93YWl0ZXItc3RhdGUtbWFjaGluZSc7XG5cbi8qKlxuICogUmVwcmVzZW50cyBhbiBBcGlDYWxsXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUFwaUNhbGwgZXh0ZW5kcyBJQ29uc3RydWN0IHtcbiAgLyoqXG4gICAqIGFjY2VzcyB0aGUgQXNzZXJ0aW9uc1Byb3ZpZGVyLiBUaGlzIGNhbiBiZSB1c2VkIHRvIGFkZCBhZGRpdGlvbmFsIElBTSBwb2xpY2llc1xuICAgKiB0aGUgdGhlIHByb3ZpZGVyIHJvbGUgcG9saWN5XG4gICAqXG4gICAqIEBleGFtcGxlXG4gICAqIGRlY2xhcmUgY29uc3QgYXBpQ2FsbDogQXdzQXBpQ2FsbDtcbiAgICogYXBpQ2FsbC5wcm92aWRlci5hZGRUb1JvbGVQb2xpY3koe1xuICAgKiAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICogICBBY3Rpb246IFsnczM6R2V0T2JqZWN0J10sXG4gICAqICAgUmVzb3VyY2U6IFsnKiddLFxuICAgKiB9KTtcbiAgICovXG4gIHJlYWRvbmx5IHByb3ZpZGVyOiBBc3NlcnRpb25zUHJvdmlkZXI7XG5cbiAgLyoqXG4gICAqIFJldHVybnMgdGhlIHZhbHVlIG9mIGFuIGF0dHJpYnV0ZSBvZiB0aGUgY3VzdG9tIHJlc291cmNlIG9mIGFuIGFyYml0cmFyeVxuICAgKiB0eXBlLiBBdHRyaWJ1dGVzIGFyZSByZXR1cm5lZCBmcm9tIHRoZSBjdXN0b20gcmVzb3VyY2UgcHJvdmlkZXIgdGhyb3VnaCB0aGVcbiAgICogYERhdGFgIG1hcCB3aGVyZSB0aGUga2V5IGlzIHRoZSBhdHRyaWJ1dGUgbmFtZS5cbiAgICpcbiAgICogQHBhcmFtIGF0dHJpYnV0ZU5hbWUgdGhlIG5hbWUgb2YgdGhlIGF0dHJpYnV0ZVxuICAgKiBAcmV0dXJucyBhIHRva2VuIGZvciBgRm46OkdldEF0dGAuIFVzZSBgVG9rZW4uYXNYeHhgIHRvIGVuY29kZSB0aGUgcmV0dXJuZWQgYFJlZmVyZW5jZWAgYXMgYSBzcGVjaWZpYyB0eXBlIG9yXG4gICAqIHVzZSB0aGUgY29udmVuaWVuY2UgYGdldEF0dFN0cmluZ2AgZm9yIHN0cmluZyBhdHRyaWJ1dGVzLlxuICAgKi9cbiAgZ2V0QXR0KGF0dHJpYnV0ZU5hbWU6IHN0cmluZyk6IFJlZmVyZW5jZTtcblxuICAvKipcbiAgICogUmV0dXJucyB0aGUgdmFsdWUgb2YgYW4gYXR0cmlidXRlIG9mIHRoZSBjdXN0b20gcmVzb3VyY2Ugb2YgdHlwZSBzdHJpbmcuXG4gICAqIEF0dHJpYnV0ZXMgYXJlIHJldHVybmVkIGZyb20gdGhlIGN1c3RvbSByZXNvdXJjZSBwcm92aWRlciB0aHJvdWdoIHRoZVxuICAgKiBgRGF0YWAgbWFwIHdoZXJlIHRoZSBrZXkgaXMgdGhlIGF0dHJpYnV0ZSBuYW1lLlxuICAgKlxuICAgKiBAcGFyYW0gYXR0cmlidXRlTmFtZSB0aGUgbmFtZSBvZiB0aGUgYXR0cmlidXRlXG4gICAqIEByZXR1cm5zIGEgdG9rZW4gZm9yIGBGbjo6R2V0QXR0YCBlbmNvZGVkIGFzIGEgc3RyaW5nLlxuICAgKi9cbiAgZ2V0QXR0U3RyaW5nKGF0dHJpYnV0ZU5hbWU6IHN0cmluZyk6IHN0cmluZztcblxuICAvKipcbiAgICogQXNzZXJ0IHRoYXQgdGhlIEV4cGVjdGVkUmVzdWx0IGlzIGVxdWFsXG4gICAqIHRvIHRoZSByZXN1bHQgb2YgdGhlIEF3c0FwaUNhbGxcbiAgICpcbiAgICogQGV4YW1wbGVcbiAgICogZGVjbGFyZSBjb25zdCBpbnRlZzogSW50ZWdUZXN0O1xuICAgKiBjb25zdCBpbnZva2UgPSBpbnRlZy5hc3NlcnRpb25zLmludm9rZUZ1bmN0aW9uKHtcbiAgICogICBmdW5jdGlvbk5hbWU6ICdteS1mdW5jJyxcbiAgICogfSk7XG4gICAqIGludm9rZS5leHBlY3QoRXhwZWN0ZWRSZXN1bHQub2JqZWN0TGlrZSh7IFBheWxvYWQ6ICdPSycgfSkpO1xuICAgKi9cbiAgZXhwZWN0KGV4cGVjdGVkOiBFeHBlY3RlZFJlc3VsdCk6IElBcGlDYWxsO1xuXG4gIC8qKlxuICAgKiBBc3NlcnQgdGhhdCB0aGUgRXhwZWN0ZWRSZXN1bHQgaXMgZXF1YWxcbiAgICogdG8gdGhlIHJlc3VsdCBvZiB0aGUgQXdzQXBpQ2FsbCBhdCB0aGUgZ2l2ZW4gcGF0aC5cbiAgICpcbiAgICogRm9yIGV4YW1wbGUgdGhlIFNRUy5yZWNlaXZlTWVzc2FnZSBhcGkgcmVzcG9uc2Ugd291bGQgbG9va1xuICAgKiBsaWtlOlxuICAgKlxuICAgKiBJZiB5b3Ugd2FudGVkIHRvIGFzc2VydCB0aGUgdmFsdWUgb2YgYEJvZHlgIHlvdSBjb3VsZCBkb1xuICAgKlxuICAgKiBAZXhhbXBsZVxuICAgKiBjb25zdCBhY3R1YWwgPSB7XG4gICAqICAgTWVzc2FnZXM6IFt7XG4gICAqICAgICBNZXNzYWdlSWQ6ICcnLFxuICAgKiAgICAgUmVjZWlwdEhhbmRsZTogJycsXG4gICAqICAgICBNRDVPZkJvZHk6ICcnLFxuICAgKiAgICAgQm9keTogJ2hlbGxvJyxcbiAgICogICAgIEF0dHJpYnV0ZXM6IHt9LFxuICAgKiAgICAgTUQ1T2ZNZXNzYWdlQXR0cmlidXRlczoge30sXG4gICAqICAgICBNZXNzYWdlQXR0cmlidXRlczoge31cbiAgICogICB9XVxuICAgKiB9O1xuICAgKlxuICAgKlxuICAgKiBkZWNsYXJlIGNvbnN0IGludGVnOiBJbnRlZ1Rlc3Q7XG4gICAqIGNvbnN0IG1lc3NhZ2UgPSBpbnRlZy5hc3NlcnRpb25zLmF3c0FwaUNhbGwoJ1NRUycsICdyZWNlaXZlTWVzc2FnZScpO1xuICAgKlxuICAgKiBtZXNzYWdlLmFzc2VydEF0UGF0aCgnTWVzc2FnZXMuMC5Cb2R5JywgRXhwZWN0ZWRSZXN1bHQuc3RyaW5nTGlrZVJlZ2V4cCgnaGVsbG8nKSk7XG4gICAqL1xuICBhc3NlcnRBdFBhdGgocGF0aDogc3RyaW5nLCBleHBlY3RlZDogRXhwZWN0ZWRSZXN1bHQpOiBJQXBpQ2FsbDtcblxuICAvKipcbiAgICogQWxsb3dzIHlvdSB0byBjaGFpbiBJQXBpQ2FsbHMuIFRoaXMgYWRkcyBhbiBleHBsaWNpdCBkZXBlbmRlbmN5XG4gICAqIGJldHdlZW50IHRoZSB0d28gcmVzb3VyY2VzLlxuICAgKlxuICAgKiBSZXR1cm5zIHRoZSBJQXBpQ2FsbCBwcm92aWRlZCBhcyBgbmV4dGBcbiAgICpcbiAgICogQGV4YW1wbGVcbiAgICogZGVjbGFyZSBjb25zdCBmaXJzdDogSUFwaUNhbGw7XG4gICAqIGRlY2xhcmUgY29uc3Qgc2Vjb25kOiBJQXBpQ2FsbDtcbiAgICpcbiAgICogZmlyc3QubmV4dChzZWNvbmQpO1xuICAgKi9cbiAgbmV4dChuZXh0OiBJQXBpQ2FsbCk6IElBcGlDYWxsO1xuXG4gIC8qKlxuICAgKiBXYWl0IGZvciB0aGUgSUFwaUNhbGwgdG8gcmV0dXJuIHRoZSBleHBlY3RlZCByZXNwb25zZS5cbiAgICogSWYgbm8gZXhwZWN0ZWQgcmVzcG9uc2UgaXMgc3BlY2lmaWVkIHRoZW4gaXQgd2lsbCB3YWl0IGZvclxuICAgKiB0aGUgSUFwaUNhbGwgdG8gcmV0dXJuIGEgc3VjY2Vzc1xuICAgKlxuICAgKiBAZXhhbXBsZVxuICAgKiBkZWNsYXJlIGNvbnN0IGludGVnOiBJbnRlZ1Rlc3Q7XG4gICAqIGRlY2xhcmUgY29uc3QgZXhlY3V0aW9uQXJuOiBzdHJpbmc7XG4gICAqIGludGVnLmFzc2VydGlvbnMuYXdzQXBpQ2FsbCgnU3RlcEZ1bmN0aW9ucycsICdkZXNjcmliZUV4ZWN1dGlvbicsIHtcbiAgICogICAgZXhlY3V0aW9uQXJuLFxuICAgKiB9KS53YWl0Rm9yQXNzZXJ0aW9ucygpO1xuICAgKi9cbiAgd2FpdEZvckFzc2VydGlvbnMob3B0aW9ucz86IFdhaXRlclN0YXRlTWFjaGluZU9wdGlvbnMpOiBJQXBpQ2FsbDtcbn1cblxuLyoqXG4gKiBCYXNlIGNsYXNzIGZvciBhbiBBcGlDYWxsXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBBcGlDYWxsQmFzZSBleHRlbmRzIENvbnN0cnVjdCBpbXBsZW1lbnRzIElBcGlDYWxsIHtcbiAgcHJvdGVjdGVkIGFic3RyYWN0IHJlYWRvbmx5IGFwaUNhbGxSZXNvdXJjZTogQ3VzdG9tUmVzb3VyY2U7XG4gIHByb3RlY3RlZCBleHBlY3RlZFJlc3VsdD86IHN0cmluZztcbiAgcHJvdGVjdGVkIGZsYXR0ZW5SZXNwb25zZTogc3RyaW5nID0gJ2ZhbHNlJztcbiAgcHJvdGVjdGVkIHN0YXRlTWFjaGluZUFybj86IHN0cmluZztcblxuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgcHJvdmlkZXI6IEFzc2VydGlvbnNQcm92aWRlcjtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICB9XG5cbiAgcHVibGljIGdldEF0dChhdHRyaWJ1dGVOYW1lOiBzdHJpbmcpOiBSZWZlcmVuY2Uge1xuICAgIHRoaXMuZmxhdHRlblJlc3BvbnNlID0gJ3RydWUnO1xuICAgIHJldHVybiB0aGlzLmFwaUNhbGxSZXNvdXJjZS5nZXRBdHQoYGFwaUNhbGxSZXNwb25zZS4ke2F0dHJpYnV0ZU5hbWV9YCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0QXR0U3RyaW5nKGF0dHJpYnV0ZU5hbWU6IHN0cmluZyk6IHN0cmluZyB7XG4gICAgdGhpcy5mbGF0dGVuUmVzcG9uc2UgPSAndHJ1ZSc7XG4gICAgcmV0dXJuIHRoaXMuYXBpQ2FsbFJlc291cmNlLmdldEF0dFN0cmluZyhgYXBpQ2FsbFJlc3BvbnNlLiR7YXR0cmlidXRlTmFtZX1gKTtcbiAgfVxuXG4gIHB1YmxpYyBleHBlY3QoZXhwZWN0ZWQ6IEV4cGVjdGVkUmVzdWx0KTogSUFwaUNhbGwge1xuICAgIHRoaXMuZXhwZWN0ZWRSZXN1bHQgPSBleHBlY3RlZC5yZXN1bHQ7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICBwdWJsaWMgYWJzdHJhY3QgYXNzZXJ0QXRQYXRoKHBhdGg6IHN0cmluZywgZXhwZWN0ZWQ6IEV4cGVjdGVkUmVzdWx0KTogSUFwaUNhbGw7XG5cbiAgcHVibGljIG5leHQobmV4dDogSUFwaUNhbGwpOiBJQXBpQ2FsbCB7XG4gICAgbmV4dC5ub2RlLmFkZERlcGVuZGVuY3kodGhpcyk7XG4gICAgcmV0dXJuIG5leHQ7XG4gIH1cblxuICBwdWJsaWMgYWJzdHJhY3Qgd2FpdEZvckFzc2VydGlvbnMob3B0aW9ucz86IFdhaXRlclN0YXRlTWFjaGluZU9wdGlvbnMpOiBJQXBpQ2FsbFxufVxuIl19