"""
Added alarms

Revision ID: ebdd955fcc5e
Revises: 7c3ea5ab5501
Create Date: 2023-03-27 12:37:00.192722

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "ebdd955fcc5e"
down_revision = "7c3ea5ab5501"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table("alarms",
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("updated_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("name", sa.String(length=256), nullable=False),
        sa.Column("criticality", sa.Float(), nullable=False),
        sa.Column("description", sa.TEXT(), nullable=False),
        sa.Column("schema", sa.String(length=256), nullable=True),
        sa.PrimaryKeyConstraint("id")
    )
    op.create_table("main_alarms",
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("updated_at", sa.DateTime(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(), nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("id_alarm", sa.Integer(), nullable=False),
        sa.Column("criticality", sa.Float(), nullable=False),
        sa.Column("message", sa.TEXT(), nullable=False),
        sa.Column("schema", sa.String(length=256), nullable=True),
        sa.ForeignKeyConstraint(["id_alarm"], ["alarms.id"], ),
        sa.PrimaryKeyConstraint("id")
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("main_alarms")
    op.drop_table("alarms")
    # ### end Alembic commands ###
