import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { ZendeskConnectorProfile } from './profile';
import { ConnectorType } from '../core/connectors/connector-type';
import { IFlow } from '../core/flows';
import { ISource } from '../core/vertices/source';
export interface ZendeskSourceProps {
    readonly profile: ZendeskConnectorProfile;
    readonly object: string;
    readonly apiVersion?: string;
}
export declare class ZendeskSource implements ISource {
    private readonly props;
    readonly connectorType: ConnectorType;
    constructor(props: ZendeskSourceProps);
    bind(flow: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
