"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ZendeskConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_profile_1 = require("../core/connectors/connector-profile");
class ZendeskConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    constructor(scope, id, props) {
        super(scope, id, props, type_1.ZendeskConnectorType.instance);
    }
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            zendesk: {
                instanceUrl: properties.instanceUrl,
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            zendesk: {
                accessToken: properties.oAuth.accessToken,
                clientId: properties.oAuth.clientId,
                clientSecret: properties.oAuth.clientSecret,
            },
        };
    }
}
exports.ZendeskConnectorProfile = ZendeskConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
ZendeskConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.ZendeskConnectorProfile", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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