"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesforceConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_profile_1 = require("../core/connectors/connector-profile");
class SalesforceConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    constructor(scope, id, props) {
        super(scope, id, props, type_1.SalesforceConnectorType.instance);
        this.tryAddNodeDependency(this, props.oAuth.flow?.refresTokenGrant.client);
    }
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    buildConnectorProfileProperties(properties) {
        const props = properties;
        return {
            salesforce: {
                isSandboxEnvironment: props.isSandbox,
                instanceUrl: props.instanceUrl,
            },
        };
    }
    buildConnectorProfileCredentials(properties) {
        const props = properties;
        let salesforce = {};
        salesforce.accessToken = props.oAuth.accessToken;
        salesforce.refreshToken = props.oAuth.flow?.refresTokenGrant.refreshToken ?? 'dummyRefreshToken';
        if (props.oAuth.flow?.refresTokenGrant.client) {
            salesforce.clientCredentialsArn = props.oAuth.flow.refresTokenGrant.client.secretArn;
            // TODO: make sure why this doesn't work.
            //       this doc says it should: https://docs.aws.amazon.com/appflow/latest/userguide/salesforce.html
            //       in order to obtain the access token I needed to follow: https://medium.com/@bpmmendis94/obtain-access-refresh-tokens-from-salesforce-rest-api-a324fe4ccd9b
            salesforce.accessToken = salesforce.accessToken ?? 'dummyAccessToken';
        }
        return {
            salesforce: salesforce,
        };
    }
}
exports.SalesforceConnectorProfile = SalesforceConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
SalesforceConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.SalesforceConnectorProfile", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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