import { CfnConnectorProfile } from 'aws-cdk-lib/aws-appflow';
import { ISecret } from 'aws-cdk-lib/aws-secretsmanager';
import { Construct } from 'constructs';
import { ConnectorProfileBase, ConnectorProfileProps } from '../core/connectors/connector-profile';
export interface SalesforceConnectorProfileProps extends ConnectorProfileProps {
    readonly oAuth: SalesforceOAuthSettings;
    readonly instanceUrl: string;
    /**
     * @default false
     */
    readonly isSandbox?: boolean;
}
export interface SalesforceOAuthRefreshTokenGrantFlow {
    readonly refreshToken?: string;
    readonly client?: ISecret;
}
export interface SalesforceOAuthFlow {
    readonly refresTokenGrant: SalesforceOAuthRefreshTokenGrantFlow;
}
export interface SalesforceOAuthSettings {
    readonly accessToken?: string;
    readonly flow?: SalesforceOAuthFlow;
}
export declare class SalesforceConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): SalesforceConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): SalesforceConnectorProfile;
    constructor(scope: Construct, id: string, props: SalesforceConnectorProfileProps);
    protected buildConnectorProfileProperties(properties: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    protected buildConnectorProfileCredentials(properties: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
}
