import { CfnConnectorProfile } from 'aws-cdk-lib/aws-appflow';
import { Construct } from 'constructs';
import { ConnectorProfileBase, ConnectorProfileProps } from '../core/connectors/connector-profile';
export interface SalesforceMarketingCloudConnectorProfileProps extends ConnectorProfileProps {
    readonly oAuth: SalesforceMarketingCloudOAuthSettings;
    readonly instanceUrl: string;
}
export interface SalesforceMarketingCloudOAuthEndpoints {
    readonly token: string;
}
export interface SalesforceMarketingCloudOAuthClientSettings {
    readonly clientId: string;
    readonly clientSecret: string;
}
export interface SalesforceMarketingCloudFlowSettings {
    readonly clientCredentials: SalesforceMarketingCloudOAuthClientSettings;
}
export interface SalesforceMarketingCloudOAuthSettings {
    readonly accessToken?: string;
    readonly flow?: SalesforceMarketingCloudFlowSettings;
    readonly endpoints: SalesforceMarketingCloudOAuthEndpoints;
}
export declare class SalesforceMarketingCloudConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): SalesforceMarketingCloudConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): SalesforceMarketingCloudConnectorProfile;
    constructor(scope: Construct, id: string, props: SalesforceMarketingCloudConnectorProfileProps);
    protected buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
}
