import { ICluster } from '@aws-cdk/aws-redshift-alpha';
import { CfnConnectorProfile } from 'aws-cdk-lib/aws-appflow';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { S3Location } from '../core';
import { ConnectorProfileBase, ConnectorProfileProps } from '../core/connectors/connector-profile';
export interface RedshiftConnectorBasicCredentials {
    readonly username?: string;
    readonly password?: string;
}
export interface RedshiftConnectorProfileProps extends ConnectorProfileProps {
    readonly basicAuth: RedshiftConnectorBasicCredentials;
    /**
     * An intermediate location for the data retrieved from the flow source that will be further transferred to the Redshfit database
     */
    readonly intermediateLocation: S3Location;
    /**
     * The Redshift cluster to use this connector profile with
     */
    readonly cluster: ICluster;
    /**
     * An IAM Role that AppFlow will assume to interact with the Redshift cluster's Data API
     *
     * @default autogenerated IAM role
     */
    readonly dataApiRole?: IRole;
    /**
     * The name of the database which the RedshiftConnectorProfile will be working with
     */
    readonly databaseName: string;
    /**
     * An IAM Role that the Redshift cluster will assume to get data from the intermiediate S3 Bucket
     */
    readonly bucketAccessRole?: IRole;
}
export declare class RedshiftConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): RedshiftConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): RedshiftConnectorProfile;
    /**
     * @internal
     */
    readonly _location: S3Location;
    constructor(scope: Construct, id: string, props: RedshiftConnectorProfileProps);
    protected buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
    private buildRedshiftAccessRole;
    private buildAppFlowDataApiRole;
}
