"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RedshiftDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
class RedshiftDestination {
    constructor(props) {
        this.props = props;
        this.defaultSchema = 'public';
        this.connectorType = type_1.RedshiftConnectorType.instance;
    }
    bind(scope) {
        this.tryAddNodeDependency(scope, this.props.errorHandling?.errorLocation?.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        this.tryAddNodeDependency(scope, this.props.profile);
        this.tryAddNodeDependency(scope, this.props.object.table);
        // NOTE: interesting case that the profile requires to have the table created
        //       without it the deployment failed
        this.tryAddNodeDependency(this.props.profile, this.props.object.table);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            redshift: {
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling.failOnFirstError,
                },
                // TODO: identify if this needs to be the same as the bucketName/prefix in the profile
                //       for now that is the assumption and we're pulling this data from the profile
                intermediateBucketName: this.props.profile._location.bucket.bucketName,
                bucketPrefix: this.props.profile._location.prefix,
                object: this.buildObject(this.props.object.table, this.props.object.schema),
            },
        };
    }
    buildObject(table, schema) {
        const _schema = schema ?? this.defaultSchema;
        if (typeof table === 'string') {
            return `${_schema}.${table}`;
        }
        return `${_schema}.${table.tableName}`;
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.RedshiftDestination = RedshiftDestination;
_a = JSII_RTTI_SYMBOL_1;
RedshiftDestination[_a] = { fqn: "@cdklabs/cdk-appflow.RedshiftDestination", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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