import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { MicrosoftSharepointOnlineConnectorProfile } from './profile';
import { ConnectorType } from '../core/connectors/connector-type';
import { IFlow } from '../core/flows';
import { ISource } from '../core/vertices';
/**
 * Properties of a Google Analytics v4 Source
 */
export interface MicrosoftSharepointOnlineSourceProps {
    readonly profile: MicrosoftSharepointOnlineConnectorProfile;
    readonly apiVersion: string;
    readonly object: string;
}
/**
 * A class that represents a Google Analytics v4 Source
 */
export declare class MicrosoftSharepointOnlineSource implements ISource {
    private readonly props;
    /**
     * The AppFlow type of the connector that this source is implemented for
     */
    readonly connectorType: ConnectorType;
    constructor(props: MicrosoftSharepointOnlineSourceProps);
    bind(scope: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
