"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleAnalytics4Source = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
/**
 * A class that represents a Google Analytics v4 Source
 */
class GoogleAnalytics4Source {
    constructor(props) {
        this.props = props;
        /**
         * The AppFlow type of the connector that this source is implemented for
         */
        this.connectorType = type_1.GoogleAnalytics4ConnectorType.instance;
    }
    bind(scope) {
        this.tryAddNodeDependency(scope, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            apiVersion: this.props.apiVersion,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        return {
            customConnector: {
                entityName: this.props.object,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.GoogleAnalytics4Source = GoogleAnalytics4Source;
_a = JSII_RTTI_SYMBOL_1;
GoogleAnalytics4Source[_a] = { fqn: "@cdklabs/cdk-appflow.GoogleAnalytics4Source", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic291cmNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2dvb2dsZWFuYWx5dGljczQvc291cmNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBT0EsaUNBQXVEO0FBY3ZEOztHQUVHO0FBQ0gsTUFBYSxzQkFBc0I7SUFPakMsWUFBNkIsS0FBa0M7UUFBbEMsVUFBSyxHQUFMLEtBQUssQ0FBNkI7UUFML0Q7O1dBRUc7UUFDYSxrQkFBYSxHQUFrQixvQ0FBNkIsQ0FBQyxRQUFRLENBQUM7SUFFbkIsQ0FBQztJQUVwRSxJQUFJLENBQUMsS0FBWTtRQUVmLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUVyRCxPQUFPO1lBQ0wsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsc0JBQXNCO1lBQ3hELG9CQUFvQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUk7WUFDN0MsVUFBVSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVTtZQUNqQyx5QkFBeUIsRUFBRSxJQUFJLENBQUMsOEJBQThCLEVBQUU7U0FDakUsQ0FBQztJQUNKLENBQUM7SUFFTyw4QkFBOEI7UUFDcEMsT0FBTztZQUNMLGVBQWUsRUFBRTtnQkFDZixVQUFVLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNO2FBQzlCO1NBQ0YsQ0FBQztJQUNKLENBQUM7SUFFTyxvQkFBb0IsQ0FBQyxLQUFpQixFQUFFLFFBQThCO1FBQzVFLElBQUksUUFBUSxJQUFJLE9BQU8sUUFBUSxLQUFLLFFBQVEsRUFBRTtZQUM1QyxLQUFLLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxRQUFRLENBQUMsQ0FBQztTQUNwQztJQUNILENBQUM7O0FBakNILHdEQWtDQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgQ2ZuRmxvdyB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1hcHBmbG93JztcbmltcG9ydCB7IElDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IEdvb2dsZUFuYWx5dGljczRDb25uZWN0b3JQcm9maWxlIH0gZnJvbSAnLi9wcm9maWxlJztcbmltcG9ydCB7IEdvb2dsZUFuYWx5dGljczRDb25uZWN0b3JUeXBlIH0gZnJvbSAnLi90eXBlJztcbmltcG9ydCB7IENvbm5lY3RvclR5cGUgfSBmcm9tICcuLi9jb3JlL2Nvbm5lY3RvcnMvY29ubmVjdG9yLXR5cGUnO1xuaW1wb3J0IHsgSUZsb3cgfSBmcm9tICcuLi9jb3JlL2Zsb3dzJztcbmltcG9ydCB7IElTb3VyY2UgfSBmcm9tICcuLi9jb3JlL3ZlcnRpY2VzJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIG9mIGEgR29vZ2xlIEFuYWx5dGljcyB2NCBTb3VyY2VcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBHb29nbGVBbmFseXRpY3M0U291cmNlUHJvcHMge1xuICByZWFkb25seSBwcm9maWxlOiBHb29nbGVBbmFseXRpY3M0Q29ubmVjdG9yUHJvZmlsZTtcbiAgcmVhZG9ubHkgYXBpVmVyc2lvbjogc3RyaW5nO1xuICByZWFkb25seSBvYmplY3Q6IHN0cmluZztcbn1cblxuLyoqXG4gKiBBIGNsYXNzIHRoYXQgcmVwcmVzZW50cyBhIEdvb2dsZSBBbmFseXRpY3MgdjQgU291cmNlXG4gKi9cbmV4cG9ydCBjbGFzcyBHb29nbGVBbmFseXRpY3M0U291cmNlIGltcGxlbWVudHMgSVNvdXJjZSB7XG5cbiAgLyoqXG4gICAqIFRoZSBBcHBGbG93IHR5cGUgb2YgdGhlIGNvbm5lY3RvciB0aGF0IHRoaXMgc291cmNlIGlzIGltcGxlbWVudGVkIGZvclxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGNvbm5lY3RvclR5cGU6IENvbm5lY3RvclR5cGUgPSBHb29nbGVBbmFseXRpY3M0Q29ubmVjdG9yVHlwZS5pbnN0YW5jZTtcblxuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBHb29nbGVBbmFseXRpY3M0U291cmNlUHJvcHMpIHsgfVxuXG4gIGJpbmQoc2NvcGU6IElGbG93KTogQ2ZuRmxvdy5Tb3VyY2VGbG93Q29uZmlnUHJvcGVydHkge1xuXG4gICAgdGhpcy50cnlBZGROb2RlRGVwZW5kZW5jeShzY29wZSwgdGhpcy5wcm9wcy5wcm9maWxlKTtcblxuICAgIHJldHVybiB7XG4gICAgICBjb25uZWN0b3JUeXBlOiB0aGlzLmNvbm5lY3RvclR5cGUuYXNQcm9maWxlQ29ubmVjdG9yVHlwZSxcbiAgICAgIGNvbm5lY3RvclByb2ZpbGVOYW1lOiB0aGlzLnByb3BzLnByb2ZpbGUubmFtZSxcbiAgICAgIGFwaVZlcnNpb246IHRoaXMucHJvcHMuYXBpVmVyc2lvbixcbiAgICAgIHNvdXJjZUNvbm5lY3RvclByb3BlcnRpZXM6IHRoaXMuYnVpbGRTb3VyY2VDb25uZWN0b3JQcm9wZXJ0aWVzKCksXG4gICAgfTtcbiAgfVxuXG4gIHByaXZhdGUgYnVpbGRTb3VyY2VDb25uZWN0b3JQcm9wZXJ0aWVzKCk6IENmbkZsb3cuU291cmNlQ29ubmVjdG9yUHJvcGVydGllc1Byb3BlcnR5IHtcbiAgICByZXR1cm4ge1xuICAgICAgY3VzdG9tQ29ubmVjdG9yOiB7XG4gICAgICAgIGVudGl0eU5hbWU6IHRoaXMucHJvcHMub2JqZWN0LFxuICAgICAgfSxcbiAgICB9O1xuICB9XG5cbiAgcHJpdmF0ZSB0cnlBZGROb2RlRGVwZW5kZW5jeShzY29wZTogSUNvbnN0cnVjdCwgcmVzb3VyY2U/OiBJQ29uc3RydWN0IHwgc3RyaW5nKTogdm9pZCB7XG4gICAgaWYgKHJlc291cmNlICYmIHR5cGVvZiByZXNvdXJjZSAhPT0gJ3N0cmluZycpIHtcbiAgICAgIHNjb3BlLm5vZGUuYWRkRGVwZW5kZW5jeShyZXNvdXJjZSk7XG4gICAgfVxuICB9XG59Il19