import { CfnConnectorProfile } from 'aws-cdk-lib/aws-appflow';
import { Construct } from 'constructs';
import { ConnectorProfileBase, ConnectorProfileProps } from '../core/connectors/connector-profile';
export interface GoogleAnalytics4ConnectorProfileProps extends ConnectorProfileProps {
    readonly oAuth: GoogleAnalytics4OAuthSettings;
}
export interface GoogleAnalytics4OAuthEndpointsSettings {
    readonly token?: string;
    readonly authorization?: string;
}
export interface GoogleAnalytics4RefreshTokenGrantFlow {
    readonly refreshToken?: string;
    readonly clientSecret?: string;
    readonly clientId?: string;
}
export interface GoogleAnalytics4OAuthFlow {
    readonly refreshTokenGrant: GoogleAnalytics4RefreshTokenGrantFlow;
}
export interface GoogleAnalytics4OAuthSettings {
    /**
     * The access token to be used when interacting with Google Analytics 4
     *
     * Note that if only the access token is provided AppFlow is not able to retrieve a fresh access token when the current one is expired
     */
    readonly accessToken?: string;
    readonly flow?: GoogleAnalytics4OAuthFlow;
    readonly endpoints?: GoogleAnalytics4OAuthEndpointsSettings;
}
export declare class GoogleAnalytics4ConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): GoogleAnalytics4ConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): GoogleAnalytics4ConnectorProfile;
    private static readonly defaultTokenEndpoint;
    constructor(scope: Construct, id: string, props: GoogleAnalytics4ConnectorProfileProps);
    protected buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
}
