"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgeDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
const flows_1 = require("../core/flows");
class EventBridgeDestination {
    constructor(props) {
        this.props = props;
        this.compatibleFlows = [flows_1.FlowType.EVENT];
        this.connectorType = type_1.EventBridgeConnectorType.instance;
    }
    bind(flow) {
        if (!this.compatibleFlows.includes(flow.type)) {
            throw new Error(`Flow of type ${flow.type} does not support EventBridge as a destination`);
        }
        this.tryAddNodeDependency(flow, this.props.errorHandling?.errorLocation?.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            eventBridge: {
                object: this.props.partnerBus,
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket?.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling?.failOnFirstError,
                },
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.EventBridgeDestination = EventBridgeDestination;
_a = JSII_RTTI_SYMBOL_1;
EventBridgeDestination[_a] = { fqn: "@cdklabs/cdk-appflow.EventBridgeDestination", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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