import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { ConnectorType } from '../core/connectors/connector-type';
import { ErrorHandlingConfiguration } from '../core/error-handling';
import { IFlow } from '../core/flows';
import { IDestination } from '../core/vertices/destination';
export interface EventBridgeDestinationProps {
    readonly partnerBus: string;
    readonly errorHandling?: ErrorHandlingConfiguration;
}
export declare class EventBridgeDestination implements IDestination {
    private readonly props;
    private readonly compatibleFlows;
    readonly connectorType: ConnectorType;
    constructor(props: EventBridgeDestinationProps);
    bind(flow: IFlow): CfnFlow.DestinationFlowConfigProperty;
    private buildDestinationConnectorProperties;
    private tryAddNodeDependency;
}
