"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Filter = exports.FilterCondition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const operation_1 = require("./operation");
const tasks_1 = require("./tasks");
/**
 * A representation of a filter operation condtiion on a source record field
 */
class FilterCondition {
    constructor(field, filter, properties) {
        this.field = field;
        this.filter = filter;
        this.properties = properties;
        if (!field.dataType) {
            throw new Error('field dataType required');
        }
    }
    /**
     * A condition testing whether a string-type source field contains the given value(s).
     * NOTE: When multiple values are passed the evaluation is resolved as logical OR
     * @param field a source field of a string type
     * @param val a value (or values) to be contained by the field value
     * @returns an instance of a @see FilterCondition
     */
    static stringContains(field, val) {
        return FilterCondition.stringCondition(field, val, 'CONTAINS');
    }
    /**
     * A condition testing whether a string-type source field equals the given value(s).
     * NOTE: When multiple values are passed the evaluation is resolved as logical OR
     * @param field a source field of a string type
     * @param val a value (or values) to be contained by the field value
     * @returns an instance of a @see FilterCondition
     */
    static stringEquals(field, val) {
        return FilterCondition.stringCondition(field, val, 'EQUAL_TO');
    }
    /**
     * A condition testing whether a string-type source field does not equal the given value(s).
     * NOTE: When multiple values are passed the evaluation is resolved as logical OR
     * @param field a source field of a string type
     * @param val a value (or values) to be contained by the field value
     * @returns an instance of a @see FilterCondition
     */
    static stringNotEquals(field, val) {
        return FilterCondition.stringCondition(field, val, 'NOT_EQUAL_TO');
    }
    static booleanEquals(field, val) {
        return FilterCondition.booleanCondition(field, val, 'EQUAL_TO');
    }
    static booleanNotEquals(field, val) {
        return FilterCondition.booleanCondition(field, val, 'NOT_EQUAL_TO');
    }
    static numberEquals(field, val) {
        return FilterCondition.numberCondition(field, val, 'EQUAL_TO');
    }
    static numberNotEquals(field, val) {
        return FilterCondition.numberCondition(field, val, 'NOT_EQUAL_TO');
    }
    static numberLessThan(field, val) {
        return FilterCondition.numberCondition(field, val, 'LESS_THAN');
    }
    static numberLessThanEquals(field, val) {
        return FilterCondition.numberCondition(field, val, 'LESS_THAN_OR_EQUAL_TO');
    }
    static numberGreaterThan(field, val) {
        return FilterCondition.numberCondition(field, val, 'GREATER_THAN');
    }
    static numberGreaterThanEquals(field, val) {
        return FilterCondition.numberCondition(field, val, 'GREATER_THAN_OR_EQUAL_TO');
    }
    static timestampEquals(field, val) {
        return FilterCondition.timestampCondition(field, val, 'EQUAL_TO');
    }
    static timestampNotEquals(field, val) {
        return FilterCondition.timestampCondition(field, val, 'NOT_EQUAL_TO');
    }
    static timestampLessThan(field, val) {
        return FilterCondition.timestampCondition(field, val, 'LESS_THAN');
    }
    static timestampLessThanEquals(field, val) {
        return FilterCondition.timestampCondition(field, val, 'LESS_THAN_OR_EQUAL_TO');
    }
    static timestampGreaterThan(field, val) {
        return FilterCondition.timestampCondition(field, val, 'GREATER_THAN');
    }
    static timestampGreaterThanEquals(field, val) {
        return FilterCondition.timestampCondition(field, val, 'GREATER_THAN_OR_EQUAL_TO');
    }
    static timestampBetween(field, lower, upper) {
        return new FilterCondition(field, 'BETWEEN', {
            DATA_TYPE: field.dataType,
            LOWER_BOUND: this.valueToString(lower),
            UPPER_BOUND: this.valueToString(upper),
        });
    }
    static stringCondition(field, val, filter) {
        if (Array.isArray(val)) {
            return new FilterCondition(field, filter, {
                DATA_TYPE: field.dataType,
                VALUES: val.map(m => this.valueToString(m)).join(','),
            });
        }
        return new FilterCondition(field, filter, {
            DATA_TYPE: field.dataType,
            VALUE: this.valueToString(val),
        });
    }
    static numberCondition(field, val, filter) {
        if (Array.isArray(val)) {
            return new FilterCondition(field, filter, {
                DATA_TYPE: field.dataType,
                VALUES: val.map(m => this.valueToString(m)).join(','),
            });
        }
        return new FilterCondition(field, filter, {
            DATA_TYPE: field.dataType,
            VALUE: this.valueToString(val),
        });
    }
    static booleanCondition(field, val, filter) {
        if (Array.isArray(val)) {
            return new FilterCondition(field, filter, {
                DATA_TYPE: field.dataType,
                VALUES: val.map(m => this.valueToString(m)).join(','),
            });
        }
        return new FilterCondition(field, filter, {
            DATA_TYPE: field.dataType,
            VALUE: this.valueToString(val),
        });
    }
    static timestampCondition(field, val, filter) {
        if (Array.isArray(val)) {
            return new FilterCondition(field, filter, {
                DATA_TYPE: field.dataType,
                VALUES: val.map(m => this.valueToString(m)).join(','),
            });
        }
        return new FilterCondition(field, filter, {
            DATA_TYPE: field.dataType,
            VALUE: this.valueToString(val),
        });
    }
    static valueToString(value) {
        const t = typeof value;
        switch (t) {
            case 'string':
                return value;
            case 'number':
            case 'boolean':
                return `${value}`;
            default: // meaning: Date
                return value.getTime().toString();
        }
    }
}
exports.FilterCondition = FilterCondition;
_a = JSII_RTTI_SYMBOL_1;
FilterCondition[_a] = { fqn: "@cdklabs/cdk-appflow.FilterCondition", version: "0.0.2" };
/**
 * A representation of a mapping operation, that is an operation filtering records at the source
 */
class Filter extends operation_1.OperationBase {
    constructor(condition) {
        super([new tasks_1.Task('Filter', [condition.field.name], 
            // TODO: think about source/destination here
            { operation: condition.filter }, condition.properties)]);
        this.condition = condition;
    }
    /**
     * Builds a filter operation on source
     * @param condition a @see FilterCondition instance
     * @returns
     */
    static when(condition) { return new Filter(condition); }
}
exports.Filter = Filter;
_b = JSII_RTTI_SYMBOL_1;
Filter[_b] = { fqn: "@cdklabs/cdk-appflow.Filter", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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