"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TriggeredFlowBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const flow_base_1 = require("./flow-base");
class TriggeredFlowBase extends flow_base_1.FlowBase {
    constructor(scope, id, props, autoActivate) {
        super(scope, id, props);
        if (autoActivate) {
            const activatorId = `${id}Activator`;
            // TODO: this is too basic. test it more to identify any potential errors/issues
            const activator = new custom_resources_1.AwsCustomResource(scope, activatorId, {
                onCreate: {
                    service: 'Appflow',
                    action: 'startFlow',
                    parameters: {
                        flowName: this.name,
                    },
                    physicalResourceId: custom_resources_1.PhysicalResourceId.of(activatorId),
                },
                onDelete: {
                    service: 'Appflow',
                    action: 'stopFlow',
                    parameters: {
                        flowName: this.name,
                    },
                },
                policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                    resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
                }),
            });
            activator.node.addDependency(this);
        }
    }
}
exports.TriggeredFlowBase = TriggeredFlowBase;
_a = JSII_RTTI_SYMBOL_1;
TriggeredFlowBase[_a] = { fqn: "@cdklabs/cdk-appflow.TriggeredFlowBase", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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