import { OnEventOptions, Rule } from 'aws-cdk-lib/aws-events';
import { Construct } from 'constructs';
import { FlowBase, FlowBaseProps, FlowProps, IFlow } from './flow-base';
export interface TriggeredFlowBaseProps extends FlowProps {
    readonly autoActivate?: boolean;
}
export declare abstract class TriggeredFlowBase extends FlowBase implements IFlow {
    constructor(scope: Construct, id: string, props: FlowBaseProps, autoActivate?: boolean);
    abstract onDeactivated(id: string, options?: OnEventOptions): Rule;
}
