"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlowTimeUpdater = void 0;
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const api = require("./handler/api");
class FlowTimeUpdater extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const resource = new aws_cdk_lib_1.CustomResource(this, 'Resource', {
            serviceToken: FlowTimeUpdaterProvider.getOrCreate(this),
            resourceType: 'Custom::FlowTimeUpdater',
            properties: {
                [api.PROP_SCHEDULE]: props.schedule.expressionString,
                [api.PROP_STARTTIME]: props.startTime && props.startTime.toISOString(),
                [api.PROP_ENDTIME]: props.endTime && props.endTime.toISOString(),
            },
        });
        this.scheduleExpression = resource.getAttString(api.ATTR_SCHEDULE);
        this.startTime = aws_cdk_lib_1.Token.asNumber(resource.getAtt(api.ATTR_STARTTIME));
        this.endTime = aws_cdk_lib_1.Token.asNumber(resource.getAtt(api.ATTR_ENDTIME));
    }
}
exports.FlowTimeUpdater = FlowTimeUpdater;
class FlowTimeUpdaterProvider extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.provider = new custom_resources_1.Provider(this, 'flow-time-provider', {
            onEventHandler: new aws_lambda_1.Function(this, 'flow-time-on-event', {
                code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'handler')),
                runtime: aws_lambda_1.Runtime.NODEJS_16_X,
                handler: 'index.onEvent',
            }),
        });
    }
    /**
     * Returns the singleton provider.
     */
    static getOrCreate(scope) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = 'com.amazonaws.cdk.custom-resources.flow-time-provider';
        const x = stack.node.tryFindChild(id) || new FlowTimeUpdaterProvider(stack, id);
        return x.provider.serviceToken;
    }
}
//# sourceMappingURL=data:application/json;base64,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