import pandas as pd

def clean_dataframe(df):
    """Cleans a DataFrame by:
    - Replacing NaN values with 0 for integer (int, bigint) columns.
    - Replacing NaN values with 0.0 for float (float, double, numeric, decimal) columns.
    - Replacing NaN values with 'Unknown' for non-numeric columns.
    - Stripping leading/trailing whitespace from string columns.
    """
    df = df.copy()  # Work on a copy to avoid SettingWithCopyWarning

    for col in df.columns:
        if pd.api.types.is_integer_dtype(df[col]):
            df[col] = df[col].fillna(0)  # Replace NaN with 0 in int/bigint columns
        elif pd.api.types.is_float_dtype(df[col]):
            df[col] = df[col].fillna(0.0)  # Replace NaN with 0.0 in float/numeric/decimal columns
        else:
            df[col] = df[col].astype(str).str.strip().replace({"nan": "Unknown", "None": "Unknown"})  # Handle NaN in strings

    return df
