from enum import Enum


class ThermostatMode(Enum):
    OFF: 0x0001
    HEAT: 0x0002
    COOL: 0x0004
    AUTO: 0x0008
    AUX_HEAT: 0x0010
    RESUME: 0x0020
    FAN_ONLY: 0x0040
    FURNACE: 0x0080
    DRY_AIR: 0x0100
    MOIST_AIR: 0x0200
    AUTO_CHANGEOVER: 0x0400
    ENERGY_SAVE_HEAT: 0x0800
    ENERGY_SAVE_COOL: 0x1000
    AWAY: 0x2000
    FULL_POWER: 0x4000
    MANUFACTURER_SPECEFIC: 0x8000


class ThermostatFanMode(Enum):
    AUTO_LOW: 0x0001
    LOW: 0x0002
    AUTO_HIGH: 0x0004
    HIGH: 0x0008
    AUTO_MEDIUM: 0x0010
    MEDIUM: 0x0020
    CIRCULATION: 0x4000
    HUMIDITY_CIRCULATION: 0x0080
    LEFT_RIGHT: 0x0100
    UP_DOWN: 0x0200
    QUIET: 0x0400
    EXTERNAL_CIRCULATION: 0x0800
    MANUFACTURER_SPECEFIC: 0x1000
