import logging  # noqa: INP001
import sqlite3

from .table import QolsysTable

LOGGER = logging.getLogger(__name__)


class QolsysTableEuEvent(QolsysTable):

    def __init__(self, db: sqlite3.Connection, cursor: sqlite3.Cursor) -> None:
        super().__init__(db, cursor)
        self._uri = "content://com.qolsys.qolsysprovider.EUEventContentProvider/eu_event"
        self._table = "eu_event"
        self._abort_on_error = False
        self._implemented = True


        self._columns = [
            "_id",
            "version",
            "opr",
            "partition_id",
            "history_id",
            "device_id",
            "device",
            "events",
            "time",
            "ack",
            "type",
        ]

        self._create_table()
