import unittest

from sapiopylib.rest.User import SapioUser

from sapiopycommons.multimodal.multimodal import MultiModalManager
from sapiopycommons.multimodal.multimodal_data import MultiSequenceAlignmentRequestPojo, MAFFTRunOptions, MAFFTStrategy, \
    MultiSequenceAlignmentTool, MultiSequenceAlignmentSeqPojo, MultiSeqAlignemntSeqType

user = SapioUser(url="https://linux-vm:8443/webservice/api", verify_ssl_cert=False,
                 guid="3c232543-f407-4828-aae5-b33d4cd31fa7",
                 username="yqiao_api", password="Password1!")


class MAFFT_Test(unittest.TestCase):
    def test_plain_json(self):
        json = """
{
  "inputSeqs": [
    {
      "seqId": "1ed1b624-e687-46a4-809f-3bd4b6c092b6",
      "seqString": "MMFSGFNADYEASSSRCSSASPAGDSLSYYHSPADSFSSMGSPVNAQDFCTDLAVSSANFIPTVTAISTSPDLQWLVQPALVSSVAPSQTRAPHPFGVPAPSAGAYSRAGVVKTMTGGRAQSIGRRGKVEQLSPEEEEKRRIRRERNKMAAAKCRNRRRELTDTLQAETDQLEDEKSALQTEIANLLKEKEKLEFILAAHRPACKIPDDLGFPEEMSVASLDLTGGLPEVATPESEEAFTLPLLNDPEPKPSVEPVKSISSMELKTEPFDDFLFPASSRPSGSETARSVPDMDLSGSFYAADWEPLHSGSLGMGPMATELEPLCTPVVTCTPSCTAYTSSFVFTYPEADSFPSCAAAHRKGSSSNEPSSDSLSSPTLLAL"
    },
    {
      "seqId": "63a5827e-68d0-4cb8-a60b-54837eb872d5",
      "seqString": "MFQAFPGDYDSGSRCSSSPSAESQYLSSVDSFGSPPTAAASQECAGLGEMPGSFVPTVTAITTSQDLQWLVQPTLISSMAQSQGQPLASQPPVVDPYDMPGTSYSTPGMSGYSSGGASGSGGPSTSGTTSGPGPARPARARPRRPREETETDQLEEEKAELESEIAELQKEKERLEFVLVAHKPGCKIPYEEGPGPGPLAEVRDLPGSAPAKEDGFSWLLPPPPPPPLPFQTSQDAPPNLTASLFTHSEVQVLGDPFPVVNPSYTSSFVLTCPEVSAFAGAQRTSGSDQPSDPLNSPSLLAL"
    },
    {
      "seqId": "9f64a046-a0ce-4e5c-87b3-fc2fcbae5e4d",
      "seqString": "MFRDFGEPGPSSGNGGGYGGPAQPPAAAQAAQQISPEEEERRRVRRERNKLAAAKCRNRRKELTDFLQAETDKLEDEKSGLQREIEELQKQKERLELVLEAHRPICKIPEGAKEGDTGSTSGTSSPPAPCRPVPCISLSPGPVLEPEALHTPTLMTTPSLTPFTPSLVFTYPSTPEPCASAHRKSSSSSGDPSSDPLGSPTLLAL"
    },
    {
      "seqId": "0f829b72-e35b-4018-be02-7413d56d8309",
      "seqString": "MYQDYPGNFDTSSRGSSGSPAHAESYSSGGGGQQKFRVDMPGSGSAFIPTINAITTSQDLQWMVQPTVITSMSNPYPRSHPYSPLPGLASVPGHMALPRPGVIKTIGTTVGRRRRDEQLSPEEEEKRRIRRERNKLAAAKCRNRRRELTEKLQAETEELEEEKSGLQKEIAELQKEKEKLEFMLVAHGPVCKISPEERRSPPAPGLQPMRSGGGSVGAVVVKQEPLEEDSPSSSSAGLDKAQRSVIKPISIAGGFYGEEPLHTPIVVTSTPAVTPGTSNLVFTYPSVLEQESPASPSESCSKAHRRSSSSGDQSSDSLNSPTLLAL"
    }
  ],
  "parameters": {
    "strategy": "L_INS_i",
    "noScore": true,
    "op": 1.53,
    "ep": 0.123,
    "lop": -2,
    "lep": 0.1,
    "lexp": -0.1,
    "LOP": -6,
    "LEXP": 0,
    "fmodel": false
  },
  "tool": "MAFFT",
  "seqType": "amino"
}
        """
        response = user.plugin_post("bio/multisequencealignment", payload=json, is_payload_plain_text=True)
        user.raise_for_status(response)
        self.assertTrue(response.text)
        print(response.text)

    def test_multimodal_data(self):
        from  sapiopycommons.multimodal.multimodal_data import MultiSequenceAlignmentSeqPojo as SeqPojo
        options = MAFFTRunOptions(strategy=MAFFTStrategy.FFT_NS_2, op=1.6).to_json()
        sequences = [SeqPojo.create("1ed1b624-e687-46a4-809f-3bd4b6c092b6", "MMFSGFNADYEASSSRCSSASPAGDSLSYYHSPADSFSSMGSPVNAQDFCTDLAVSSANFIPTVTAISTSPDLQWLVQPALVSSVAPSQTRAPHPFGVPAPSAGAYSRAGVVKTMTGGRAQSIGRRGKVEQLSPEEEEKRRIRRERNKMAAAKCRNRRRELTDTLQAETDQLEDEKSALQTEIANLLKEKEKLEFILAAHRPACKIPDDLGFPEEMSVASLDLTGGLPEVATPESEEAFTLPLLNDPEPKPSVEPVKSISSMELKTEPFDDFLFPASSRPSGSETARSVPDMDLSGSFYAADWEPLHSGSLGMGPMATELEPLCTPVVTCTPSCTAYTSSFVFTYPEADSFPSCAAAHRKGSSSNEPSSDSLSSPTLLAL"),
                     SeqPojo.create("0f829b72-e35b-4018-be02-7413d56d8309", "MYQDYPGNFDTSSRGSSGSPAHAESYSSGGGGQQKFRVDMPGSGSAFIPTINAITTSQDLQWMVQPTVITSMSNPYPRSHPYSPLPGLASVPGHMALPRPGVIKTIGTTVGRRRRDEQLSPEEEEKRRIRRERNKLAAAKCRNRRRELTEKLQAETEELEEEKSGLQKEIAELQKEKEKLEFMLVAHGPVCKISPEERRSPPAPGLQPMRSGGGSVGAVVVKQEPLEEDSPSSSSAGLDKAQRSVIKPISIAGGFYGEEPLHTPIVVTSTPAVTPGTSNLVFTYPSVLEQESPASPSESCSKAHRRSSSSGDQSSDSLNSPTLLAL")]
        request = MultiSequenceAlignmentRequestPojo(MultiSequenceAlignmentTool.MAFFT, MultiSeqAlignemntSeqType.amino, sequences, options)
        reg_man = MultiModalManager(user)
        result = reg_man.run_multi_sequence_alignment(request)
        self.assertTrue(len(result) == 2)
        print(result)
