from typing import List
from pydantic import BaseModel

from pyrdfrules.common.rule.resultrule import ResultRule


class Ruleset(BaseModel):
    """
    Class representing a list of mined rules from RDFRules.

    Args:
        rules (List[Rule]): List of mined rules from RDFRules.
    """
    
    """
    List of rules generated by RDFRules.
    """
    rules: List[ResultRule]
    
    """
    True if the ruleset is complete.

    Returns:
        _type_: _description_
    """
    is_finished: bool = False
    
    """
    Index of the ruleset iterator.

    Returns:
        int: Iterator index.
    """
    __iterator_index: int = 0
    
    def get_rules(self) -> List[ResultRule]:
        """Returns the list of rules.
        
        Returns:
            List[ResultRule]: List of rules.
        """
        
        return self.rules
    
    def as_text(self) -> str:
        """Serialize the ruleset into a text representation.

        Returns:
            str: Text representation of the ruleset.
        """
        return "\n".join([rule.as_text() for rule in self.rules])
    
    # endregion
    
    # todo - sort by functions, serialisation, deserialisation, export to some well-known formats for further analysis