# generated by datamodel-codegen:
#   filename:  https://raw.githubusercontent.com/propi/rdfrules/refs/heads/master/http/schema/pipeline.json
#   timestamp: 2025-01-02T18:33:57+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Literal, Optional, Union

from pydantic import AnyUrl, BaseModel, ConfigDict, Field, RootModel


class BaseObject(BaseModel):
    pass


class GraphPath(RootModel[str]):
    root: str = Field(
        ...,
        pattern='^.+[.](ttl|nt|nq|json|jsonld|xml|rdf|owl|trig|trix|tsv|sql|cache)([.](gz|bz2))?$',
        title='Choose a file from the workspace',
    )
    """
    Load a file from the workspace on the server side. The dataset format is detected automatically by the file extension. Supported extensions are .ttl (turtle), .nt (n-triples), .nq (n-quads), .json | .jsonld (JSON-LD), .xml | .rdf | .owl (RDF/XML), .trig (TriG), .trix (TriX), .tsv, .sql, .cache (internal binary format). All formats can be compressed by GZIP or BZ2 (e.g. data.ttl.gz).
    """


class PrefixesPath(RootModel[str]):
    root: str = Field(..., pattern='^.+[.]ttl$', title='Choose a file from the workspace')
    """
    It is possible to load a file with prefixes in the Turtle (.ttl) format from the workspace on the server side.
    """


class PrefixesUrl(RootModel[AnyUrl]):
    root: AnyUrl = Field(..., title='URL')
    """
    A URL to a remote file to be loaded. If this is specified then the workspace file is ommited.
    """


class IndexPath(RootModel[str]):
    root: str = Field(..., title='Choose a file from the workspace')
    """
    You can load a serialized index file from the workspace on the server side (just click onto a file name).
    """


class RulesetPath(RootModel[str]):
    root: str = Field(..., title='Choose a file from the workspace')
    """
    You can load a serialized ruleset file from the workspace on the server side (just click onto a file name).
    """


class PredictionPath(RootModel[str]):
    root: str = Field(..., title='Choose a file from the workspace')
    """
    You can load a serialized prediction file from the workspace on the server side (just click onto a file name).
    """


class GraphUrl(RootModel[AnyUrl]):
    root: AnyUrl = Field(..., title='URL')
    """
    A URL to a remote file to be loaded. If this is specified then the workspace file is ommited.
    """


class GraphName(RootModel[str]):
    root: str = Field(..., pattern='^<.*>$', title='Graph name')
    """
    Name for this loaded graph. It must have the URI notation in angle brackets, e.g., <dbpedia> or `<http://dbpedia.org>`.
    """


class SourceSettings(Enum):
    tsvRaw = 'tsvRaw'
    tsvParsedUris = 'tsvParsedUris'
    tsvParsedLiterals = 'tsvParsedLiterals'


class RulesFormatEnum(Enum):
    ndjson = 'ndjson'
    json = 'json'
    cache = 'cache'


class RulesFormat(RootModel[List[RulesFormatEnum]]):
    root: List[RulesFormatEnum] = Field(..., title='Rules format')
    """
    The ruleset format.
    """


class PredictionsFormatEnum(Enum):
    ndjson = 'ndjson'
    json = 'json'
    cache = 'cache'


class PredictionsFormat(RootModel[List[PredictionsFormatEnum]]):
    root: List[PredictionsFormatEnum] = Field(..., title='Prediction format')
    """
    The prediction format.
    """


class QuadFilter(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    subject: Optional[str] = None
    predicate: Optional[str] = None
    object: Optional[str] = None
    graph: Optional[str] = None
    inverse: Optional[bool] = None


class Prefix(BaseModel):
    prefix: Optional[str] = Field(None, pattern='[0-9a-zA-Z]\\w*')
    nameSpace: Optional[str] = Field(None, pattern='\\S+[/#?=&]')


class LoadGraph(BaseModel):
    name: Literal['LoadGraph'] = 'LoadGraph'
    parameters: Optional[BaseObject] = None


class LoadDataset(BaseModel):
    name: Literal['LoadDataset'] = 'LoadDataset'
    parameters: Optional[BaseObject] = None


class LoadIndex(BaseModel):
    name: Literal['LoadIndex'] = 'LoadIndex'
    parameters: Optional[BaseObject] = None


class LoadRulesetWithoutIndex(BaseModel):
    name: Literal['LoadRulesetWithoutIndex'] = 'LoadRulesetWithoutIndex'
    parameters: Optional[BaseObject] = None


class LoadPredictionWithoutIndex(BaseModel):
    name: Literal['LoadRulesetWithoutIndex'] = 'LoadRulesetWithoutIndex'
    parameters: Optional[BaseObject] = None


class FilterQuads(BaseModel):
    name: Literal['FilterQuads'] = 'FilterQuads'
    parameters: Optional[BaseObject] = None


class AddPrefixes(BaseModel):
    name: Literal['AddPrefixes'] = 'AddPrefixes'
    parameters: Optional[BaseObject] = None


class CacheDataset(BaseModel):
    name: Literal['CacheDataset'] = 'CacheDataset'
    parameters: Optional[BaseObject] = None


class Model(
    RootModel[
        List[
            Union[
                LoadGraph,
                LoadDataset,
                LoadIndex,
                LoadRulesetWithoutIndex,
                LoadPredictionWithoutIndex,
                FilterQuads,
                AddPrefixes,
                CacheDataset,
            ]
        ]
    ]
):
    root: List[
        Union[
            LoadGraph,
            LoadDataset,
            LoadIndex,
            LoadRulesetWithoutIndex,
            LoadPredictionWithoutIndex,
            FilterQuads,
            AddPrefixes,
            CacheDataset,
        ]
    ]
