"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkloadScheduling = exports.Workload = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const pod = require("./pod");
const utils_1 = require("./utils");
/**
 * A workload is an application running on Kubernetes. Whether your workload is a single
 * component or several that work together, on Kubernetes you run it inside a set of pods.
 * In Kubernetes, a Pod represents a set of running containers on your cluster.
 */
class Workload extends pod.AbstractPod {
    constructor(scope, id, props = {}) {
        var _c;
        super(scope, id, props);
        this._selectors = [];
        this.podMetadata = new cdk8s_1.ApiObjectMetadataDefinition(props.podMetadata);
        this.scheduling = new WorkloadScheduling(this);
        const matcher = cdk8s_1.Names.toLabelValue(this);
        this.podMetadata.addLabel(pod.Pod.ADDRESS_LABEL, matcher);
        if ((_c = props.select) !== null && _c !== void 0 ? _c : true) {
            this.select(pod.LabelSelector.of({ labels: { [pod.Pod.ADDRESS_LABEL]: matcher } }));
        }
    }
    /**
     * Configure selectors for this workload.
     */
    select(...selectors) {
        this._selectors.push(...selectors.map(s => s._toKube()));
    }
    /**
     * The label matchers this workload will use in order to select pods.
     *
     * Returns a a copy. Use `select()` to add label matchers.
     */
    get matchLabels() {
        var _c;
        const labels = {};
        for (const selector of this._selectors) {
            for (const [key, value] of Object.entries((_c = selector.matchLabels) !== null && _c !== void 0 ? _c : {})) {
                labels[key] = value;
            }
        }
        return labels;
    }
    /**
     * The expression matchers this workload will use in order to select pods.
     *
     * Returns a a copy. Use `select()` to add expression matchers.
     */
    get matchExpressions() {
        var _c;
        const expressions = [];
        for (const selector of this._selectors) {
            for (const expression of (_c = selector.matchExpressions) !== null && _c !== void 0 ? _c : []) {
                expressions.push(expression);
            }
        }
        return expressions;
    }
    /**
     * @internal
     */
    _toLabelSelector() {
        return {
            matchExpressions: utils_1.undefinedIfEmpty(this.matchExpressions),
            matchLabels: utils_1.undefinedIfEmpty(this.matchLabels),
        };
    }
    /**
     * @internal
     */
    _toPodSpec() {
        const scheduling = this.scheduling._toKube();
        return {
            ...super._toPodSpec(),
            affinity: scheduling.affinity,
            nodeName: scheduling.nodeName,
            tolerations: scheduling.tolerations,
        };
    }
}
exports.Workload = Workload;
_a = JSII_RTTI_SYMBOL_1;
Workload[_a] = { fqn: "cdk8s-plus-22.Workload", version: "2.0.0-beta.15" };
/**
 * Controls the pod scheduling strategy of this workload.
 * It offers some additional API's on top of the core pod scheduling.
 */
class WorkloadScheduling extends pod.PodScheduling {
    /**
     * Spread the pods in this workload by the topology key.
     * A spread is a separation of the pod from itself and is used to
     * balance out pod replicas across a given topology.
     */
    spread(options = {}) {
        var _c;
        this.separate(this.instance, { weight: options.weight, topology: (_c = options.topology) !== null && _c !== void 0 ? _c : pod.Topology.HOSTNAME });
    }
}
exports.WorkloadScheduling = WorkloadScheduling;
_b = JSII_RTTI_SYMBOL_1;
WorkloadScheduling[_b] = { fqn: "cdk8s-plus-22.WorkloadScheduling", version: "2.0.0-beta.15" };
//# sourceMappingURL=data:application/json;base64,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