"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Namespaces = exports.Namespace = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const base = require("./base");
const k8s = require("./imports/k8s");
const pod = require("./pod");
/**
 * In Kubernetes, namespaces provides a mechanism for isolating groups of resources within a single cluster.
 * Names of resources need to be unique within a namespace, but not across namespaces.
 * Namespace-based scoping is applicable only for namespaced objects (e.g. Deployments, Services, etc) and
 * not for cluster-wide objects (e.g. StorageClass, Nodes, PersistentVolumes, etc).
 */
class Namespace extends base.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.resourceType = 'namespaces';
        this.apiObject = new k8s.KubeNamespace(this, 'Resource', {
            metadata: props.metadata,
            spec: cdk8s_1.Lazy.any({ produce: () => this._toKube() }),
        });
    }
    /**
     * @see INamespaceSelector.toNamespaceSelectorConfig()
     */
    toNamespaceSelectorConfig() {
        return { names: [this.name] };
    }
    /**
     * @internal
     */
    _toKube() {
        return {};
    }
}
exports.Namespace = Namespace;
_a = JSII_RTTI_SYMBOL_1;
Namespace[_a] = { fqn: "cdk8s-plus-22.Namespace", version: "2.0.0-beta.15" };
/**
 * @see https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/#automatic-labelling
 */
Namespace.NAME_LABEL = 'kubernetes.io/metadata.name';
/**
 * Represents a group of namespaces.
 */
class Namespaces {
    constructor(expressions, names, labels) {
        this.expressions = expressions;
        this.names = names;
        this.labels = labels;
    }
    /**
     * Select specific namespaces.
     */
    static select(options) {
        return new Namespaces(options.expressions, options.names, options.labels);
    }
    /**
     * Select all namespaces.
     */
    static all() {
        return Namespaces.select({ expressions: [], labels: {} });
    }
    /**
     * @see INamespaceSelector.toNamespaceSelectorConfig()
     */
    toNamespaceSelectorConfig() {
        return {
            labelSelector: pod.LabelSelector.of({ expressions: this.expressions, labels: this.labels }),
            names: this.names,
        };
    }
}
exports.Namespaces = Namespaces;
_b = JSII_RTTI_SYMBOL_1;
Namespaces[_b] = { fqn: "cdk8s-plus-22.Namespaces", version: "2.0.0-beta.15" };
//# sourceMappingURL=data:application/json;base64,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