import argparse
from .generator import package_protos

DESC = 'Create a Python package from autogenerated API files'

USAGE = """Generate the package and output to the default output directory.

python -m ansys.tools.protos_generator ansys/api/sample/v1/

Generate the package and output to a non-default directory on Windows:

python -m ansys.tools.protos_generator ansys/api/sample/v1/ C:/temp

On Linux:

python -m ansys.tools.protos_generator ansys/api/sample/v1/ /tmp

"""

def main():
    """Package auto-generated grpc python client protocols

    Package name will match the grpc package name.

    For example, in a protofile named

    ./ansys/api/sample-examples.v1;

    Expects there to be a VERSION file in the directory containing the
    protocols.

    """
    parser = argparse.ArgumentParser(description=DESC, usage=USAGE)
    parser.add_argument('protosfiles_path',
                        type=str,
                        help='Path containing gRPC protobuf files')

    parser.add_argument('-outdir', type=str, default=None,
                        help='Output directory of the package')

    args = parser.parse_args()
    out = package_protos(args.protosfiles_path, args.outdir)


if __name__ == '__main__':
    main()
