"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkloadScheduling = exports.Workload = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const pod = require("./pod");
const utils_1 = require("./utils");
/**
 * A workload is an application running on Kubernetes. Whether your workload is a single
 * component or several that work together, on Kubernetes you run it inside a set of pods.
 * In Kubernetes, a Pod represents a set of running containers on your cluster.
 */
class Workload extends pod.AbstractPod {
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this._matchLabels = {};
        this._matchExpressions = [];
        this.podMetadata = new cdk8s_1.ApiObjectMetadataDefinition(props.podMetadata);
        this.scheduling = new WorkloadScheduling(this);
        this.connections = new pod.PodConnections(this);
        this.spread = props.spread ?? false;
        const matcher = cdk8s_1.Names.toLabelValue(this);
        this.podMetadata.addLabel(pod.Pod.ADDRESS_LABEL, matcher);
        if (props.select ?? true) {
            this.select(pod.LabelSelector.of({ labels: { [pod.Pod.ADDRESS_LABEL]: matcher } }));
        }
    }
    /**
     * Configure selectors for this workload.
     */
    select(...selectors) {
        for (const selector of selectors) {
            const kube = selector._toKube();
            this._matchExpressions.push(...kube.matchExpressions ?? []);
            for (const [key, value] of Object.entries(kube.matchLabels ?? {})) {
                this._matchLabels[key] = value;
            }
        }
    }
    /**
     * The label matchers this workload will use in order to select pods.
     *
     * Returns a a copy. Use `select()` to add label matchers.
     */
    get matchLabels() {
        return { ...this._matchLabels };
    }
    /**
     * The expression matchers this workload will use in order to select pods.
     *
     * Returns a a copy. Use `select()` to add expression matchers.
     */
    get matchExpressions() {
        return [...this._matchExpressions];
    }
    /**
     * @internal
     */
    _toLabelSelector() {
        return {
            matchExpressions: utils_1.undefinedIfEmpty(this._matchExpressions),
            matchLabels: utils_1.undefinedIfEmpty(this._matchLabels),
        };
    }
    /**
     * @internal
     */
    _toPodSpec() {
        if (this.spread) {
            {
                this.scheduling.spread({
                    topology: pod.Topology.HOSTNAME,
                });
                this.scheduling.spread({
                    topology: pod.Topology.ZONE,
                });
            }
        }
        ;
        const scheduling = this.scheduling._toKube();
        return {
            ...super._toPodSpec(),
            affinity: scheduling.affinity,
            nodeName: scheduling.nodeName,
            tolerations: scheduling.tolerations,
        };
    }
}
exports.Workload = Workload;
_a = JSII_RTTI_SYMBOL_1;
Workload[_a] = { fqn: "cdk8s-plus-22.Workload", version: "2.0.0-rc.145" };
/**
 * Controls the pod scheduling strategy of this workload.
 * It offers some additional API's on top of the core pod scheduling.
 */
class WorkloadScheduling extends pod.PodScheduling {
    /**
     * Spread the pods in this workload by the topology key.
     * A spread is a separation of the pod from itself and is used to
     * balance out pod replicas across a given topology.
     */
    spread(options = {}) {
        this.separate(this.instance, { weight: options.weight, topology: options.topology ?? pod.Topology.HOSTNAME });
    }
}
exports.WorkloadScheduling = WorkloadScheduling;
_b = JSII_RTTI_SYMBOL_1;
WorkloadScheduling[_b] = { fqn: "cdk8s-plus-22.WorkloadScheduling", version: "2.0.0-rc.145" };
//# sourceMappingURL=data:application/json;base64,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