"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticsearchAccessPolicy = void 0;
const iam = require("@aws-cdk/aws-iam");
const cr = require("@aws-cdk/custom-resources");
/**
 * Creates LogGroup resource policies.
 */
class ElasticsearchAccessPolicy extends cr.AwsCustomResource {
    constructor(scope, id, props) {
        const policyDocument = new iam.PolicyDocument({
            statements: props.accessPolicies,
        });
        super(scope, id, {
            resourceType: 'Custom::ElasticsearchAccessPolicy',
            onUpdate: {
                action: 'updateElasticsearchDomainConfig',
                service: 'ES',
                parameters: {
                    DomainName: props.domainName,
                    AccessPolicies: JSON.stringify(policyDocument.toJSON()),
                },
                // this is needed to limit the response body, otherwise it exceeds the CFN 4k limit
                outputPaths: ['DomainConfig.ElasticsearchClusterConfig.AccessPolicies'],
                physicalResourceId: cr.PhysicalResourceId.of(`${props.domainName}AccessPolicy`),
            },
            policy: cr.AwsCustomResourcePolicy.fromSdkCalls({ resources: [props.domainArn] }),
        });
    }
}
exports.ElasticsearchAccessPolicy = ElasticsearchAccessPolicy;
//# sourceMappingURL=data:application/json;base64,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