# finbourne-identity-sdk
FINBOURNE Technology

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.1170
- Package version: 0.0.1170
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.finbourne.com](https://www.finbourne.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import finbourne_identity 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import finbourne_identity
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import finbourne_identity
from finbourne_identity.rest import ApiException
from pprint import pprint

configuration = finbourne_identity.Configuration()
# Configure OAuth2 access token for authorization: oauth2
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# Defining host is optional and default to https://fbn-ci.lusid.com/identity
configuration.host = "https://fbn-ci.lusid.com/identity"
# Create an instance of the API class
api_instance = finbourne_identity.ApplicationMetadataApi(finbourne_identity.ApiClient(configuration))

try:
    # [EARLY ACCESS] Check Registration availability
    api_response = api_instance.get_registration_availability()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ApplicationMetadataApi->get_registration_availability: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://fbn-ci.lusid.com/identity*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApplicationMetadataApi* | [**get_registration_availability**](docs/ApplicationMetadataApi.md#get_registration_availability) | **GET** /api/metadata/eap | [EARLY ACCESS] Check Registration availability
*ApplicationMetadataApi* | [**list_access_controlled_resources**](docs/ApplicationMetadataApi.md#list_access_controlled_resources) | **GET** /api/metadata/access/resources | [EARLY ACCESS] Get resources available for access control
*ApplicationsApi* | [**create_application**](docs/ApplicationsApi.md#create_application) | **POST** /api/applications | [EARLY ACCESS] Create Application
*ApplicationsApi* | [**delete_application**](docs/ApplicationsApi.md#delete_application) | **DELETE** /api/applications/{id} | [EARLY ACCESS] Delete Application
*ApplicationsApi* | [**get_application**](docs/ApplicationsApi.md#get_application) | **GET** /api/applications/{id} | [EARLY ACCESS] Get Application
*ApplicationsApi* | [**list_applications**](docs/ApplicationsApi.md#list_applications) | **GET** /api/applications | [EARLY ACCESS] List Applications
*ApplicationsApi* | [**rotate_application_secrets**](docs/ApplicationsApi.md#rotate_application_secrets) | **POST** /api/applications/{id}/lifecycle/$newsecret | [EXPERIMENTAL] Rotate Application Secrets
*AuthenticationApi* | [**get_authentication_information**](docs/AuthenticationApi.md#get_authentication_information) | **GET** /api/authentication/information | Gets AuthenticationInformation
*AuthenticationApi* | [**get_support_access_history**](docs/AuthenticationApi.md#get_support_access_history) | **GET** /api/authentication/support | [EXPERIMENTAL] Get the history of all support access granted and any information pertaining to their termination
*AuthenticationApi* | [**grant_support_access**](docs/AuthenticationApi.md#grant_support_access) | **POST** /api/authentication/support | [EXPERIMENTAL] Grants FINBOURNE support access to your account
*AuthenticationApi* | [**invalidate_support_access**](docs/AuthenticationApi.md#invalidate_support_access) | **DELETE** /api/authentication/support | [EXPERIMENTAL] Revoke any FINBOURNE support access to your account
*DomainsApi* | [**create_domain**](docs/DomainsApi.md#create_domain) | **POST** /api/domains | Create Domain
*DomainsApi* | [**get_agreement**](docs/DomainsApi.md#get_agreement) | **HEAD** /api/domains/me/agreements/{agreement} | Get Agreement
*DomainsApi* | [**get_my_domain**](docs/DomainsApi.md#get_my_domain) | **GET** /api/domains/me | Get current Domain
*DomainsApi* | [**list_agreements**](docs/DomainsApi.md#list_agreements) | **GET** /api/domains/me/agreements | List Agreements
*DomainsApi* | [**sign_agreement**](docs/DomainsApi.md#sign_agreement) | **PUT** /api/domains/me/agreements/{agreement} | Sign Agreement
*PersonalAuthenticationTokensApi* | [**create_api_key**](docs/PersonalAuthenticationTokensApi.md#create_api_key) | **POST** /api/keys | [EXPERIMENTAL] Create a Personal Access Token
*PersonalAuthenticationTokensApi* | [**delete_api_key**](docs/PersonalAuthenticationTokensApi.md#delete_api_key) | **DELETE** /api/keys/{id} | [EXPERIMENTAL] Invalidate a Personal Access Token
*PersonalAuthenticationTokensApi* | [**list_own_api_keys**](docs/PersonalAuthenticationTokensApi.md#list_own_api_keys) | **GET** /api/keys | [EXPERIMENTAL] Gets the meta data for all of the user&#39;s existing Personal Access Tokens.
*RolesApi* | [**add_user_to_role**](docs/RolesApi.md#add_user_to_role) | **PUT** /api/roles/{id}/users/{userId} | [EARLY ACCESS] Add User to Role
*RolesApi* | [**create_role**](docs/RolesApi.md#create_role) | **POST** /api/roles | [EARLY ACCESS] Create Role
*RolesApi* | [**delete_role**](docs/RolesApi.md#delete_role) | **DELETE** /api/roles/{id} | [EARLY ACCESS] Delete Role
*RolesApi* | [**get_role**](docs/RolesApi.md#get_role) | **GET** /api/roles/{id} | [EARLY ACCESS] Get Role
*RolesApi* | [**list_roles**](docs/RolesApi.md#list_roles) | **GET** /api/roles | [EARLY ACCESS] List Roles
*RolesApi* | [**list_users_in_role**](docs/RolesApi.md#list_users_in_role) | **GET** /api/roles/{id}/users | [EARLY ACCESS] Get the users in the specified role.
*RolesApi* | [**remove_user_from_role**](docs/RolesApi.md#remove_user_from_role) | **DELETE** /api/roles/{id}/users/{userId} | [EARLY ACCESS] Remove User from Role
*RolesApi* | [**update_role**](docs/RolesApi.md#update_role) | **PUT** /api/roles/{id} | [EARLY ACCESS] Update Role
*TokensApi* | [**invalidate_token**](docs/TokensApi.md#invalidate_token) | **DELETE** /api/tokens | [EXPERIMENTAL] Invalidate current JWT token (sign out)
*UsersApi* | [**create_user**](docs/UsersApi.md#create_user) | **POST** /api/users | [EARLY ACCESS] Create User
*UsersApi* | [**delete_user**](docs/UsersApi.md#delete_user) | **DELETE** /api/users/{id} | [EARLY ACCESS] Delete User
*UsersApi* | [**expire_password**](docs/UsersApi.md#expire_password) | **POST** /api/users/{id}/lifecycle/$expirepassword | [EXPERIMENTAL] Reset the user&#39;s password to a temporary one
*UsersApi* | [**find_users_by_id**](docs/UsersApi.md#find_users_by_id) | **GET** /api/directory | [EARLY ACCESS] Find users by id endpoint
*UsersApi* | [**get_user**](docs/UsersApi.md#get_user) | **GET** /api/users/{id} | [EARLY ACCESS] Get User
*UsersApi* | [**list_users**](docs/UsersApi.md#list_users) | **GET** /api/users | [EARLY ACCESS] List Users
*UsersApi* | [**reset_factors**](docs/UsersApi.md#reset_factors) | **POST** /api/users/{id}/lifecycle/$resetfactors | [EXPERIMENTAL] Reset MFA factors
*UsersApi* | [**reset_password**](docs/UsersApi.md#reset_password) | **POST** /api/users/{id}/lifecycle/$resetpassword | [EXPERIMENTAL] Reset Password
*UsersApi* | [**send_activation_email**](docs/UsersApi.md#send_activation_email) | **POST** /api/users/{id}/lifecycle/$activate | [EXPERIMENTAL] Sends an activation email to the User
*UsersApi* | [**unlock_user**](docs/UsersApi.md#unlock_user) | **POST** /api/users/{id}/lifecycle/$unlock | [EXPERIMENTAL] Unlock User
*UsersApi* | [**update_user**](docs/UsersApi.md#update_user) | **PUT** /api/users/{id} | [EARLY ACCESS] Update User


## Documentation For Models

 - [AccessControlledAction](docs/AccessControlledAction.md)
 - [AccessControlledResource](docs/AccessControlledResource.md)
 - [ActionId](docs/ActionId.md)
 - [AgreementResponse](docs/AgreementResponse.md)
 - [ApiKey](docs/ApiKey.md)
 - [AuthenticationInformation](docs/AuthenticationInformation.md)
 - [CreateApiKey](docs/CreateApiKey.md)
 - [CreateApplicationRequest](docs/CreateApplicationRequest.md)
 - [CreateDomainRequest](docs/CreateDomainRequest.md)
 - [CreateRoleRequest](docs/CreateRoleRequest.md)
 - [CreateUserRequest](docs/CreateUserRequest.md)
 - [CreatedApiKey](docs/CreatedApiKey.md)
 - [DomainId](docs/DomainId.md)
 - [DomainResponse](docs/DomainResponse.md)
 - [ErrorDetail](docs/ErrorDetail.md)
 - [IdSelectorDefinition](docs/IdSelectorDefinition.md)
 - [IdentifierPartSchema](docs/IdentifierPartSchema.md)
 - [Link](docs/Link.md)
 - [ListUsersResponse](docs/ListUsersResponse.md)
 - [LusidProblemDetails](docs/LusidProblemDetails.md)
 - [LusidValidationProblemDetails](docs/LusidValidationProblemDetails.md)
 - [OAuthApplication](docs/OAuthApplication.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [ResetPasswordUrl](docs/ResetPasswordUrl.md)
 - [ResourceListOfAccessControlledResource](docs/ResourceListOfAccessControlledResource.md)
 - [Role](docs/Role.md)
 - [RoleId](docs/RoleId.md)
 - [RoleResponse](docs/RoleResponse.md)
 - [SupportAccessExpiry](docs/SupportAccessExpiry.md)
 - [SupportAccessRequest](docs/SupportAccessRequest.md)
 - [SupportAccessResponse](docs/SupportAccessResponse.md)
 - [TemporaryPassword](docs/TemporaryPassword.md)
 - [UpdateRoleRequest](docs/UpdateRoleRequest.md)
 - [UpdateUserRequest](docs/UpdateUserRequest.md)
 - [UserId](docs/UserId.md)
 - [UserResponse](docs/UserResponse.md)
 - [UserSummary](docs/UserSummary.md)


## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://lusid.okta.com/oauth2/default/v1/authorize
- **Scopes**: N/A


## Author

info@finbourne.com


