# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['TempUrl']


class TempUrl(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 regenerate: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 split: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Use this resource to generate an OpenStack Object Storage temporary URL.

        The temporary URL will be valid for as long as TTL is set to (in seconds).
        Once the URL has expired, it will no longer be valid, but the resource
        will remain in place. If you wish to automatically regenerate a URL, set
        the `regenerate` argument to `true`. This will create a new resource with
        a new ID and URL.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        container1 = openstack.objectstorage.Container("container1", metadata={
            "Temp-URL-Key": "testkey",
        })
        object1 = openstack.objectstorage.ContainerObject("object1",
            container_name=container1.name,
            content="Hello, world!")
        obj_tempurl = openstack.objectstorage.TempUrl("objTempurl",
            container=container1.name,
            method="post",
            object=object1.name,
            ttl=20)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] container: The container name the object belongs to.
        :param pulumi.Input[str] method: The method allowed when accessing this URL.
               Valid values are `GET`, and `POST`. Default is `GET`.
        :param pulumi.Input[str] object: The object name the tempurl is for.
        :param pulumi.Input[bool] regenerate: Whether to automatically regenerate the URL when
               it has expired. If set to true, this will create a new resource with a new
               ID and new URL. Defaults to false.
        :param pulumi.Input[str] region: The region the tempurl is located in.
        :param pulumi.Input[int] ttl: The TTL, in seconds, for the URL. For how long it should
               be valid.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if container is None:
                raise TypeError("Missing required property 'container'")
            __props__['container'] = container
            __props__['method'] = method
            if object is None:
                raise TypeError("Missing required property 'object'")
            __props__['object'] = object
            __props__['regenerate'] = regenerate
            __props__['region'] = region
            __props__['split'] = split
            if ttl is None:
                raise TypeError("Missing required property 'ttl'")
            __props__['ttl'] = ttl
            __props__['url'] = None
        super(TempUrl, __self__).__init__(
            'openstack:objectstorage/tempUrl:TempUrl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            container: Optional[pulumi.Input[str]] = None,
            method: Optional[pulumi.Input[str]] = None,
            object: Optional[pulumi.Input[str]] = None,
            regenerate: Optional[pulumi.Input[bool]] = None,
            region: Optional[pulumi.Input[str]] = None,
            split: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[int]] = None,
            url: Optional[pulumi.Input[str]] = None) -> 'TempUrl':
        """
        Get an existing TempUrl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] container: The container name the object belongs to.
        :param pulumi.Input[str] method: The method allowed when accessing this URL.
               Valid values are `GET`, and `POST`. Default is `GET`.
        :param pulumi.Input[str] object: The object name the tempurl is for.
        :param pulumi.Input[bool] regenerate: Whether to automatically regenerate the URL when
               it has expired. If set to true, this will create a new resource with a new
               ID and new URL. Defaults to false.
        :param pulumi.Input[str] region: The region the tempurl is located in.
        :param pulumi.Input[int] ttl: The TTL, in seconds, for the URL. For how long it should
               be valid.
        :param pulumi.Input[str] url: The URL
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["container"] = container
        __props__["method"] = method
        __props__["object"] = object
        __props__["regenerate"] = regenerate
        __props__["region"] = region
        __props__["split"] = split
        __props__["ttl"] = ttl
        __props__["url"] = url
        return TempUrl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def container(self) -> pulumi.Output[str]:
        """
        The container name the object belongs to.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def method(self) -> pulumi.Output[Optional[str]]:
        """
        The method allowed when accessing this URL.
        Valid values are `GET`, and `POST`. Default is `GET`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def object(self) -> pulumi.Output[str]:
        """
        The object name the tempurl is for.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def regenerate(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to automatically regenerate the URL when
        it has expired. If set to true, this will create a new resource with a new
        ID and new URL. Defaults to false.
        """
        return pulumi.get(self, "regenerate")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region the tempurl is located in.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def split(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "split")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[int]:
        """
        The TTL, in seconds, for the URL. For how long it should
        be valid.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The URL
        """
        return pulumi.get(self, "url")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

