# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['QuotaV2']


class QuotaV2(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 floatingip: Optional[pulumi.Input[int]] = None,
                 network: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 rbac_policy: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router: Optional[pulumi.Input[int]] = None,
                 security_group: Optional[pulumi.Input[int]] = None,
                 security_group_rule: Optional[pulumi.Input[int]] = None,
                 subnet: Optional[pulumi.Input[int]] = None,
                 subnetpool: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a V2 networking quota resource within OpenStack.

        > **Note:** This usually requires admin privileges.

        > **Note:** This resource has a no-op deletion so no actual actions will be done against the OpenStack API
            in case of delete call.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] floatingip: Quota value for floating IPs. Changing this updates the
               existing quota.
        :param pulumi.Input[int] network: Quota value for networks. Changing this updates the
               existing quota.
        :param pulumi.Input[int] port: Quota value for ports. Changing this updates the
               existing quota.
        :param pulumi.Input[str] project_id: ID of the project to manage quota. Changing this
               creates new quota.
        :param pulumi.Input[int] rbac_policy: Quota value for RBAC policies.
               Changing this updates the existing quota.
        :param pulumi.Input[str] region: The region in which to create the quota. If
               omitted, the `region` argument of the provider is used. Changing this
               creates new quota.
        :param pulumi.Input[int] router: Quota value for routers. Changing this updates the
               existing quota.
        :param pulumi.Input[int] security_group: Quota value for security groups. Changing
               this updates the existing quota.
        :param pulumi.Input[int] security_group_rule: Quota value for security group rules.
               Changing this updates the existing quota.
        :param pulumi.Input[int] subnet: Quota value for subnets. Changing
               this updates the existing quota.
        :param pulumi.Input[int] subnetpool: Quota value for subnetpools.
               Changing this updates the existing quota.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['floatingip'] = floatingip
            __props__['network'] = network
            __props__['port'] = port
            if project_id is None:
                raise TypeError("Missing required property 'project_id'")
            __props__['project_id'] = project_id
            __props__['rbac_policy'] = rbac_policy
            __props__['region'] = region
            __props__['router'] = router
            __props__['security_group'] = security_group
            __props__['security_group_rule'] = security_group_rule
            __props__['subnet'] = subnet
            __props__['subnetpool'] = subnetpool
        super(QuotaV2, __self__).__init__(
            'openstack:networking/quotaV2:QuotaV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            floatingip: Optional[pulumi.Input[int]] = None,
            network: Optional[pulumi.Input[int]] = None,
            port: Optional[pulumi.Input[int]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            rbac_policy: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            router: Optional[pulumi.Input[int]] = None,
            security_group: Optional[pulumi.Input[int]] = None,
            security_group_rule: Optional[pulumi.Input[int]] = None,
            subnet: Optional[pulumi.Input[int]] = None,
            subnetpool: Optional[pulumi.Input[int]] = None) -> 'QuotaV2':
        """
        Get an existing QuotaV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] floatingip: Quota value for floating IPs. Changing this updates the
               existing quota.
        :param pulumi.Input[int] network: Quota value for networks. Changing this updates the
               existing quota.
        :param pulumi.Input[int] port: Quota value for ports. Changing this updates the
               existing quota.
        :param pulumi.Input[str] project_id: ID of the project to manage quota. Changing this
               creates new quota.
        :param pulumi.Input[int] rbac_policy: Quota value for RBAC policies.
               Changing this updates the existing quota.
        :param pulumi.Input[str] region: The region in which to create the quota. If
               omitted, the `region` argument of the provider is used. Changing this
               creates new quota.
        :param pulumi.Input[int] router: Quota value for routers. Changing this updates the
               existing quota.
        :param pulumi.Input[int] security_group: Quota value for security groups. Changing
               this updates the existing quota.
        :param pulumi.Input[int] security_group_rule: Quota value for security group rules.
               Changing this updates the existing quota.
        :param pulumi.Input[int] subnet: Quota value for subnets. Changing
               this updates the existing quota.
        :param pulumi.Input[int] subnetpool: Quota value for subnetpools.
               Changing this updates the existing quota.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["floatingip"] = floatingip
        __props__["network"] = network
        __props__["port"] = port
        __props__["project_id"] = project_id
        __props__["rbac_policy"] = rbac_policy
        __props__["region"] = region
        __props__["router"] = router
        __props__["security_group"] = security_group
        __props__["security_group_rule"] = security_group_rule
        __props__["subnet"] = subnet
        __props__["subnetpool"] = subnetpool
        return QuotaV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def floatingip(self) -> pulumi.Output[int]:
        """
        Quota value for floating IPs. Changing this updates the
        existing quota.
        """
        return pulumi.get(self, "floatingip")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[int]:
        """
        Quota value for networks. Changing this updates the
        existing quota.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Quota value for ports. Changing this updates the
        existing quota.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        ID of the project to manage quota. Changing this
        creates new quota.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="rbacPolicy")
    def rbac_policy(self) -> pulumi.Output[int]:
        """
        Quota value for RBAC policies.
        Changing this updates the existing quota.
        """
        return pulumi.get(self, "rbac_policy")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the quota. If
        omitted, the `region` argument of the provider is used. Changing this
        creates new quota.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def router(self) -> pulumi.Output[int]:
        """
        Quota value for routers. Changing this updates the
        existing quota.
        """
        return pulumi.get(self, "router")

    @property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> pulumi.Output[int]:
        """
        Quota value for security groups. Changing
        this updates the existing quota.
        """
        return pulumi.get(self, "security_group")

    @property
    @pulumi.getter(name="securityGroupRule")
    def security_group_rule(self) -> pulumi.Output[int]:
        """
        Quota value for security group rules.
        Changing this updates the existing quota.
        """
        return pulumi.get(self, "security_group_rule")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[int]:
        """
        Quota value for subnets. Changing
        this updates the existing quota.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def subnetpool(self) -> pulumi.Output[int]:
        """
        Quota value for subnetpools.
        Changing this updates the existing quota.
        """
        return pulumi.get(self, "subnetpool")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

