# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Port']


class Port(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 allowed_address_pairs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PortAllowedAddressPairArgs']]]]] = None,
                 binding: Optional[pulumi.Input[pulumi.InputType['PortBindingArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 device_owner: Optional[pulumi.Input[str]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 extra_dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PortExtraDhcpOptionArgs']]]]] = None,
                 fixed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PortFixedIpArgs']]]]] = None,
                 mac_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 no_fixed_ip: Optional[pulumi.Input[bool]] = None,
                 no_security_groups: Optional[pulumi.Input[bool]] = None,
                 port_security_enabled: Optional[pulumi.Input[bool]] = None,
                 qos_policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a V2 port resource within OpenStack.

        ## Example Usage
        ### Simple port

        ```python
        import pulumi
        import pulumi_openstack as openstack

        network1 = openstack.networking.Network("network1", admin_state_up=True)
        port1 = openstack.networking.Port("port1",
            admin_state_up=True,
            network_id=network1.id)
        ```
        ### Port with physical binding information

        ```python
        import pulumi
        import pulumi_openstack as openstack

        network1 = openstack.networking.Network("network1", admin_state_up=True)
        port1 = openstack.networking.Port("port1",
            admin_state_up=True,
            binding=openstack.networking.PortBindingArgs(
                host_id="b080b9cf-46e0-4ce8-ad47-0fd4accc872b",
                profile=\"\"\"{
          "local_link_information": [
            {
              "switch_info": "info1",
              "port_id": "Ethernet3/4",
              "switch_id": "12:34:56:78:9A:BC"
            },
            {
              "switch_info": "info2",
              "port_id": "Ethernet3/4",
              "switch_id": "12:34:56:78:9A:BD"
            }
          ],
          "vlan_type": "allowed"
        }

        \"\"\",
                vnic_type="baremetal",
            ),
            device_id="cdf70fcf-c161-4f24-9c70-96b3f5a54b71",
            device_owner="baremetal:none",
            network_id=network1.id)
        ```
        ## Notes

        ### Ports and Instances

        There are some notes to consider when connecting Instances to networks using
        Ports. Please see the `compute.Instance` documentation for further
        documentation.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: Administrative up/down status for the port
               (must be `true` or `false` if provided). Changing this updates the
               `admin_state_up` of an existing port.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PortAllowedAddressPairArgs']]]] allowed_address_pairs: An IP/MAC Address pair of additional IP
               addresses that can be active on this port. The structure is described
               below.
        :param pulumi.Input[pulumi.InputType['PortBindingArgs']] binding: The port binding allows to specify binding information
               for the port. The structure is described below.
        :param pulumi.Input[str] description: Human-readable description of the port. Changing
               this updates the `description` of an existing port.
        :param pulumi.Input[str] device_id: The ID of the device attached to the port. Changing this
               creates a new port.
        :param pulumi.Input[str] device_owner: The device owner of the port. Changing this creates
               a new port.
        :param pulumi.Input[str] dns_name: The port DNS name. Available, when Neutron DNS extension
               is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PortExtraDhcpOptionArgs']]]] extra_dhcp_options: An extra DHCP option that needs to be configured
               on the port. The structure is described below. Can be specified multiple
               times.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PortFixedIpArgs']]]] fixed_ips: An array of desired IPs for
               this port. The structure is described below.
        :param pulumi.Input[str] mac_address: The additional MAC address.
        :param pulumi.Input[str] name: Name of the DHCP option.
        :param pulumi.Input[str] network_id: The ID of the network to attach the port to. Changing
               this creates a new port.
        :param pulumi.Input[bool] no_fixed_ip: Create a port with no fixed
               IP address. This will also remove any fixed IPs previously set on a port. `true`
               is the only valid value for this argument.
        :param pulumi.Input[bool] no_security_groups: If set to
               `true`, then no security groups are applied to the port. If set to `false` and
               no `security_group_ids` are specified, then the port will yield to the default
               behavior of the Networking service, which is to usually apply the "default"
               security group.
        :param pulumi.Input[bool] port_security_enabled: Whether to explicitly enable or disable
               port security on the port. Port Security is usually enabled by default, so
               omitting argument will usually result in a value of `true`. Setting this
               explicitly to `false` will disable port security. In order to disable port
               security, the port must not have any security groups. Valid values are `true`
               and `false`.
        :param pulumi.Input[str] qos_policy_id: Reference to the associated QoS policy.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a port. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list
               of security group IDs to apply to the port. The security groups must be
               specified by ID and not name (as opposed to how they are configured with
               the Compute Instance).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of string tags for the port.
        :param pulumi.Input[str] tenant_id: The owner of the port. Required if admin wants
               to create a port for another tenant. Changing this creates a new port.
        :param pulumi.Input[Mapping[str, Any]] value_specs: Map of additional options.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['admin_state_up'] = admin_state_up
            __props__['allowed_address_pairs'] = allowed_address_pairs
            __props__['binding'] = binding
            __props__['description'] = description
            __props__['device_id'] = device_id
            __props__['device_owner'] = device_owner
            __props__['dns_name'] = dns_name
            __props__['extra_dhcp_options'] = extra_dhcp_options
            __props__['fixed_ips'] = fixed_ips
            __props__['mac_address'] = mac_address
            __props__['name'] = name
            if network_id is None:
                raise TypeError("Missing required property 'network_id'")
            __props__['network_id'] = network_id
            __props__['no_fixed_ip'] = no_fixed_ip
            __props__['no_security_groups'] = no_security_groups
            __props__['port_security_enabled'] = port_security_enabled
            __props__['qos_policy_id'] = qos_policy_id
            __props__['region'] = region
            __props__['security_group_ids'] = security_group_ids
            __props__['tags'] = tags
            __props__['tenant_id'] = tenant_id
            __props__['value_specs'] = value_specs
            __props__['all_fixed_ips'] = None
            __props__['all_security_group_ids'] = None
            __props__['all_tags'] = None
            __props__['dns_assignments'] = None
        super(Port, __self__).__init__(
            'openstack:networking/port:Port',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_state_up: Optional[pulumi.Input[bool]] = None,
            all_fixed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            all_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            all_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_address_pairs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PortAllowedAddressPairArgs']]]]] = None,
            binding: Optional[pulumi.Input[pulumi.InputType['PortBindingArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_id: Optional[pulumi.Input[str]] = None,
            device_owner: Optional[pulumi.Input[str]] = None,
            dns_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]]] = None,
            dns_name: Optional[pulumi.Input[str]] = None,
            extra_dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PortExtraDhcpOptionArgs']]]]] = None,
            fixed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PortFixedIpArgs']]]]] = None,
            mac_address: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            no_fixed_ip: Optional[pulumi.Input[bool]] = None,
            no_security_groups: Optional[pulumi.Input[bool]] = None,
            port_security_enabled: Optional[pulumi.Input[bool]] = None,
            qos_policy_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            value_specs: Optional[pulumi.Input[Mapping[str, Any]]] = None) -> 'Port':
        """
        Get an existing Port resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: Administrative up/down status for the port
               (must be `true` or `false` if provided). Changing this updates the
               `admin_state_up` of an existing port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] all_fixed_ips: The collection of Fixed IP addresses on the port in the
               order returned by the Network v2 API.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] all_security_group_ids: The collection of Security Group IDs on the port
               which have been explicitly and implicitly added.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] all_tags: The collection of tags assigned on the port, which have been
               explicitly and implicitly added.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PortAllowedAddressPairArgs']]]] allowed_address_pairs: An IP/MAC Address pair of additional IP
               addresses that can be active on this port. The structure is described
               below.
        :param pulumi.Input[pulumi.InputType['PortBindingArgs']] binding: The port binding allows to specify binding information
               for the port. The structure is described below.
        :param pulumi.Input[str] description: Human-readable description of the port. Changing
               this updates the `description` of an existing port.
        :param pulumi.Input[str] device_id: The ID of the device attached to the port. Changing this
               creates a new port.
        :param pulumi.Input[str] device_owner: The device owner of the port. Changing this creates
               a new port.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, Any]]]] dns_assignments: The list of maps representing port DNS assignments.
        :param pulumi.Input[str] dns_name: The port DNS name. Available, when Neutron DNS extension
               is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PortExtraDhcpOptionArgs']]]] extra_dhcp_options: An extra DHCP option that needs to be configured
               on the port. The structure is described below. Can be specified multiple
               times.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PortFixedIpArgs']]]] fixed_ips: An array of desired IPs for
               this port. The structure is described below.
        :param pulumi.Input[str] mac_address: The additional MAC address.
        :param pulumi.Input[str] name: Name of the DHCP option.
        :param pulumi.Input[str] network_id: The ID of the network to attach the port to. Changing
               this creates a new port.
        :param pulumi.Input[bool] no_fixed_ip: Create a port with no fixed
               IP address. This will also remove any fixed IPs previously set on a port. `true`
               is the only valid value for this argument.
        :param pulumi.Input[bool] no_security_groups: If set to
               `true`, then no security groups are applied to the port. If set to `false` and
               no `security_group_ids` are specified, then the port will yield to the default
               behavior of the Networking service, which is to usually apply the "default"
               security group.
        :param pulumi.Input[bool] port_security_enabled: Whether to explicitly enable or disable
               port security on the port. Port Security is usually enabled by default, so
               omitting argument will usually result in a value of `true`. Setting this
               explicitly to `false` will disable port security. In order to disable port
               security, the port must not have any security groups. Valid values are `true`
               and `false`.
        :param pulumi.Input[str] qos_policy_id: Reference to the associated QoS policy.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a port. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list
               of security group IDs to apply to the port. The security groups must be
               specified by ID and not name (as opposed to how they are configured with
               the Compute Instance).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of string tags for the port.
        :param pulumi.Input[str] tenant_id: The owner of the port. Required if admin wants
               to create a port for another tenant. Changing this creates a new port.
        :param pulumi.Input[Mapping[str, Any]] value_specs: Map of additional options.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["admin_state_up"] = admin_state_up
        __props__["all_fixed_ips"] = all_fixed_ips
        __props__["all_security_group_ids"] = all_security_group_ids
        __props__["all_tags"] = all_tags
        __props__["allowed_address_pairs"] = allowed_address_pairs
        __props__["binding"] = binding
        __props__["description"] = description
        __props__["device_id"] = device_id
        __props__["device_owner"] = device_owner
        __props__["dns_assignments"] = dns_assignments
        __props__["dns_name"] = dns_name
        __props__["extra_dhcp_options"] = extra_dhcp_options
        __props__["fixed_ips"] = fixed_ips
        __props__["mac_address"] = mac_address
        __props__["name"] = name
        __props__["network_id"] = network_id
        __props__["no_fixed_ip"] = no_fixed_ip
        __props__["no_security_groups"] = no_security_groups
        __props__["port_security_enabled"] = port_security_enabled
        __props__["qos_policy_id"] = qos_policy_id
        __props__["region"] = region
        __props__["security_group_ids"] = security_group_ids
        __props__["tags"] = tags
        __props__["tenant_id"] = tenant_id
        __props__["value_specs"] = value_specs
        return Port(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> pulumi.Output[bool]:
        """
        Administrative up/down status for the port
        (must be `true` or `false` if provided). Changing this updates the
        `admin_state_up` of an existing port.
        """
        return pulumi.get(self, "admin_state_up")

    @property
    @pulumi.getter(name="allFixedIps")
    def all_fixed_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        The collection of Fixed IP addresses on the port in the
        order returned by the Network v2 API.
        """
        return pulumi.get(self, "all_fixed_ips")

    @property
    @pulumi.getter(name="allSecurityGroupIds")
    def all_security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The collection of Security Group IDs on the port
        which have been explicitly and implicitly added.
        """
        return pulumi.get(self, "all_security_group_ids")

    @property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> pulumi.Output[Sequence[str]]:
        """
        The collection of tags assigned on the port, which have been
        explicitly and implicitly added.
        """
        return pulumi.get(self, "all_tags")

    @property
    @pulumi.getter(name="allowedAddressPairs")
    def allowed_address_pairs(self) -> pulumi.Output[Optional[Sequence['outputs.PortAllowedAddressPair']]]:
        """
        An IP/MAC Address pair of additional IP
        addresses that can be active on this port. The structure is described
        below.
        """
        return pulumi.get(self, "allowed_address_pairs")

    @property
    @pulumi.getter
    def binding(self) -> pulumi.Output['outputs.PortBinding']:
        """
        The port binding allows to specify binding information
        for the port. The structure is described below.
        """
        return pulumi.get(self, "binding")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Human-readable description of the port. Changing
        this updates the `description` of an existing port.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> pulumi.Output[str]:
        """
        The ID of the device attached to the port. Changing this
        creates a new port.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="deviceOwner")
    def device_owner(self) -> pulumi.Output[str]:
        """
        The device owner of the port. Changing this creates
        a new port.
        """
        return pulumi.get(self, "device_owner")

    @property
    @pulumi.getter(name="dnsAssignments")
    def dns_assignments(self) -> pulumi.Output[Sequence[Mapping[str, Any]]]:
        """
        The list of maps representing port DNS assignments.
        """
        return pulumi.get(self, "dns_assignments")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[str]:
        """
        The port DNS name. Available, when Neutron DNS extension
        is enabled.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="extraDhcpOptions")
    def extra_dhcp_options(self) -> pulumi.Output[Optional[Sequence['outputs.PortExtraDhcpOption']]]:
        """
        An extra DHCP option that needs to be configured
        on the port. The structure is described below. Can be specified multiple
        times.
        """
        return pulumi.get(self, "extra_dhcp_options")

    @property
    @pulumi.getter(name="fixedIps")
    def fixed_ips(self) -> pulumi.Output[Optional[Sequence['outputs.PortFixedIp']]]:
        """
        An array of desired IPs for
        this port. The structure is described below.
        """
        return pulumi.get(self, "fixed_ips")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Output[str]:
        """
        The additional MAC address.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the DHCP option.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        The ID of the network to attach the port to. Changing
        this creates a new port.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="noFixedIp")
    def no_fixed_ip(self) -> pulumi.Output[Optional[bool]]:
        """
        Create a port with no fixed
        IP address. This will also remove any fixed IPs previously set on a port. `true`
        is the only valid value for this argument.
        """
        return pulumi.get(self, "no_fixed_ip")

    @property
    @pulumi.getter(name="noSecurityGroups")
    def no_security_groups(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to
        `true`, then no security groups are applied to the port. If set to `false` and
        no `security_group_ids` are specified, then the port will yield to the default
        behavior of the Networking service, which is to usually apply the "default"
        security group.
        """
        return pulumi.get(self, "no_security_groups")

    @property
    @pulumi.getter(name="portSecurityEnabled")
    def port_security_enabled(self) -> pulumi.Output[bool]:
        """
        Whether to explicitly enable or disable
        port security on the port. Port Security is usually enabled by default, so
        omitting argument will usually result in a value of `true`. Setting this
        explicitly to `false` will disable port security. In order to disable port
        security, the port must not have any security groups. Valid values are `true`
        and `false`.
        """
        return pulumi.get(self, "port_security_enabled")

    @property
    @pulumi.getter(name="qosPolicyId")
    def qos_policy_id(self) -> pulumi.Output[str]:
        """
        Reference to the associated QoS policy.
        """
        return pulumi.get(self, "qos_policy_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a port. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        port.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list
        of security group IDs to apply to the port. The security groups must be
        specified by ID and not name (as opposed to how they are configured with
        the Compute Instance).
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A set of string tags for the port.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The owner of the port. Required if admin wants
        to create a port for another tenant. Changing this creates a new port.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="valueSpecs")
    def value_specs(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Map of additional options.
        """
        return pulumi.get(self, "value_specs")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

