# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = [
    'GetAddressScopeResult',
    'AwaitableGetAddressScopeResult',
    'get_address_scope',
]

@pulumi.output_type
class GetAddressScopeResult:
    """
    A collection of values returned by getAddressScope.
    """
    def __init__(__self__, id=None, ip_version=None, name=None, project_id=None, region=None, shared=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_version and not isinstance(ip_version, int):
            raise TypeError("Expected argument 'ip_version' to be a int")
        pulumi.set(__self__, "ip_version", ip_version)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if shared and not isinstance(shared, bool):
            raise TypeError("Expected argument 'shared' to be a bool")
        pulumi.set(__self__, "shared", shared)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[int]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def shared(self) -> Optional[bool]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "shared")


class AwaitableGetAddressScopeResult(GetAddressScopeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddressScopeResult(
            id=self.id,
            ip_version=self.ip_version,
            name=self.name,
            project_id=self.project_id,
            region=self.region,
            shared=self.shared)


def get_address_scope(ip_version: Optional[int] = None,
                      name: Optional[str] = None,
                      project_id: Optional[str] = None,
                      region: Optional[str] = None,
                      shared: Optional[bool] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddressScopeResult:
    """
    Use this data source to get the ID of an available OpenStack address-scope.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    public_addressscope = openstack.networking.get_address_scope(ip_version=4,
        name="public_addressscope",
        shared=True)
    ```


    :param int ip_version: IP version.
    :param str name: Name of the address-scope.
    :param str project_id: The owner of the address-scope.
    :param str region: The region in which to obtain the V2 Neutron client.
           A Neutron client is needed to retrieve address-scopes. If omitted, the
           `region` argument of the provider is used.
    :param bool shared: Indicates whether this address-scope is shared across
           all projects.
    """
    __args__ = dict()
    __args__['ipVersion'] = ip_version
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['shared'] = shared
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('openstack:networking/getAddressScope:getAddressScope', __args__, opts=opts, typ=GetAddressScopeResult).value

    return AwaitableGetAddressScopeResult(
        id=__ret__.id,
        ip_version=__ret__.ip_version,
        name=__ret__.name,
        project_id=__ret__.project_id,
        region=__ret__.region,
        shared=__ret__.shared)
