# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Cluster']


class Cluster(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_template_id: Optional[pulumi.Input[str]] = None,
                 create_timeout: Optional[pulumi.Input[int]] = None,
                 discovery_url: Optional[pulumi.Input[str]] = None,
                 docker_volume_size: Optional[pulumi.Input[int]] = None,
                 fixed_network: Optional[pulumi.Input[str]] = None,
                 fixed_subnet: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 floating_ip_enabled: Optional[pulumi.Input[bool]] = None,
                 keypair: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 master_count: Optional[pulumi.Input[int]] = None,
                 master_flavor: Optional[pulumi.Input[str]] = None,
                 merge_labels: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a V1 Magnum cluster resource within OpenStack.

        ## Example Usage
        ### Create a Cluster

        ```python
        import pulumi
        import pulumi_openstack as openstack

        cluster1 = openstack.containerinfra.Cluster("cluster1",
            cluster_template_id="b9a45c5c-cd03-4958-82aa-b80bf93cb922",
            keypair="ssh_keypair",
            master_count=3,
            node_count=5)
        ```
        ## Argument reference

        The following arguments are supported:

        * `region` - (Optional) The region in which to obtain the V1 Container Infra
          client. A Container Infra client is needed to create a cluster. If omitted,
          the `region` argument of the provider is used. Changing this creates a new
          cluster.

        * `name` - (Required) The name of the cluster. Changing this updates the name
          of the existing cluster template.

        * `project_id` - (Optional) The project of the cluster. Required if admin wants
          to create a cluster in another project. Changing this creates a new
          cluster.

        * `user_id` - (Optional) The user of the cluster. Required if admin wants to
          create a cluster template for another user. Changing this creates a new
          cluster.

        * `cluster_template_id` - (Required) The UUID of the V1 Container Infra cluster
          template. Changing this creates a new cluster.

        * `create_timeout` - (Optional) The timeout (in minutes) for creating the
          cluster. Changing this creates a new cluster.

        * `discovery_url` - (Optional) The URL used for cluster node discovery.
          Changing this creates a new cluster.

        * `docker_volume_size` - (Optional) The size (in GB) of the Docker volume.
          Changing this creates a new cluster.

        * `flavor` - (Optional) The flavor for the nodes of the cluster. Can be set via
          the `OS_MAGNUM_FLAVOR` environment variable. Changing this creates a new
          cluster.

        * `master_flavor` - (Optional) The flavor for the master nodes. Can be set via
          the `OS_MAGNUM_MASTER_FLAVOR` environment variable. Changing this creates a
          new cluster.

        * `keypair` - (Optional) The name of the Compute service SSH keypair. Changing
          this creates a new cluster.

        * `labels` - (Optional) The list of key value pairs representing additional
          properties of the cluster. Changing this creates a new cluster.

        * `merge_labels` - (Optional) Indicates whether the provided labels should be
          merged with cluster template labels. Changing this creates a new cluster.

        * `master_count` - (Optional) The number of master nodes for the cluster.
          Changing this creates a new cluster.

        * `node_count` - (Optional) The number of nodes for the cluster. Changing this
          creates a new cluster.

        * `fixed_network` - (Optional) The fixed network that will be attached to the
          cluster. Changing this creates a new cluster.

        * `fixed_subnet` - (Optional) The fixed subnet that will be attached to the
          cluster. Changing this creates a new cluster.

        * `floating_ip_enabled` - (Optional) Indicates whether floating IP should be
          created for every cluster node. Changing this creates a new cluster.

        ## Attributes reference

        The following attributes are exported:

        * `region` - See Argument Reference above.
        * `name` - See Argument Reference above.
        * `project_id` - See Argument Reference above.
        * `created_at` - The time at which cluster was created.
        * `updated_at` - The time at which cluster was created.
        * `api_address` - COE API address.
        * `coe_version` - COE software version.
        * `cluster_template_id` - See Argument Reference above.
        * `container_version` - Container software version.
        * `create_timeout` - See Argument Reference above.
        * `discovery_url` - See Argument Reference above.
        * `docker_volume_size` - See Argument Reference above.
        * `flavor` - See Argument Reference above.
        * `master_flavor` - See Argument Reference above.
        * `keypair` - See Argument Reference above.
        * `labels` - See Argument Reference above.
        * `merge_labels` - See Argument Reference above.
        * `master_count` - See Argument Reference above.
        * `node_count` - See Argument Reference above.
        * `fixed_network` - See Argument Reference above.
        * `fixed_subnet` - See Argument Reference above.
        * `floating_ip_enabled` - See Argument Reference above.
        * `master_addresses` - IP addresses of the master node of the cluster.
        * `node_addresses` - IP addresses of the node of the cluster.
        * `stack_id` - UUID of the Orchestration service stack.
        * `kubeconfig` - The Kubernetes cluster's credentials
          * `raw_config` - The raw kubeconfig file
          * `host` - The cluster's API server URL
          * `cluster_ca_certificate` - The cluster's CA certificate
          * `client_key` - The client's RSA key
          * `client_certificate` - The client's certificate

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if cluster_template_id is None:
                raise TypeError("Missing required property 'cluster_template_id'")
            __props__['cluster_template_id'] = cluster_template_id
            __props__['create_timeout'] = create_timeout
            __props__['discovery_url'] = discovery_url
            __props__['docker_volume_size'] = docker_volume_size
            __props__['fixed_network'] = fixed_network
            __props__['fixed_subnet'] = fixed_subnet
            __props__['flavor'] = flavor
            __props__['floating_ip_enabled'] = floating_ip_enabled
            __props__['keypair'] = keypair
            __props__['labels'] = labels
            __props__['master_count'] = master_count
            __props__['master_flavor'] = master_flavor
            __props__['merge_labels'] = merge_labels
            __props__['name'] = name
            __props__['node_count'] = node_count
            __props__['region'] = region
            __props__['api_address'] = None
            __props__['coe_version'] = None
            __props__['container_version'] = None
            __props__['created_at'] = None
            __props__['kubeconfig'] = None
            __props__['master_addresses'] = None
            __props__['node_addresses'] = None
            __props__['project_id'] = None
            __props__['stack_id'] = None
            __props__['updated_at'] = None
            __props__['user_id'] = None
        super(Cluster, __self__).__init__(
            'openstack:containerinfra/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_address: Optional[pulumi.Input[str]] = None,
            cluster_template_id: Optional[pulumi.Input[str]] = None,
            coe_version: Optional[pulumi.Input[str]] = None,
            container_version: Optional[pulumi.Input[str]] = None,
            create_timeout: Optional[pulumi.Input[int]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            discovery_url: Optional[pulumi.Input[str]] = None,
            docker_volume_size: Optional[pulumi.Input[int]] = None,
            fixed_network: Optional[pulumi.Input[str]] = None,
            fixed_subnet: Optional[pulumi.Input[str]] = None,
            flavor: Optional[pulumi.Input[str]] = None,
            floating_ip_enabled: Optional[pulumi.Input[bool]] = None,
            keypair: Optional[pulumi.Input[str]] = None,
            kubeconfig: Optional[pulumi.Input[pulumi.InputType['ClusterKubeconfigArgs']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            master_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            master_count: Optional[pulumi.Input[int]] = None,
            master_flavor: Optional[pulumi.Input[str]] = None,
            merge_labels: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            node_count: Optional[pulumi.Input[int]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            stack_id: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["api_address"] = api_address
        __props__["cluster_template_id"] = cluster_template_id
        __props__["coe_version"] = coe_version
        __props__["container_version"] = container_version
        __props__["create_timeout"] = create_timeout
        __props__["created_at"] = created_at
        __props__["discovery_url"] = discovery_url
        __props__["docker_volume_size"] = docker_volume_size
        __props__["fixed_network"] = fixed_network
        __props__["fixed_subnet"] = fixed_subnet
        __props__["flavor"] = flavor
        __props__["floating_ip_enabled"] = floating_ip_enabled
        __props__["keypair"] = keypair
        __props__["kubeconfig"] = kubeconfig
        __props__["labels"] = labels
        __props__["master_addresses"] = master_addresses
        __props__["master_count"] = master_count
        __props__["master_flavor"] = master_flavor
        __props__["merge_labels"] = merge_labels
        __props__["name"] = name
        __props__["node_addresses"] = node_addresses
        __props__["node_count"] = node_count
        __props__["project_id"] = project_id
        __props__["region"] = region
        __props__["stack_id"] = stack_id
        __props__["updated_at"] = updated_at
        __props__["user_id"] = user_id
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiAddress")
    def api_address(self) -> pulumi.Output[str]:
        return pulumi.get(self, "api_address")

    @property
    @pulumi.getter(name="clusterTemplateId")
    def cluster_template_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cluster_template_id")

    @property
    @pulumi.getter(name="coeVersion")
    def coe_version(self) -> pulumi.Output[str]:
        return pulumi.get(self, "coe_version")

    @property
    @pulumi.getter(name="containerVersion")
    def container_version(self) -> pulumi.Output[str]:
        return pulumi.get(self, "container_version")

    @property
    @pulumi.getter(name="createTimeout")
    def create_timeout(self) -> pulumi.Output[int]:
        return pulumi.get(self, "create_timeout")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="discoveryUrl")
    def discovery_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "discovery_url")

    @property
    @pulumi.getter(name="dockerVolumeSize")
    def docker_volume_size(self) -> pulumi.Output[int]:
        return pulumi.get(self, "docker_volume_size")

    @property
    @pulumi.getter(name="fixedNetwork")
    def fixed_network(self) -> pulumi.Output[str]:
        return pulumi.get(self, "fixed_network")

    @property
    @pulumi.getter(name="fixedSubnet")
    def fixed_subnet(self) -> pulumi.Output[str]:
        return pulumi.get(self, "fixed_subnet")

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[str]:
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="floatingIpEnabled")
    def floating_ip_enabled(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "floating_ip_enabled")

    @property
    @pulumi.getter
    def keypair(self) -> pulumi.Output[str]:
        return pulumi.get(self, "keypair")

    @property
    @pulumi.getter
    def kubeconfig(self) -> pulumi.Output['outputs.ClusterKubeconfig']:
        return pulumi.get(self, "kubeconfig")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, Any]]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="masterAddresses")
    def master_addresses(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "master_addresses")

    @property
    @pulumi.getter(name="masterCount")
    def master_count(self) -> pulumi.Output[int]:
        return pulumi.get(self, "master_count")

    @property
    @pulumi.getter(name="masterFlavor")
    def master_flavor(self) -> pulumi.Output[str]:
        return pulumi.get(self, "master_flavor")

    @property
    @pulumi.getter(name="mergeLabels")
    def merge_labels(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "merge_labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeAddresses")
    def node_addresses(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "node_addresses")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[int]:
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "stack_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "user_id")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

