# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['Flavor']


class Flavor(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 disk: Optional[pulumi.Input[int]] = None,
                 ephemeral: Optional[pulumi.Input[int]] = None,
                 extra_specs: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_public: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ram: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rx_tx_factor: Optional[pulumi.Input[float]] = None,
                 swap: Optional[pulumi.Input[int]] = None,
                 vcpus: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a V2 flavor resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        test_flavor = openstack.compute.Flavor("test-flavor",
            disk=20,
            extra_specs={
                "hw:cpu_policy": "CPU-POLICY",
                "hw:cpu_thread_policy": "CPU-THREAD-POLICY",
            },
            ram=8096,
            vcpus=2)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] disk: The amount of disk space in gigabytes to use for the root
               (/) partition. Changing this creates a new flavor.
        :param pulumi.Input[Mapping[str, Any]] extra_specs: Key/Value pairs of metadata for the flavor.
        :param pulumi.Input[bool] is_public: Whether the flavor is public. Changing this creates
               a new flavor.
        :param pulumi.Input[str] name: A unique name for the flavor. Changing this creates a new
               flavor.
        :param pulumi.Input[int] ram: The amount of RAM to use, in megabytes. Changing this
               creates a new flavor.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Compute client.
               Flavors are associated with accounts, but a Compute client is needed to
               create one. If omitted, the `region` argument of the provider is used.
               Changing this creates a new flavor.
        :param pulumi.Input[float] rx_tx_factor: RX/TX bandwith factor. The default is 1. Changing
               this creates a new flavor.
        :param pulumi.Input[int] swap: The amount of disk space in megabytes to use. If
               unspecified, the default is 0. Changing this creates a new flavor.
        :param pulumi.Input[int] vcpus: The number of virtual CPUs to use. Changing this creates
               a new flavor.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if disk is None:
                raise TypeError("Missing required property 'disk'")
            __props__['disk'] = disk
            __props__['ephemeral'] = ephemeral
            __props__['extra_specs'] = extra_specs
            __props__['is_public'] = is_public
            __props__['name'] = name
            if ram is None:
                raise TypeError("Missing required property 'ram'")
            __props__['ram'] = ram
            __props__['region'] = region
            __props__['rx_tx_factor'] = rx_tx_factor
            __props__['swap'] = swap
            if vcpus is None:
                raise TypeError("Missing required property 'vcpus'")
            __props__['vcpus'] = vcpus
        super(Flavor, __self__).__init__(
            'openstack:compute/flavor:Flavor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            disk: Optional[pulumi.Input[int]] = None,
            ephemeral: Optional[pulumi.Input[int]] = None,
            extra_specs: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_public: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            ram: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            rx_tx_factor: Optional[pulumi.Input[float]] = None,
            swap: Optional[pulumi.Input[int]] = None,
            vcpus: Optional[pulumi.Input[int]] = None) -> 'Flavor':
        """
        Get an existing Flavor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] disk: The amount of disk space in gigabytes to use for the root
               (/) partition. Changing this creates a new flavor.
        :param pulumi.Input[Mapping[str, Any]] extra_specs: Key/Value pairs of metadata for the flavor.
        :param pulumi.Input[bool] is_public: Whether the flavor is public. Changing this creates
               a new flavor.
        :param pulumi.Input[str] name: A unique name for the flavor. Changing this creates a new
               flavor.
        :param pulumi.Input[int] ram: The amount of RAM to use, in megabytes. Changing this
               creates a new flavor.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Compute client.
               Flavors are associated with accounts, but a Compute client is needed to
               create one. If omitted, the `region` argument of the provider is used.
               Changing this creates a new flavor.
        :param pulumi.Input[float] rx_tx_factor: RX/TX bandwith factor. The default is 1. Changing
               this creates a new flavor.
        :param pulumi.Input[int] swap: The amount of disk space in megabytes to use. If
               unspecified, the default is 0. Changing this creates a new flavor.
        :param pulumi.Input[int] vcpus: The number of virtual CPUs to use. Changing this creates
               a new flavor.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["disk"] = disk
        __props__["ephemeral"] = ephemeral
        __props__["extra_specs"] = extra_specs
        __props__["is_public"] = is_public
        __props__["name"] = name
        __props__["ram"] = ram
        __props__["region"] = region
        __props__["rx_tx_factor"] = rx_tx_factor
        __props__["swap"] = swap
        __props__["vcpus"] = vcpus
        return Flavor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def disk(self) -> pulumi.Output[int]:
        """
        The amount of disk space in gigabytes to use for the root
        (/) partition. Changing this creates a new flavor.
        """
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter
    def ephemeral(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "ephemeral")

    @property
    @pulumi.getter(name="extraSpecs")
    def extra_specs(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Key/Value pairs of metadata for the flavor.
        """
        return pulumi.get(self, "extra_specs")

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the flavor is public. Changing this creates
        a new flavor.
        """
        return pulumi.get(self, "is_public")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name for the flavor. Changing this creates a new
        flavor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ram(self) -> pulumi.Output[int]:
        """
        The amount of RAM to use, in megabytes. Changing this
        creates a new flavor.
        """
        return pulumi.get(self, "ram")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to obtain the V2 Compute client.
        Flavors are associated with accounts, but a Compute client is needed to
        create one. If omitted, the `region` argument of the provider is used.
        Changing this creates a new flavor.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rxTxFactor")
    def rx_tx_factor(self) -> pulumi.Output[Optional[float]]:
        """
        RX/TX bandwith factor. The default is 1. Changing
        this creates a new flavor.
        """
        return pulumi.get(self, "rx_tx_factor")

    @property
    @pulumi.getter
    def swap(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of disk space in megabytes to use. If
        unspecified, the default is 0. Changing this creates a new flavor.
        """
        return pulumi.get(self, "swap")

    @property
    @pulumi.getter
    def vcpus(self) -> pulumi.Output[int]:
        """
        The number of virtual CPUs to use. Changing this creates
        a new flavor.
        """
        return pulumi.get(self, "vcpus")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

