# generated by datamodel-codegen:
#   filename:  bundled.yaml

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional, Union
from uuid import UUID

from pydantic import AnyUrl, BaseModel, Extra, Field, constr


class PingResponse(BaseModel):
    message: str
    success: bool


class Status(Enum):
    ACTIVE = "ACTIVE"
    DEPRECATED = "DEPRECATED"


class ContractOutput(BaseModel):
    id: UUID = Field(
        ..., description="Unique identifier for the contract in UUID format"
    )
    version: str = Field(
        ..., description="Version of the contract (semantic versioning)"
    )
    status: Status = Field(..., description="status of the contract")
    gitHash: constr(min_length=40, max_length=40) = Field(
        ...,
        description="full length git hash corresponding to the commit this contract was added/updated",
    )
    gitRepo: AnyUrl = Field(
        ..., description="full link to the git repo this contract lives in"
    )
    gitUser: str = Field(..., description="git user who added/updated this contract")
    fileUri: AnyUrl = Field(
        ..., description="full link to the file in the repo that contains this contract"
    )
    reviewers: Optional[List[str]] = Field(
        None,
        description="optional list of users who reviewed the merged PR that this contract added/updated in",
    )
    mergedAt: datetime = Field(
        ...,
        description="date time at which the PR that added/updated this contract was merged",
    )
    createdAt: datetime = Field(
        ..., description="date time at which the contract was created"
    )
    updatedAt: datetime = Field(
        ..., description="date time at which the contract was last updated"
    )
    contractSpec: Dict[str, Any] = Field(..., description="contract spec")
    contractSpecRaw: str = Field(..., description="contract spec raw json")


class GetContractsResponse(BaseModel):
    __root__: List[ContractOutput]


class ContractInput(BaseModel):
    id: UUID = Field(
        ..., description="Unique identifier for the contract in UUID format"
    )
    version: str = Field(
        ..., description="Version of the contract (semantic versioning)"
    )
    status: Status = Field(..., description="status of the contract")
    gitHash: constr(min_length=40, max_length=40) = Field(
        ...,
        description="full length git hash corresponding to the commit this contract was added/updated",
    )
    gitRepo: AnyUrl = Field(
        ..., description="full link to the git repo this contract lives in"
    )
    gitUser: str = Field(..., description="git user who added/updated this contract")
    reviewers: Optional[List[str]] = Field(
        None,
        description="optional list of users who reviewed the merged PR that this contract added/updated in",
    )
    filePath: constr(regex=r"^([^/]+\/)*[^/]+$") = Field(
        ..., description="path to the contract file from the root of the git repository"
    )
    mergedAt: datetime = Field(
        ...,
        description="date time at which the PR that added/updated this contract was merged",
    )
    contractSpec: Any = Field(..., description="contract spec")


class PostContractRequest(BaseModel):
    __root__: Union[ContractInput, List[ContractInput]]


class PostContractResponse(BaseModel):
    message: str
    contractIds: List[UUID] = Field(
        ...,
        description="List of contract IDs that were updated, if no contracts were updated this will be an empty list",
    )


class Type(Enum):
    SNOWFLAKE = "SNOWFLAKE"


class BaseSnowflakeLineageIntegrationConfig(BaseModel):
    type: Type = Field(..., description="Type of the lineage integration")
    account_id: str = Field(..., description="Snowflake account id")
    warehouse: str = Field(..., description="Snowflake warehouse")
    role: str = Field(..., description="Snowflake role")
    table_ignore_patterns: Optional[List[str]] = Field(
        None,
        description="Optional list of regex patterns to ignore tables when syncing schema & lineage",
    )


class GetSnowflakeCredentials(BaseModel):
    username: str = Field(..., description="Snowflake username")


class SnowflakePasswordCredentials(GetSnowflakeCredentials):
    password: str = Field(..., description="Password for the Snowflake user")


class SnowflakeKeyPairCredentials(GetSnowflakeCredentials):
    private_key_base64: str = Field(..., description="Base64 encoded private key")
    private_key_passphrase: Optional[str] = Field(
        None, description="Optional private key passphrase"
    )


class CreateOrUpdateSnowflakeLineageIntegrationConfig1(
    BaseSnowflakeLineageIntegrationConfig
):
    pass


class CreateOrUpdateSnowflakeLineageIntegrationConfig2(
    SnowflakePasswordCredentials, CreateOrUpdateSnowflakeLineageIntegrationConfig1
):
    pass


class CreateOrUpdateSnowflakeLineageIntegrationConfig3(
    SnowflakeKeyPairCredentials, CreateOrUpdateSnowflakeLineageIntegrationConfig1
):
    pass


class CreateOrUpdateSnowflakeLineageIntegrationConfig(BaseModel):
    __root__: Union[
        CreateOrUpdateSnowflakeLineageIntegrationConfig2,
        CreateOrUpdateSnowflakeLineageIntegrationConfig3,
    ]


class Type1(Enum):
    BIG_QUERY = "BIG_QUERY"


class BaseBigQueryLineageIntegrationConfig(BaseModel):
    type: Type1 = Field(..., description="Type of the lineage integration")
    project_id: str = Field(..., description="BigQuery project id")
    table_ignore_patterns: Optional[List[str]] = Field(
        None,
        description="Optional list of regex patterns to ignore tables when syncing schema & lineage",
    )


class GetBigQueryCredentials(BaseModel):
    service_account_email: str = Field(
        ..., description="BigQuery service account email"
    )
    service_account_id: str = Field(..., description="BigQuery service account id")
    service_account_private_key_id: str = Field(
        ..., description="BigQuery service account private key id"
    )


class BigQueryServiceAccountKeyCredentials(GetBigQueryCredentials):
    service_account_private_key_base64: str = Field(
        ..., description="Base64 encoded private key"
    )


class CreateOrUpdateBigQueryLineageIntegrationConfig(
    BaseBigQueryLineageIntegrationConfig, BigQueryServiceAccountKeyCredentials
):
    pass


class CreateOrUpdateLineageIntegrationRequest(BaseModel):
    name: str = Field(..., description="Name of the lineage integration")
    scheduleCron: str = Field(
        ...,
        description="Cron expression used to schedule runs of the lineage integration",
    )
    config: Union[
        CreateOrUpdateSnowflakeLineageIntegrationConfig,
        CreateOrUpdateBigQueryLineageIntegrationConfig,
    ] = Field(..., description="Configuration for the lineage integration")


class CreateOrUpdateLineageIntegrationResponse(BaseModel):
    id: str = Field(..., description="ID of the created or updated lineage integration")


class ErrorResponse(BaseModel):
    message: str


class GetSnowflakeLineageIntegrationConfig(
    BaseSnowflakeLineageIntegrationConfig, GetSnowflakeCredentials
):
    pass


class GetBigQueryLineageIntegrationConfig(
    BaseBigQueryLineageIntegrationConfig, GetBigQueryCredentials
):
    pass


class GetLineageIntegrationResponse(BaseModel):
    id: str = Field(..., description="ID of the lineage integration")
    name: str = Field(..., description="Name of the lineage integration")
    scheduleCron: str = Field(
        ...,
        description="Cron expression used to schedule runs of the lineage integration",
    )
    config: Union[
        GetSnowflakeLineageIntegrationConfig, GetBigQueryLineageIntegrationConfig
    ] = Field(..., description="Configuration for the lineage integration")


class GetLineageIntegrationsResponse(BaseModel):
    __root__: List[GetLineageIntegrationResponse]


class TestLineageIntegrationRequest(BaseModel):
    name: str = Field(..., description="Name of the lineage integration")
    config: Union[
        CreateOrUpdateSnowflakeLineageIntegrationConfig,
        CreateOrUpdateBigQueryLineageIntegrationConfig,
    ] = Field(..., description="Configuration for the lineage integration")


class TestLineageIntegrationResponse(BaseModel):
    success: bool = Field(
        ..., description="a boolean indicating if the lineage integration is valid"
    )
    message: Optional[str] = Field(
        None, description="a message indicating why the lineage integration is invalid"
    )


class DataAssetId(BaseModel):
    __root__: constr(
        regex=r"^(protobuf|avro|json_schema|postgres|mysql|snowflake|bigquery)://(?=.*[a-zA-Z0-9])[a-zA-Z0-9_@\.:/-]+:(?=.*[a-zA-Z0-9])[a-zA-Z0-9_\./-]+$"
    ) = Field(
        ...,
        description="The unique identifier of the data asset. It follows the pattern '{data_asset_type}://{data_asset_namespace}:{data_asset_name}'",
    )


class MarquezId(BaseModel):
    namespace: str = Field(..., description="The namespace of the Marquez dataset.")
    name: str = Field(..., description="The name of the Marquez dataset.")


class FieldModel(BaseModel):
    name: str = Field(..., description="The name of the field.")
    type: str = Field(..., description="The data type of the field.")
    tags: Optional[List[str]] = Field(None, description="List of tags.")
    description: Optional[str] = Field(
        None, description="The description of the field."
    )


class DataAsset(BaseModel):
    id: DataAssetId
    marquezId: MarquezId = Field(..., description="The ID of the dataset.")
    type: str = Field(..., description="The type of the data asset.")
    name: str = Field(..., description="The **logical** name of the data asset.")
    physicalName: Optional[str] = Field(
        None, description="The **physical** name of the data asset."
    )
    createdAt: Optional[datetime] = Field(
        None,
        description="An [ISO-8601](https://en.wikipedia.org/wiki/ISO_8601) timestamp representing the date/time the data asset was created.",
    )
    updatedAt: Optional[datetime] = Field(
        None,
        description="An [ISO-8601](https://en.wikipedia.org/wiki/ISO_8601) timestamp representing the date/time the data asset was updated.",
    )
    namespace: Optional[str] = Field(
        None, description="The namespace of the data asset."
    )
    sourceName: Optional[str] = Field(
        None, description="The name of the source associated with the data asset."
    )
    fields: List[FieldModel] = Field(..., description="The fields of the data asset.")
    owners: List[str] = Field(
        ..., description="The email addresses of the owners of the data asset."
    )
    dataContractIds: List[UUID] = Field(
        ..., description="The contract IDs associated with the data asset."
    )
    tags: Optional[List[str]] = Field(None, description="List of tags.")
    lastModifiedAt: Optional[datetime] = Field(
        None,
        description="An [ISO-8601](https://en.wikipedia.org/wiki/ISO_8601) timestamp representing the date/time the data asset was last modified by a successful run.",
    )
    description: Optional[str] = Field(
        ..., description="The description of the data asset."
    )
    currentVersion: Optional[UUID] = Field(
        None, description="The current version of the data asset."
    )
    deleted: Optional[bool] = Field(
        None, description="The deleted state of the data asset."
    )


class CreateOrUpdateDataAssetResponse(BaseModel):
    id: str = Field(..., description="ID of the created or updated data asset")


class GetAvailableLineageIntegrationsResponse(BaseModel):
    __root__: List[str]


class GetAvailableLineageIntegrationDetailsResponseItem(BaseModel):
    instructions: Optional[str] = Field(
        None, description="Instructions for setting up the lineage integration"
    )
    requiredInputs: Optional[List[str]] = Field(
        None, description="Required inputs for setting up the lineage integration"
    )


class GetAvailableLineageIntegrationDetailsResponse(BaseModel):
    __root__: List[GetAvailableLineageIntegrationDetailsResponseItem]


class GetApiKeysResponseItem(BaseModel):
    id: Optional[str] = Field(None, description="The identifier of the API key")
    name: Optional[str] = Field(None, description="The name of the API key")
    value: Optional[str] = Field(None, description="The value of the API key")


class GetApiKeysResponse(BaseModel):
    __root__: List[GetApiKeysResponseItem]


class ContractSpecSchemaProperty(BaseModel):
    class Config:
        extra = Extra.allow

    name: str = Field(..., description="Name of the property")
    type: str = Field(..., description="Type of the property")
    doc: str = Field(..., description="Description of the property")


class GetContractResponse(BaseModel):
    __root__: ContractOutput


class ContractSpec(BaseModel):
    id: UUID = Field(
        ..., description="Unique identifier for the contract in UUID format"
    )
    dataAssetResourceName: DataAssetId
    doc: str = Field(..., description="Description of the contract")
    name: constr(regex=r"^(?=.*[a-zA-Z0-9])[a-zA-Z0-9_]+$") = Field(
        ...,
        description="The name of the contract. When combined with the contract namespace, it represents a unique name in the Gable platform.  Only alphanumeric characters (upper and lowercase) and underscores are allowed",
    )
    namespace: constr(regex=r"^(?=.*[a-zA-Z0-9])[a-zA-Z0-9_\.]+$") = Field(
        ...,
        description="The namespace of the contract. When combined with the contract name, it represents a unique name in the Gable platform. Only alphanumeric characters (upper and lowercase), underscores, and periods are allowed",
    )
    owner: str = Field(..., description="Owner of the contract")
    schema_: List[ContractSpecSchemaProperty] = Field(
        ..., alias="schema", description="Schema of the contract"
    )


class Type2(Enum):
    PROTOBUF = "PROTOBUF"
    AVRO = "AVRO"
    JSON_SCHEMA = "JSON_SCHEMA"
    POSTGRES = "POSTGRES"
    SNOWFLAKE = "SNOWFLAKE"


class CheckContractViolationRequest(BaseModel):
    type: Type2 = Field(
        ..., description="The type of the schema to check for violations"
    )
    schema_contents: str = Field(
        ..., description="The schema contents to check for violations"
    )
    isSchemaBase64: Optional[bool] = Field(
        False, description="Whether the schema is base64 encoded, defaults to false"
    )


class DataAssetList(BaseModel):
    __root__: List[DataAsset]


class CheckResponse(BaseModel):
    message: str
    success: bool
