# mypy-boto3-datasync

[![PyPI - mypy-boto3-datasync](https://img.shields.io/pypi/v/mypy-boto3-datasync.svg?color=blue)](https://pypi.org/project/mypy-boto3-datasync)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-datasync.svg?color=blue)](https://pypi.org/project/mypy-boto3-datasync)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.DataSync 1.13.5](https://boto3.amazonaws.com/v1/documentation/api/1.13.5/reference/services/datasync.html#DataSync) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.9](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-datasync](#mypy-boto3-datasync)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `DataSync` service.

```bash
python -m pip install boto3-stubs[datasync]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import datasync
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_datasync as datasync

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("datasync")
client: datasync.DataSyncClient = boto3.client("datasync")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: datasync.DataSyncClient = session.client("datasync")


# Paginators need type annotation on creation
list_agents_paginator: datasync.ListAgentsPaginator = client.get_paginator("list_agents")
list_locations_paginator: datasync.ListLocationsPaginator = client.get_paginator("list_locations")
list_tags_for_resource_paginator: datasync.ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
list_task_executions_paginator: datasync.ListTaskExecutionsPaginator = client.get_paginator("list_task_executions")
list_tasks_paginator: datasync.ListTasksPaginator = client.get_paginator("list_tasks")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.