import { Construct } from "constructs";
/**
 * Represents a WAF V2 managed rule.
 */
export interface ManagedRule {
    /**
     * The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.
     */
    readonly vendor: string;
    /**
     * The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
     */
    readonly name: string;
}
/**
 * Type of Cidr.
 */
export type CidrType = "IPV4" | "IPV6";
/**
 * Representation of a CIDR range.
 */
export interface CidrAllowList {
    /**
     * Type of CIDR range.
     */
    readonly cidrType: CidrType;
    /**
     * Specify an IPv4 address by using CIDR notation. For example:
     * To configure AWS WAF to allow, block, or count requests that originated from the IP address 192.0.2.44, specify 192.0.2.44/32 .
     * To configure AWS WAF to allow, block, or count requests that originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24 .
     *
     * For more information about CIDR notation, see the Wikipedia entry Classless Inter-Domain Routing .
     *
     * Specify an IPv6 address by using CIDR notation. For example:
     * To configure AWS WAF to allow, block, or count requests that originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128 .
     * To configure AWS WAF to allow, block, or count requests that originated from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify 1111:0000:0000:0000:0000:0000:0000:0000/64 .
     */
    readonly cidrRanges: string[];
}
/**
 * Properties to configure the web acl.
 */
export interface CloudFrontWebAclProps {
    /**
     * List of managed rules to apply to the web acl.
     *
     * @default - [{ vendor: "AWS", name: "AWSManagedRulesCommonRuleSet" }]
     */
    readonly managedRules?: ManagedRule[];
    /**
     * List of cidr ranges to allow.
     *
     * @default - undefined
     */
    readonly cidrAllowList?: CidrAllowList;
}
/**
 * This construct creates a WAFv2 Web ACL for cloudfront in the us-east-1 region (required for cloudfront) no matter the
 * region of the parent cdk stack.
 */
export declare class CloudfrontWebAcl extends Construct {
    readonly webAclId: string;
    readonly webAclArn: string;
    constructor(scope: Construct, id: string, props?: CloudFrontWebAclProps);
    /**
     * Creates an event handler for managing an ACL in us-east-1.
     *
     * @param stack containing Stack instance.
     * @param aclName name of the ACL to manage.
     * @private
     */
    private createOnEventHandler;
    /**
     * Creates a Custom resource to manage the deployment of the ACL.
     *
     * @param stack containing Stack instance.
     * @param aclName name of the ACL to manage.
     * @param onEventHandler event handler to use for deployment.
     * @param props user provided properties for configuring the ACL.
     * @private
     */
    private createAclCustomResource;
}
