"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.combineAsyncIterables = void 0;
const tslib_1 = require("tslib");
function combineAsyncIterables(..._iterators) {
    return tslib_1.__asyncGenerator(this, arguments, function* combineAsyncIterables_1() {
        // Convert iterables into iterators with next, return, throws methods.
        // If it's already an iterator, keep it.
        const iterators = _iterators.map((it) => {
            if (typeof it['next'] === 'function') {
                return it;
            }
            else {
                return (function wrapped() {
                    return tslib_1.__asyncGenerator(this, arguments, function* wrapped_1() {
                        var e_1, _a;
                        try {
                            for (var it_1 = tslib_1.__asyncValues(it), it_1_1; it_1_1 = yield tslib_1.__await(it_1.next()), !it_1_1.done;) {
                                const val = it_1_1.value;
                                yield yield tslib_1.__await(val);
                            }
                        }
                        catch (e_1_1) { e_1 = { error: e_1_1 }; }
                        finally {
                            try {
                                if (it_1_1 && !it_1_1.done && (_a = it_1.return)) yield tslib_1.__await(_a.call(it_1));
                            }
                            finally { if (e_1) throw e_1.error; }
                        }
                    });
                })();
            }
        });
        let [options] = iterators;
        if (typeof options.next === 'function') {
            options = Object.create(null);
        }
        else {
            iterators.shift();
        }
        const getNextAsyncIteratorValue = getNextAsyncIteratorFactory(options);
        try {
            const asyncIteratorsValues = new Map(iterators.map((it, idx) => [idx, getNextAsyncIteratorValue(it, idx)]));
            do {
                const { iterator, index } = yield tslib_1.__await(Promise.race(asyncIteratorsValues.values()));
                if (iterator.done) {
                    asyncIteratorsValues.delete(index);
                }
                else {
                    yield yield tslib_1.__await(iterator.value);
                    asyncIteratorsValues.set(index, getNextAsyncIteratorValue(iterators[index], index));
                }
            } while (asyncIteratorsValues.size > 0);
        }
        finally {
            yield tslib_1.__await(Promise.allSettled(iterators.map((it) => { var _a; return (_a = it['return']) === null || _a === void 0 ? void 0 : _a.call(it); })));
        }
    });
}
exports.combineAsyncIterables = combineAsyncIterables;
function getNextAsyncIteratorFactory(options) {
    return (asyncIterator, index) => tslib_1.__awaiter(this, void 0, void 0, function* () {
        try {
            const iterator = yield asyncIterator.next();
            return { index, iterator };
        }
        catch (err) {
            if (options.errorCallback) {
                options.errorCallback(err, index);
            }
            return Promise.reject(err);
        }
    });
}
//# sourceMappingURL=combine-async-iterables.js.map