"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ZendeskDestination = void 0;
const type_1 = require("./type");
class ZendeskDestination {
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.ZendeskConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.errorHandling?.errorLocation?.bucket);
        this.tryAddNodeDependency(flow, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            zendesk: {
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling.failOnFirstError,
                },
                idFieldNames: this.props.operation.ids,
                object: this.props.object,
                writeOperationType: this.props.operation.type,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource) {
            scope.node.addDependency(resource);
        }
    }
}
exports.ZendeskDestination = ZendeskDestination;
//# sourceMappingURL=data:application/json;base64,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