import { CfnFlow } from "aws-cdk-lib/aws-appflow";
import { ConnectorType } from "../core/connectors/connector-type";
import { ErrorHandlingConfiguration } from "../core/error-handling";
import { IFlow } from "../core/flows";
import { IDestination } from "../core/vertices/destination";
import { WriteOperation } from "../core/write-operation";
import { ZendeskConnectorProfile } from "../zendesk/profile";
export interface ZendeskDestinationProps {
    readonly profile: ZendeskConnectorProfile;
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the Zendesk destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure.
     */
    readonly errorHandling?: ErrorHandlingConfiguration;
    /**
     * The Zendesk object for which the operation is to be set.
     */
    readonly object: string;
    readonly operation: WriteOperation;
}
export declare class ZendeskDestination implements IDestination {
    private readonly props;
    readonly connectorType: ConnectorType;
    constructor(props: ZendeskDestinationProps);
    bind(flow: IFlow): CfnFlow.DestinationFlowConfigProperty;
    private buildDestinationConnectorProperties;
    private tryAddNodeDependency;
}
