"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnowflakeConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
const connector_profile_1 = require("../core/connectors/connector-profile");
class SnowflakeConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, {
            arn,
        });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, {
            name,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.SnowflakeConnectorType.instance);
        this._location = props.location;
        this._database = props.database;
        this._schema = props.schema ?? SnowflakeConnectorProfile.defaultSchema;
        this.integrationRole = this.tryCreateRole(scope, id, props);
    }
    // INFO: maybe move it to an external class so that it can be either used here or used in any subsequent deployment?
    tryCreateRole(scope, id, props) {
        const properties = props;
        const integration = properties.integration;
        if (!integration) {
            return undefined;
        }
        // INFO: following https://docs.snowflake.com/en/user-guide/data-load-s3-config-storage-integration#configuring-secure-access-to-cloud-storage
        // TODO: currently, the implementation allows read-only access. Make sure that we don't need the write permissions
        return new aws_iam_1.Role(scope, `${id}IntegrationRole`, {
            assumedBy: new aws_iam_1.ArnPrincipal(integration.storageUserArn),
            externalIds: [integration.externalId],
            inlinePolicies: {
                SnowflakeAccess: new aws_iam_1.PolicyDocument({
                    statements: [
                        new aws_iam_1.PolicyStatement({
                            effect: aws_iam_1.Effect.ALLOW,
                            actions: ["s3:GetObject", "s3:GetObjectVersion"],
                            resources: [
                                properties.location.bucket.arnForObjects(properties.location.prefix ?? "*"),
                            ],
                        }),
                        new aws_iam_1.PolicyStatement({
                            effect: aws_iam_1.Effect.ALLOW,
                            actions: ["s3:ListBucket", "s3:GetBucketLocation"],
                            resources: [properties.location.bucket.bucketArn],
                            conditions: {
                                StringLike: {
                                    "s3:prefix": [properties.location.prefix ?? "*"],
                                },
                            },
                        }),
                    ],
                }),
            },
        });
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            snowflake: {
                username: properties.basicAuth.username,
                password: properties.basicAuth.password?.unsafeUnwrap(),
            },
        };
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        this.tryAddNodeDependency(this, properties.location.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketReadWrite(properties.location.bucket);
        return {
            snowflake: {
                bucketName: properties.location.bucket.bucketName,
                bucketPrefix: properties.location.prefix,
                stage: `${properties.database}.${properties.schema}.${properties.stage}`,
                warehouse: properties.warehouse,
                accountName: properties.account,
                region: properties.region,
            },
        };
    }
}
exports.SnowflakeConnectorProfile = SnowflakeConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
SnowflakeConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.SnowflakeConnectorProfile", version: "0.2.1" };
/**
 * Default Snowflake schema if no schema provided
 */
SnowflakeConnectorProfile.defaultSchema = "PUBLIC";
//# sourceMappingURL=data:application/json;base64,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