"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnowflakeDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
/**
 * A Snowflake destination.
 */
class SnowflakeDestination {
    get connectorType() {
        return this._connectorType;
    }
    constructor(props) {
        this.props = props;
        this._connectorType = type_1.SnowflakeConnectorType.instance;
    }
    bind(scope) {
        this.tryAddNodeDependency(scope, this.props.errorHandling?.errorLocation?.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        this.tryAddNodeDependency(scope, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            snowflake: {
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling.failOnFirstError,
                },
                // TODO: identify if this needs to be the same as the bucketName/prefix in the profile
                //       for now that is the assumption and we're pulling this data from the profile
                intermediateBucketName: this.props.profile._location.bucket.bucketName,
                bucketPrefix: this.props.profile._location.prefix,
                object: this.buildObject(this.props.profile._database, this.props.object.table, this.props.profile._schema),
            },
        };
    }
    buildObject(database, table, schema) {
        return `${database}.${schema}.${table}`;
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.SnowflakeDestination = SnowflakeDestination;
_a = JSII_RTTI_SYMBOL_1;
SnowflakeDestination[_a] = { fqn: "@cdklabs/cdk-appflow.SnowflakeDestination", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVzdGluYXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvc25vd2ZsYWtlL2Rlc3RpbmF0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBT0EsaUNBQWdEO0FBRWhELHFGQUFnRjtBQWtDaEY7O0dBRUc7QUFDSCxNQUFhLG9CQUFvQjtJQUkvQixJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFFRCxZQUE2QixLQUFnQztRQUFoQyxVQUFLLEdBQUwsS0FBSyxDQUEyQjtRQVA1QyxtQkFBYyxHQUM3Qiw2QkFBc0IsQ0FBQyxRQUFRLENBQUM7SUFNOEIsQ0FBQztJQUVqRSxJQUFJLENBQUMsS0FBWTtRQUNmLElBQUksQ0FBQyxvQkFBb0IsQ0FDdkIsS0FBSyxFQUNMLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxFQUFFLGFBQWEsRUFBRSxNQUFNLENBQ2hELENBQUM7UUFDRix1REFBeUIsQ0FBQyxRQUFRLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FDbkQsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLEVBQUUsYUFBYSxFQUFFLE1BQU0sQ0FDaEQsQ0FBQztRQUNGLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUVyRCxPQUFPO1lBQ0wsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsc0JBQXNCO1lBQ3hELG9CQUFvQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUk7WUFDN0MsOEJBQThCLEVBQzVCLElBQUksQ0FBQyxtQ0FBbUMsRUFBRTtTQUM3QyxDQUFDO0lBQ0osQ0FBQztJQUVPLG1DQUFtQztRQUN6QyxPQUFPO1lBQ0wsU0FBUyxFQUFFO2dCQUNULG1CQUFtQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxJQUFJO29CQUMvQyxVQUFVLEVBQ1IsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLEVBQUUsYUFBYSxFQUFFLE1BQU0sQ0FBQyxVQUFVO29CQUM1RCxZQUFZLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLEVBQUUsYUFBYSxFQUFFLE1BQU07b0JBQzdELGdCQUFnQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLGdCQUFnQjtpQkFDNUQ7Z0JBQ0Qsc0ZBQXNGO2dCQUN0RixvRkFBb0Y7Z0JBQ3BGLHNCQUFzQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsVUFBVTtnQkFDdEUsWUFBWSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxNQUFNO2dCQUNqRCxNQUFNLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FDdEIsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsU0FBUyxFQUM1QixJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQ3ZCLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FDM0I7YUFDRjtTQUNGLENBQUM7SUFDSixDQUFDO0lBRU8sV0FBVyxDQUFDLFFBQWdCLEVBQUUsS0FBYSxFQUFFLE1BQWM7UUFDakUsT0FBTyxHQUFHLFFBQVEsSUFBSSxNQUFNLElBQUksS0FBSyxFQUFFLENBQUM7SUFDMUMsQ0FBQztJQUVPLG9CQUFvQixDQUMxQixLQUFpQixFQUNqQixRQUE4QjtRQUU5QixJQUFJLFFBQVEsSUFBSSxPQUFPLFFBQVEsS0FBSyxRQUFRLEVBQUUsQ0FBQztZQUM3QyxLQUFLLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUNyQyxDQUFDO0lBQ0gsQ0FBQzs7QUE3REgsb0RBOERDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5GbG93IH0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1hcHBmbG93XCI7XG5pbXBvcnQgeyBJQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcbmltcG9ydCB7IFNub3dmbGFrZUNvbm5lY3RvclByb2ZpbGUgfSBmcm9tIFwiLi9wcm9maWxlXCI7XG5pbXBvcnQgeyBTbm93Zmxha2VDb25uZWN0b3JUeXBlIH0gZnJvbSBcIi4vdHlwZVwiO1xuaW1wb3J0IHsgRXJyb3JIYW5kbGluZ0NvbmZpZ3VyYXRpb24sIElGbG93IH0gZnJvbSBcIi4uL2NvcmVcIjtcbmltcG9ydCB7IEFwcEZsb3dQZXJtaXNzaW9uc01hbmFnZXIgfSBmcm9tIFwiLi4vY29yZS9hcHBmbG93LXBlcm1pc3Npb25zLW1hbmFnZXJcIjtcbmltcG9ydCB7IENvbm5lY3RvclR5cGUgfSBmcm9tIFwiLi4vY29yZS9jb25uZWN0b3JzL2Nvbm5lY3Rvci10eXBlXCI7XG5pbXBvcnQgeyBJRGVzdGluYXRpb24gfSBmcm9tIFwiLi4vY29yZS92ZXJ0aWNlc1wiO1xuXG4vKipcbiAqIFRoZSBkZXN0aW5hdGlvbiB0YWJsZSBpbiBTbm93Zmxha2UuIFRoZSB0YWJsZSBuZWVkcyB0byByZXNpZGUgaW4gdGhlIGRhdGFiYXMgYW5kIHNjaGVtYSBwcm92aWRlZCBpbiB0aGUgcHJvZmlsZS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTbm93Zmxha2VEZXN0aW5hdGlvbk9iamVjdCB7XG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgdGFibGUgb2JqZWN0XG4gICAqL1xuICByZWFkb25seSB0YWJsZTogc3RyaW5nO1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgdGhhdCBhcmUgcmVxdWlyZWQgdG8gY3JlYXRlIGEgU25vd2ZsYWtlIGRlc3RpbmF0aW9uLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFNub3dmbGFrZURlc3RpbmF0aW9uUHJvcHMge1xuICAvKipcbiAgICogQSBTbm93Zmxha2UgY29ubmVjdG9yIHByb2ZpbGUgaW5zdGFuY2UuXG4gICAqL1xuICByZWFkb25seSBwcm9maWxlOiBTbm93Zmxha2VDb25uZWN0b3JQcm9maWxlO1xuXG4gIC8qKlxuICAgKiBBIFNub3dmbGFrZSB0YWJsZSBvYmplY3QgKG9wdGlvbmFsbHkgd2l0aCB0aGUgc2NoZW1hKS5cbiAgICovXG4gIHJlYWRvbmx5IG9iamVjdDogU25vd2ZsYWtlRGVzdGluYXRpb25PYmplY3Q7XG5cbiAgLyoqXG4gICAqIFRoZSBzZXR0aW5ncyB0aGF0IGRldGVybWluZSBob3cgQW1hem9uIEFwcEZsb3cgaGFuZGxlcyBhbiBlcnJvciB3aGVuIHBsYWNpbmcgZGF0YSBpbiB0aGUgU2FsZXNmb3JjZSBkZXN0aW5hdGlvbi4gRm9yIGV4YW1wbGUsIHRoaXMgc2V0dGluZyB3b3VsZCBkZXRlcm1pbmUgaWYgdGhlIGZsb3cgc2hvdWxkIGZhaWwgYWZ0ZXIgb25lIGluc2VydGlvbiBlcnJvciwgb3IgY29udGludWUgYW5kIGF0dGVtcHQgdG8gaW5zZXJ0IGV2ZXJ5IHJlY29yZCByZWdhcmRsZXNzIG9mIHRoZSBpbml0aWFsIGZhaWx1cmUuXG4gICAqL1xuICByZWFkb25seSBlcnJvckhhbmRsaW5nPzogRXJyb3JIYW5kbGluZ0NvbmZpZ3VyYXRpb247XG59XG5cbi8qKlxuICogQSBTbm93Zmxha2UgZGVzdGluYXRpb24uXG4gKi9cbmV4cG9ydCBjbGFzcyBTbm93Zmxha2VEZXN0aW5hdGlvbiBpbXBsZW1lbnRzIElEZXN0aW5hdGlvbiB7XG4gIHByaXZhdGUgcmVhZG9ubHkgX2Nvbm5lY3RvclR5cGU6IENvbm5lY3RvclR5cGUgPVxuICAgIFNub3dmbGFrZUNvbm5lY3RvclR5cGUuaW5zdGFuY2U7XG5cbiAgcHVibGljIGdldCBjb25uZWN0b3JUeXBlKCk6IENvbm5lY3RvclR5cGUge1xuICAgIHJldHVybiB0aGlzLl9jb25uZWN0b3JUeXBlO1xuICB9XG5cbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwcm9wczogU25vd2ZsYWtlRGVzdGluYXRpb25Qcm9wcykge31cblxuICBiaW5kKHNjb3BlOiBJRmxvdyk6IENmbkZsb3cuRGVzdGluYXRpb25GbG93Q29uZmlnUHJvcGVydHkge1xuICAgIHRoaXMudHJ5QWRkTm9kZURlcGVuZGVuY3koXG4gICAgICBzY29wZSxcbiAgICAgIHRoaXMucHJvcHMuZXJyb3JIYW5kbGluZz8uZXJyb3JMb2NhdGlvbj8uYnVja2V0LFxuICAgICk7XG4gICAgQXBwRmxvd1Blcm1pc3Npb25zTWFuYWdlci5pbnN0YW5jZSgpLmdyYW50QnVja2V0V3JpdGUoXG4gICAgICB0aGlzLnByb3BzLmVycm9ySGFuZGxpbmc/LmVycm9yTG9jYXRpb24/LmJ1Y2tldCxcbiAgICApO1xuICAgIHRoaXMudHJ5QWRkTm9kZURlcGVuZGVuY3koc2NvcGUsIHRoaXMucHJvcHMucHJvZmlsZSk7XG5cbiAgICByZXR1cm4ge1xuICAgICAgY29ubmVjdG9yVHlwZTogdGhpcy5jb25uZWN0b3JUeXBlLmFzUHJvZmlsZUNvbm5lY3RvclR5cGUsXG4gICAgICBjb25uZWN0b3JQcm9maWxlTmFtZTogdGhpcy5wcm9wcy5wcm9maWxlLm5hbWUsXG4gICAgICBkZXN0aW5hdGlvbkNvbm5lY3RvclByb3BlcnRpZXM6XG4gICAgICAgIHRoaXMuYnVpbGREZXN0aW5hdGlvbkNvbm5lY3RvclByb3BlcnRpZXMoKSxcbiAgICB9O1xuICB9XG5cbiAgcHJpdmF0ZSBidWlsZERlc3RpbmF0aW9uQ29ubmVjdG9yUHJvcGVydGllcygpOiBDZm5GbG93LkRlc3RpbmF0aW9uQ29ubmVjdG9yUHJvcGVydGllc1Byb3BlcnR5IHtcbiAgICByZXR1cm4ge1xuICAgICAgc25vd2ZsYWtlOiB7XG4gICAgICAgIGVycm9ySGFuZGxpbmdDb25maWc6IHRoaXMucHJvcHMuZXJyb3JIYW5kbGluZyAmJiB7XG4gICAgICAgICAgYnVja2V0TmFtZTpcbiAgICAgICAgICAgIHRoaXMucHJvcHMuZXJyb3JIYW5kbGluZz8uZXJyb3JMb2NhdGlvbj8uYnVja2V0LmJ1Y2tldE5hbWUsXG4gICAgICAgICAgYnVja2V0UHJlZml4OiB0aGlzLnByb3BzLmVycm9ySGFuZGxpbmc/LmVycm9yTG9jYXRpb24/LnByZWZpeCxcbiAgICAgICAgICBmYWlsT25GaXJzdEVycm9yOiB0aGlzLnByb3BzLmVycm9ySGFuZGxpbmcuZmFpbE9uRmlyc3RFcnJvcixcbiAgICAgICAgfSxcbiAgICAgICAgLy8gVE9ETzogaWRlbnRpZnkgaWYgdGhpcyBuZWVkcyB0byBiZSB0aGUgc2FtZSBhcyB0aGUgYnVja2V0TmFtZS9wcmVmaXggaW4gdGhlIHByb2ZpbGVcbiAgICAgICAgLy8gICAgICAgZm9yIG5vdyB0aGF0IGlzIHRoZSBhc3N1bXB0aW9uIGFuZCB3ZSdyZSBwdWxsaW5nIHRoaXMgZGF0YSBmcm9tIHRoZSBwcm9maWxlXG4gICAgICAgIGludGVybWVkaWF0ZUJ1Y2tldE5hbWU6IHRoaXMucHJvcHMucHJvZmlsZS5fbG9jYXRpb24uYnVja2V0LmJ1Y2tldE5hbWUsXG4gICAgICAgIGJ1Y2tldFByZWZpeDogdGhpcy5wcm9wcy5wcm9maWxlLl9sb2NhdGlvbi5wcmVmaXgsXG4gICAgICAgIG9iamVjdDogdGhpcy5idWlsZE9iamVjdChcbiAgICAgICAgICB0aGlzLnByb3BzLnByb2ZpbGUuX2RhdGFiYXNlLFxuICAgICAgICAgIHRoaXMucHJvcHMub2JqZWN0LnRhYmxlLFxuICAgICAgICAgIHRoaXMucHJvcHMucHJvZmlsZS5fc2NoZW1hLFxuICAgICAgICApLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG5cbiAgcHJpdmF0ZSBidWlsZE9iamVjdChkYXRhYmFzZTogc3RyaW5nLCB0YWJsZTogc3RyaW5nLCBzY2hlbWE6IHN0cmluZykge1xuICAgIHJldHVybiBgJHtkYXRhYmFzZX0uJHtzY2hlbWF9LiR7dGFibGV9YDtcbiAgfVxuXG4gIHByaXZhdGUgdHJ5QWRkTm9kZURlcGVuZGVuY3koXG4gICAgc2NvcGU6IElDb25zdHJ1Y3QsXG4gICAgcmVzb3VyY2U/OiBJQ29uc3RydWN0IHwgc3RyaW5nLFxuICApOiB2b2lkIHtcbiAgICBpZiAocmVzb3VyY2UgJiYgdHlwZW9mIHJlc291cmNlICE9PSBcInN0cmluZ1wiKSB7XG4gICAgICBzY29wZS5ub2RlLmFkZERlcGVuZGVuY3kocmVzb3VyY2UpO1xuICAgIH1cbiAgfVxufVxuIl19