"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
class SlackSource {
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.SlackConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            apiVersion: this.props.apiVersion,
            connectorProfileName: this.props.profile.name,
            sourceConnectorProperties: this.buildSourceConnectorProperties(),
        };
    }
    buildSourceConnectorProperties() {
        return {
            slack: {
                object: this.props.object,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== "string") {
            scope.node.addDependency(resource);
        }
    }
}
exports.SlackSource = SlackSource;
_a = JSII_RTTI_SYMBOL_1;
SlackSource[_a] = { fqn: "@cdklabs/cdk-appflow.SlackSource", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic291cmNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3NsYWNrL3NvdXJjZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQU9BLGlDQUE0QztBQVc1QyxNQUFhLFdBQVc7SUFHdEIsWUFBNkIsS0FBdUI7UUFBdkIsVUFBSyxHQUFMLEtBQUssQ0FBa0I7UUFGcEMsa0JBQWEsR0FBa0IseUJBQWtCLENBQUMsUUFBUSxDQUFDO0lBRXBCLENBQUM7SUFFeEQsSUFBSSxDQUFDLElBQVc7UUFDZCxJQUFJLENBQUMsb0JBQW9CLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7UUFFcEQsT0FBTztZQUNMLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLHNCQUFzQjtZQUN4RCxVQUFVLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVO1lBQ2pDLG9CQUFvQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUk7WUFDN0MseUJBQXlCLEVBQUUsSUFBSSxDQUFDLDhCQUE4QixFQUFFO1NBQ2pFLENBQUM7SUFDSixDQUFDO0lBRU8sOEJBQThCO1FBQ3BDLE9BQU87WUFDTCxLQUFLLEVBQUU7Z0JBQ0wsTUFBTSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTTthQUMxQjtTQUNGLENBQUM7SUFDSixDQUFDO0lBRU8sb0JBQW9CLENBQzFCLEtBQWlCLEVBQ2pCLFFBQThCO1FBRTlCLElBQUksUUFBUSxJQUFJLE9BQU8sUUFBUSxLQUFLLFFBQVEsRUFBRSxDQUFDO1lBQzdDLEtBQUssQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3JDLENBQUM7SUFDSCxDQUFDOztBQS9CSCxrQ0FnQ0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmbkZsb3cgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWFwcGZsb3dcIjtcbmltcG9ydCB7IElDb25zdHJ1Y3QgfSBmcm9tIFwiY29uc3RydWN0c1wiO1xuaW1wb3J0IHsgU2xhY2tDb25uZWN0b3JQcm9maWxlIH0gZnJvbSBcIi4vcHJvZmlsZVwiO1xuaW1wb3J0IHsgU2xhY2tDb25uZWN0b3JUeXBlIH0gZnJvbSBcIi4vdHlwZVwiO1xuaW1wb3J0IHsgQ29ubmVjdG9yVHlwZSB9IGZyb20gXCIuLi9jb3JlL2Nvbm5lY3RvcnMvY29ubmVjdG9yLXR5cGVcIjtcbmltcG9ydCB7IElGbG93IH0gZnJvbSBcIi4uL2NvcmUvZmxvd3NcIjtcbmltcG9ydCB7IElTb3VyY2UgfSBmcm9tIFwiLi4vY29yZS92ZXJ0aWNlcy9zb3VyY2VcIjtcblxuZXhwb3J0IGludGVyZmFjZSBTbGFja1NvdXJjZVByb3BzIHtcbiAgcmVhZG9ubHkgcHJvZmlsZTogU2xhY2tDb25uZWN0b3JQcm9maWxlO1xuICByZWFkb25seSBvYmplY3Q6IHN0cmluZztcbiAgcmVhZG9ubHkgYXBpVmVyc2lvbj86IHN0cmluZztcbn1cblxuZXhwb3J0IGNsYXNzIFNsYWNrU291cmNlIGltcGxlbWVudHMgSVNvdXJjZSB7XG4gIHB1YmxpYyByZWFkb25seSBjb25uZWN0b3JUeXBlOiBDb25uZWN0b3JUeXBlID0gU2xhY2tDb25uZWN0b3JUeXBlLmluc3RhbmNlO1xuXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IFNsYWNrU291cmNlUHJvcHMpIHt9XG5cbiAgYmluZChmbG93OiBJRmxvdyk6IENmbkZsb3cuU291cmNlRmxvd0NvbmZpZ1Byb3BlcnR5IHtcbiAgICB0aGlzLnRyeUFkZE5vZGVEZXBlbmRlbmN5KGZsb3csIHRoaXMucHJvcHMucHJvZmlsZSk7XG5cbiAgICByZXR1cm4ge1xuICAgICAgY29ubmVjdG9yVHlwZTogdGhpcy5jb25uZWN0b3JUeXBlLmFzUHJvZmlsZUNvbm5lY3RvclR5cGUsXG4gICAgICBhcGlWZXJzaW9uOiB0aGlzLnByb3BzLmFwaVZlcnNpb24sXG4gICAgICBjb25uZWN0b3JQcm9maWxlTmFtZTogdGhpcy5wcm9wcy5wcm9maWxlLm5hbWUsXG4gICAgICBzb3VyY2VDb25uZWN0b3JQcm9wZXJ0aWVzOiB0aGlzLmJ1aWxkU291cmNlQ29ubmVjdG9yUHJvcGVydGllcygpLFxuICAgIH07XG4gIH1cblxuICBwcml2YXRlIGJ1aWxkU291cmNlQ29ubmVjdG9yUHJvcGVydGllcygpOiBDZm5GbG93LlNvdXJjZUNvbm5lY3RvclByb3BlcnRpZXNQcm9wZXJ0eSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHNsYWNrOiB7XG4gICAgICAgIG9iamVjdDogdGhpcy5wcm9wcy5vYmplY3QsXG4gICAgICB9LFxuICAgIH07XG4gIH1cblxuICBwcml2YXRlIHRyeUFkZE5vZGVEZXBlbmRlbmN5KFxuICAgIHNjb3BlOiBJQ29uc3RydWN0LFxuICAgIHJlc291cmNlPzogSUNvbnN0cnVjdCB8IHN0cmluZyxcbiAgKTogdm9pZCB7XG4gICAgaWYgKHJlc291cmNlICYmIHR5cGVvZiByZXNvdXJjZSAhPT0gXCJzdHJpbmdcIikge1xuICAgICAgc2NvcGUubm9kZS5hZGREZXBlbmRlbmN5KHJlc291cmNlKTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==