"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceNowConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_profile_1 = require("../core/connectors/connector-profile");
class ServiceNowConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, {
            arn,
        });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, {
            name,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, props, type_1.ServiceNowConnectorType.instance);
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            serviceNow: {
                username: properties.basicAuth?.username,
                password: properties.basicAuth?.password.unsafeUnwrap(),
            },
        };
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            serviceNow: {
                instanceUrl: properties.instanceUrl,
            },
        };
    }
}
exports.ServiceNowConnectorProfile = ServiceNowConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
ServiceNowConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.ServiceNowConnectorProfile", version: "0.2.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJvZmlsZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9zZXJ2aWNlbm93L3Byb2ZpbGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFPQSxpQ0FBaUQ7QUFDakQsNEVBRzhDO0FBWTlDLE1BQWEsMEJBQTJCLFNBQVEsd0NBQW9CO0lBQzNELE1BQU0sQ0FBQyx3QkFBd0IsQ0FDcEMsS0FBZ0IsRUFDaEIsRUFBVSxFQUNWLEdBQVc7UUFFWCxPQUFPLElBQUksQ0FBQywrQkFBK0IsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ3JELEdBQUc7U0FDSixDQUErQixDQUFDO0lBQ25DLENBQUM7SUFFTSxNQUFNLENBQUMseUJBQXlCLENBQ3JDLEtBQWdCLEVBQ2hCLEVBQVUsRUFDVixJQUFZO1FBRVosT0FBTyxJQUFJLENBQUMsK0JBQStCLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNyRCxJQUFJO1NBQ0wsQ0FBK0IsQ0FBQztJQUNuQyxDQUFDO0lBRUQsWUFDRSxLQUFnQixFQUNoQixFQUFVLEVBQ1YsS0FBc0M7UUFFdEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxFQUFFLDhCQUF1QixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzVELENBQUM7SUFFUyxnQ0FBZ0MsQ0FDeEMsS0FBNEI7UUFFNUIsTUFBTSxVQUFVLEdBQUcsS0FBd0MsQ0FBQztRQUM1RCxPQUFPO1lBQ0wsVUFBVSxFQUFFO2dCQUNWLFFBQVEsRUFBRSxVQUFVLENBQUMsU0FBUyxFQUFFLFFBQVE7Z0JBQ3hDLFFBQVEsRUFBRSxVQUFVLENBQUMsU0FBUyxFQUFFLFFBQVEsQ0FBQyxZQUFZLEVBQUU7YUFDeEQ7U0FDRixDQUFDO0lBQ0osQ0FBQztJQUVTLCtCQUErQixDQUN2QyxLQUE0QjtRQUU1QixNQUFNLFVBQVUsR0FBRyxLQUF3QyxDQUFDO1FBQzVELE9BQU87WUFDTCxVQUFVLEVBQUU7Z0JBQ1YsV0FBVyxFQUFFLFVBQVUsQ0FBQyxXQUFXO2FBQ3BDO1NBQ0YsQ0FBQztJQUNKLENBQUM7O0FBbERILGdFQW1EQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgU2VjcmV0VmFsdWUgfSBmcm9tIFwiYXdzLWNkay1saWJcIjtcbmltcG9ydCB7IENmbkNvbm5lY3RvclByb2ZpbGUgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWFwcGZsb3dcIjtcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyBTZXJ2aWNlTm93Q29ubmVjdG9yVHlwZSB9IGZyb20gXCIuL3R5cGVcIjtcbmltcG9ydCB7XG4gIENvbm5lY3RvclByb2ZpbGVCYXNlLFxuICBDb25uZWN0b3JQcm9maWxlUHJvcHMsXG59IGZyb20gXCIuLi9jb3JlL2Nvbm5lY3RvcnMvY29ubmVjdG9yLXByb2ZpbGVcIjtcblxuZXhwb3J0IGludGVyZmFjZSBTZXJ2aWNlTm93Q29ubmVjdG9yUHJvZmlsZVByb3BzIGV4dGVuZHMgQ29ubmVjdG9yUHJvZmlsZVByb3BzIHtcbiAgcmVhZG9ubHkgYmFzaWNBdXRoOiBTZXJ2aWNlTm93QmFzaWNTZXR0aW5ncztcbiAgcmVhZG9ubHkgaW5zdGFuY2VVcmw6IHN0cmluZztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBTZXJ2aWNlTm93QmFzaWNTZXR0aW5ncyB7XG4gIHJlYWRvbmx5IHVzZXJuYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHBhc3N3b3JkOiBTZWNyZXRWYWx1ZTtcbn1cblxuZXhwb3J0IGNsYXNzIFNlcnZpY2VOb3dDb25uZWN0b3JQcm9maWxlIGV4dGVuZHMgQ29ubmVjdG9yUHJvZmlsZUJhc2Uge1xuICBwdWJsaWMgc3RhdGljIGZyb21Db25uZWN0aW9uUHJvZmlsZUFybihcbiAgICBzY29wZTogQ29uc3RydWN0LFxuICAgIGlkOiBzdHJpbmcsXG4gICAgYXJuOiBzdHJpbmcsXG4gICkge1xuICAgIHJldHVybiB0aGlzLl9mcm9tQ29ubmVjdG9yUHJvZmlsZUF0dHJpYnV0ZXMoc2NvcGUsIGlkLCB7XG4gICAgICBhcm4sXG4gICAgfSkgYXMgU2VydmljZU5vd0Nvbm5lY3RvclByb2ZpbGU7XG4gIH1cblxuICBwdWJsaWMgc3RhdGljIGZyb21Db25uZWN0aW9uUHJvZmlsZU5hbWUoXG4gICAgc2NvcGU6IENvbnN0cnVjdCxcbiAgICBpZDogc3RyaW5nLFxuICAgIG5hbWU6IHN0cmluZyxcbiAgKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Zyb21Db25uZWN0b3JQcm9maWxlQXR0cmlidXRlcyhzY29wZSwgaWQsIHtcbiAgICAgIG5hbWUsXG4gICAgfSkgYXMgU2VydmljZU5vd0Nvbm5lY3RvclByb2ZpbGU7XG4gIH1cblxuICBjb25zdHJ1Y3RvcihcbiAgICBzY29wZTogQ29uc3RydWN0LFxuICAgIGlkOiBzdHJpbmcsXG4gICAgcHJvcHM6IFNlcnZpY2VOb3dDb25uZWN0b3JQcm9maWxlUHJvcHMsXG4gICkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMsIFNlcnZpY2VOb3dDb25uZWN0b3JUeXBlLmluc3RhbmNlKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBidWlsZENvbm5lY3RvclByb2ZpbGVDcmVkZW50aWFscyhcbiAgICBwcm9wczogQ29ubmVjdG9yUHJvZmlsZVByb3BzLFxuICApOiBDZm5Db25uZWN0b3JQcm9maWxlLkNvbm5lY3RvclByb2ZpbGVDcmVkZW50aWFsc1Byb3BlcnR5IHtcbiAgICBjb25zdCBwcm9wZXJ0aWVzID0gcHJvcHMgYXMgU2VydmljZU5vd0Nvbm5lY3RvclByb2ZpbGVQcm9wcztcbiAgICByZXR1cm4ge1xuICAgICAgc2VydmljZU5vdzoge1xuICAgICAgICB1c2VybmFtZTogcHJvcGVydGllcy5iYXNpY0F1dGg/LnVzZXJuYW1lLFxuICAgICAgICBwYXNzd29yZDogcHJvcGVydGllcy5iYXNpY0F1dGg/LnBhc3N3b3JkLnVuc2FmZVVud3JhcCgpLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG5cbiAgcHJvdGVjdGVkIGJ1aWxkQ29ubmVjdG9yUHJvZmlsZVByb3BlcnRpZXMoXG4gICAgcHJvcHM6IENvbm5lY3RvclByb2ZpbGVQcm9wcyxcbiAgKTogQ2ZuQ29ubmVjdG9yUHJvZmlsZS5Db25uZWN0b3JQcm9maWxlUHJvcGVydGllc1Byb3BlcnR5IHtcbiAgICBjb25zdCBwcm9wZXJ0aWVzID0gcHJvcHMgYXMgU2VydmljZU5vd0Nvbm5lY3RvclByb2ZpbGVQcm9wcztcbiAgICByZXR1cm4ge1xuICAgICAgc2VydmljZU5vdzoge1xuICAgICAgICBpbnN0YW5jZVVybDogcHJvcGVydGllcy5pbnN0YW5jZVVybCxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxufVxuIl19