"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SAPOdataConnectorType = void 0;
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const connector_type_1 = require("../core/connectors/connector-type");
/**
 * @internal
 */
class SAPOdataConnectorType extends connector_type_1.ConnectorType {
    static get instance() {
        if (!SAPOdataConnectorType.actualInstance) {
            SAPOdataConnectorType.actualInstance = new SAPOdataConnectorType();
        }
        return SAPOdataConnectorType.actualInstance;
    }
    constructor() {
        super("SAPOData", false);
    }
    get asTaskConnectorOperatorOrigin() {
        return "sapoData";
    }
    get asProfileConnectorType() {
        return this.name;
    }
}
exports.SAPOdataConnectorType = SAPOdataConnectorType;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9zYXBvZGF0YS90eXBlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBOzs7RUFHRTtBQUNGLHNFQUFrRTtBQUVsRTs7R0FFRztBQUNILE1BQWEscUJBQXNCLFNBQVEsOEJBQWE7SUFDL0MsTUFBTSxLQUFLLFFBQVE7UUFDeEIsSUFBSSxDQUFDLHFCQUFxQixDQUFDLGNBQWMsRUFBRSxDQUFDO1lBQzFDLHFCQUFxQixDQUFDLGNBQWMsR0FBRyxJQUFJLHFCQUFxQixFQUFFLENBQUM7UUFDckUsQ0FBQztRQUNELE9BQU8scUJBQXFCLENBQUMsY0FBYyxDQUFDO0lBQzlDLENBQUM7SUFJRDtRQUNFLEtBQUssQ0FBQyxVQUFVLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDM0IsQ0FBQztJQUVELElBQVcsNkJBQTZCO1FBQ3RDLE9BQU8sVUFBVSxDQUFDO0lBQ3BCLENBQUM7SUFFRCxJQUFXLHNCQUFzQjtRQUMvQixPQUFPLElBQUksQ0FBQyxJQUFJLENBQUM7SUFDbkIsQ0FBQztDQUNGO0FBckJELHNEQXFCQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgQ29ubmVjdG9yVHlwZSB9IGZyb20gXCIuLi9jb3JlL2Nvbm5lY3RvcnMvY29ubmVjdG9yLXR5cGVcIjtcblxuLyoqXG4gKiBAaW50ZXJuYWxcbiAqL1xuZXhwb3J0IGNsYXNzIFNBUE9kYXRhQ29ubmVjdG9yVHlwZSBleHRlbmRzIENvbm5lY3RvclR5cGUge1xuICBwdWJsaWMgc3RhdGljIGdldCBpbnN0YW5jZSgpOiBDb25uZWN0b3JUeXBlIHtcbiAgICBpZiAoIVNBUE9kYXRhQ29ubmVjdG9yVHlwZS5hY3R1YWxJbnN0YW5jZSkge1xuICAgICAgU0FQT2RhdGFDb25uZWN0b3JUeXBlLmFjdHVhbEluc3RhbmNlID0gbmV3IFNBUE9kYXRhQ29ubmVjdG9yVHlwZSgpO1xuICAgIH1cbiAgICByZXR1cm4gU0FQT2RhdGFDb25uZWN0b3JUeXBlLmFjdHVhbEluc3RhbmNlO1xuICB9XG5cbiAgcHJpdmF0ZSBzdGF0aWMgYWN0dWFsSW5zdGFuY2U6IENvbm5lY3RvclR5cGU7XG5cbiAgY29uc3RydWN0b3IoKSB7XG4gICAgc3VwZXIoXCJTQVBPRGF0YVwiLCBmYWxzZSk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGFzVGFza0Nvbm5lY3Rvck9wZXJhdG9yT3JpZ2luKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIFwic2Fwb0RhdGFcIjtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgYXNQcm9maWxlQ29ubmVjdG9yVHlwZSgpOiBzdHJpbmcge1xuICAgIHJldHVybiB0aGlzLm5hbWU7XG4gIH1cbn1cbiJdfQ==